<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TOrganizacja StructType
 * Meta information extracted from the WSDL
 * - documentation: Dane organizacji
 * @subpackage Structs
 */
class TOrganizacja extends TDanePodmiotu
{
    /**
     * The Nazwa
     * Meta information extracted from the WSDL
     * - documentation: Nazwa organizacji
     * - base: xs:string
     * - maxLength: 2000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Nazwa;
    /**
     * The REGON
     * Meta information extracted from the WSDL
     * - documentation: Numer w rejestrze REGON
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{9}|\d{14}
     * @var string
     */
    public $REGON;
    /**
     * The KRS
     * Meta information extracted from the WSDL
     * - documentation: Numer KRS | Numer Krajowego Rejestru Sądowego
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{10}
     * @var string
     */
    public $KRS;
    /**
     * The NazwaSkrocona
     * Meta information extracted from the WSDL
     * - documentation: Nazwa skrócona organizacji | Skrócona nazwa podmiotu
     * - base: xs:string
     * - maxLength: 70
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NazwaSkrocona;
    /**
     * The AdresSiedziby
     * Meta information extracted from the WSDL
     * - documentation: Adres siedziby organizacji
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TAdres
     */
    public $AdresSiedziby;
    /**
     * The AdresDodatkowy
     * Meta information extracted from the WSDL
     * - documentation: Adres dodatkowy organizacji
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TAdres[]
     */
    public $AdresDodatkowy;
    /**
     * Constructor method for TOrganizacja
     * @uses TOrganizacja::setNazwa()
     * @uses TOrganizacja::setREGON()
     * @uses TOrganizacja::setKRS()
     * @uses TOrganizacja::setNazwaSkrocona()
     * @uses TOrganizacja::setAdresSiedziby()
     * @uses TOrganizacja::setAdresDodatkowy()
     * @param string $nazwa
     * @param string $rEGON
     * @param string $kRS
     * @param string $nazwaSkrocona
     * @param \StructType\TAdres $adresSiedziby
     * @param \StructType\TAdres[] $adresDodatkowy
     */
    public function __construct($nazwa = null, $rEGON = null, $kRS = null, $nazwaSkrocona = null, \StructType\TAdres $adresSiedziby = null, array $adresDodatkowy = array())
    {
        $this
            ->setNazwa($nazwa)
            ->setREGON($rEGON)
            ->setKRS($kRS)
            ->setNazwaSkrocona($nazwaSkrocona)
            ->setAdresSiedziby($adresSiedziby)
            ->setAdresDodatkowy($adresDodatkowy);
    }
    /**
     * Get Nazwa value
     * @return string
     */
    public function getNazwa()
    {
        return $this->Nazwa;
    }
    /**
     * Set Nazwa value
     * @param string $nazwa
     * @return \StructType\TOrganizacja
     */
    public function setNazwa($nazwa = null)
    {
        // validation for constraint: string
        if (!is_null($nazwa) && !is_string($nazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwa, true), gettype($nazwa)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($nazwa) && mb_strlen($nazwa) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($nazwa)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwa) && mb_strlen($nazwa) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwa)), __LINE__);
        }
        $this->Nazwa = $nazwa;
        return $this;
    }
    /**
     * Get REGON value
     * @return string
     */
    public function getREGON()
    {
        return $this->REGON;
    }
    /**
     * Set REGON value
     * @param string $rEGON
     * @return \StructType\TOrganizacja
     */
    public function setREGON($rEGON = null)
    {
        // validation for constraint: string
        if (!is_null($rEGON) && !is_string($rEGON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEGON, true), gettype($rEGON)), __LINE__);
        }
        // validation for constraint: pattern(\d{9}|\d{14})
        if (!is_null($rEGON) && !preg_match('/\\d{9}|\\d{14}/', $rEGON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}|\d{14}', var_export($rEGON, true)), __LINE__);
        }
        $this->REGON = $rEGON;
        return $this;
    }
    /**
     * Get KRS value
     * @return string|null
     */
    public function getKRS()
    {
        return $this->KRS;
    }
    /**
     * Set KRS value
     * @param string $kRS
     * @return \StructType\TOrganizacja
     */
    public function setKRS($kRS = null)
    {
        // validation for constraint: string
        if (!is_null($kRS) && !is_string($kRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kRS, true), gettype($kRS)), __LINE__);
        }
        // validation for constraint: pattern(\d{10})
        if (!is_null($kRS) && !preg_match('/\\d{10}/', $kRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{10}', var_export($kRS, true)), __LINE__);
        }
        $this->KRS = $kRS;
        return $this;
    }
    /**
     * Get NazwaSkrocona value
     * @return string|null
     */
    public function getNazwaSkrocona()
    {
        return $this->NazwaSkrocona;
    }
    /**
     * Set NazwaSkrocona value
     * @param string $nazwaSkrocona
     * @return \StructType\TOrganizacja
     */
    public function setNazwaSkrocona($nazwaSkrocona = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaSkrocona) && !is_string($nazwaSkrocona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaSkrocona, true), gettype($nazwaSkrocona)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($nazwaSkrocona) && mb_strlen($nazwaSkrocona) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($nazwaSkrocona)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwaSkrocona) && mb_strlen($nazwaSkrocona) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwaSkrocona)), __LINE__);
        }
        $this->NazwaSkrocona = $nazwaSkrocona;
        return $this;
    }
    /**
     * Get AdresSiedziby value
     * @return \StructType\TAdres|null
     */
    public function getAdresSiedziby()
    {
        return $this->AdresSiedziby;
    }
    /**
     * Set AdresSiedziby value
     * @param \StructType\TAdres $adresSiedziby
     * @return \StructType\TOrganizacja
     */
    public function setAdresSiedziby(\StructType\TAdres $adresSiedziby = null)
    {
        $this->AdresSiedziby = $adresSiedziby;
        return $this;
    }
    /**
     * Get AdresDodatkowy value
     * @return \StructType\TAdres[]|null
     */
    public function getAdresDodatkowy()
    {
        return $this->AdresDodatkowy;
    }
    /**
     * This method is responsible for validating the values passed to the setAdresDodatkowy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdresDodatkowy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdresDodatkowyForArrayConstraintsFromSetAdresDodatkowy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tOrganizacjaAdresDodatkowyItem) {
            // validation for constraint: itemType
            if (!$tOrganizacjaAdresDodatkowyItem instanceof \StructType\TAdres) {
                $invalidValues[] = is_object($tOrganizacjaAdresDodatkowyItem) ? get_class($tOrganizacjaAdresDodatkowyItem) : sprintf('%s(%s)', gettype($tOrganizacjaAdresDodatkowyItem), var_export($tOrganizacjaAdresDodatkowyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdresDodatkowy property can only contain items of type \StructType\TAdres, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdresDodatkowy value
     * @throws \InvalidArgumentException
     * @param \StructType\TAdres[] $adresDodatkowy
     * @return \StructType\TOrganizacja
     */
    public function setAdresDodatkowy(array $adresDodatkowy = array())
    {
        // validation for constraint: array
        if ('' !== ($adresDodatkowyArrayErrorMessage = self::validateAdresDodatkowyForArrayConstraintsFromSetAdresDodatkowy($adresDodatkowy))) {
            throw new \InvalidArgumentException($adresDodatkowyArrayErrorMessage, __LINE__);
        }
        $this->AdresDodatkowy = $adresDodatkowy;
        return $this;
    }
    /**
     * Add item to AdresDodatkowy value
     * @throws \InvalidArgumentException
     * @param \StructType\TAdres $item
     * @return \StructType\TOrganizacja
     */
    public function addToAdresDodatkowy(\StructType\TAdres $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TAdres) {
            throw new \InvalidArgumentException(sprintf('The AdresDodatkowy property can only contain items of type \StructType\TAdres, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdresDodatkowy[] = $item;
        return $this;
    }
}
