<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TDzialanoscGospodarcza StructType
 * Meta information extracted from the WSDL
 * - documentation: Działalność gospodarcza prowadzona przez osobę fizyczną
 * @subpackage Structs
 */
class TDzialanoscGospodarcza extends AbstractStructBase
{
    /**
     * The Nazwa
     * Meta information extracted from the WSDL
     * - documentation: Nazwa, pod którą prowadzona jest działalność
     * - base: xs:string
     * - maxLength: 2000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Nazwa;
    /**
     * The REGON
     * Meta information extracted from the WSDL
     * - documentation: Numer wrejestrze REGON | Numer w rejestrze REGON
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{9}|\d{14}
     * @var string
     */
    public $REGON;
    /**
     * The AdresProwadzenia
     * Meta information extracted from the WSDL
     * - documentation: Adres prowadzenia działalności gospodarczej
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TAdres
     */
    public $AdresProwadzenia;
    /**
     * The NazwaSkrocona
     * Meta information extracted from the WSDL
     * - documentation: Nazwa skrócona | Skrócona nazwa podmiotu
     * - base: xs:string
     * - maxLength: 70
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NazwaSkrocona;
    /**
     * The DodatkowyAdresProwadzenia
     * Meta information extracted from the WSDL
     * - documentation: Dodatkowy adres prowadzenia działalnosci gospodarczej
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TAdres[]
     */
    public $DodatkowyAdresProwadzenia;
    /**
     * Constructor method for TDzialanoscGospodarcza
     * @uses TDzialanoscGospodarcza::setNazwa()
     * @uses TDzialanoscGospodarcza::setREGON()
     * @uses TDzialanoscGospodarcza::setAdresProwadzenia()
     * @uses TDzialanoscGospodarcza::setNazwaSkrocona()
     * @uses TDzialanoscGospodarcza::setDodatkowyAdresProwadzenia()
     * @param string $nazwa
     * @param string $rEGON
     * @param \StructType\TAdres $adresProwadzenia
     * @param string $nazwaSkrocona
     * @param \StructType\TAdres[] $dodatkowyAdresProwadzenia
     */
    public function __construct($nazwa = null, $rEGON = null, \StructType\TAdres $adresProwadzenia = null, $nazwaSkrocona = null, array $dodatkowyAdresProwadzenia = array())
    {
        $this
            ->setNazwa($nazwa)
            ->setREGON($rEGON)
            ->setAdresProwadzenia($adresProwadzenia)
            ->setNazwaSkrocona($nazwaSkrocona)
            ->setDodatkowyAdresProwadzenia($dodatkowyAdresProwadzenia);
    }
    /**
     * Get Nazwa value
     * @return string
     */
    public function getNazwa()
    {
        return $this->Nazwa;
    }
    /**
     * Set Nazwa value
     * @param string $nazwa
     * @return \StructType\TDzialanoscGospodarcza
     */
    public function setNazwa($nazwa = null)
    {
        // validation for constraint: string
        if (!is_null($nazwa) && !is_string($nazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwa, true), gettype($nazwa)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($nazwa) && mb_strlen($nazwa) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($nazwa)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwa) && mb_strlen($nazwa) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwa)), __LINE__);
        }
        $this->Nazwa = $nazwa;
        return $this;
    }
    /**
     * Get REGON value
     * @return string
     */
    public function getREGON()
    {
        return $this->REGON;
    }
    /**
     * Set REGON value
     * @param string $rEGON
     * @return \StructType\TDzialanoscGospodarcza
     */
    public function setREGON($rEGON = null)
    {
        // validation for constraint: string
        if (!is_null($rEGON) && !is_string($rEGON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEGON, true), gettype($rEGON)), __LINE__);
        }
        // validation for constraint: pattern(\d{9}|\d{14})
        if (!is_null($rEGON) && !preg_match('/\\d{9}|\\d{14}/', $rEGON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{9}|\d{14}', var_export($rEGON, true)), __LINE__);
        }
        $this->REGON = $rEGON;
        return $this;
    }
    /**
     * Get AdresProwadzenia value
     * @return \StructType\TAdres
     */
    public function getAdresProwadzenia()
    {
        return $this->AdresProwadzenia;
    }
    /**
     * Set AdresProwadzenia value
     * @param \StructType\TAdres $adresProwadzenia
     * @return \StructType\TDzialanoscGospodarcza
     */
    public function setAdresProwadzenia(\StructType\TAdres $adresProwadzenia = null)
    {
        $this->AdresProwadzenia = $adresProwadzenia;
        return $this;
    }
    /**
     * Get NazwaSkrocona value
     * @return string|null
     */
    public function getNazwaSkrocona()
    {
        return $this->NazwaSkrocona;
    }
    /**
     * Set NazwaSkrocona value
     * @param string $nazwaSkrocona
     * @return \StructType\TDzialanoscGospodarcza
     */
    public function setNazwaSkrocona($nazwaSkrocona = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaSkrocona) && !is_string($nazwaSkrocona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaSkrocona, true), gettype($nazwaSkrocona)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($nazwaSkrocona) && mb_strlen($nazwaSkrocona) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($nazwaSkrocona)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwaSkrocona) && mb_strlen($nazwaSkrocona) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwaSkrocona)), __LINE__);
        }
        $this->NazwaSkrocona = $nazwaSkrocona;
        return $this;
    }
    /**
     * Get DodatkowyAdresProwadzenia value
     * @return \StructType\TAdres[]|null
     */
    public function getDodatkowyAdresProwadzenia()
    {
        return $this->DodatkowyAdresProwadzenia;
    }
    /**
     * This method is responsible for validating the values passed to the setDodatkowyAdresProwadzenia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDodatkowyAdresProwadzenia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDodatkowyAdresProwadzeniaForArrayConstraintsFromSetDodatkowyAdresProwadzenia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tDzialanoscGospodarczaDodatkowyAdresProwadzeniaItem) {
            // validation for constraint: itemType
            if (!$tDzialanoscGospodarczaDodatkowyAdresProwadzeniaItem instanceof \StructType\TAdres) {
                $invalidValues[] = is_object($tDzialanoscGospodarczaDodatkowyAdresProwadzeniaItem) ? get_class($tDzialanoscGospodarczaDodatkowyAdresProwadzeniaItem) : sprintf('%s(%s)', gettype($tDzialanoscGospodarczaDodatkowyAdresProwadzeniaItem), var_export($tDzialanoscGospodarczaDodatkowyAdresProwadzeniaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DodatkowyAdresProwadzenia property can only contain items of type \StructType\TAdres, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DodatkowyAdresProwadzenia value
     * @throws \InvalidArgumentException
     * @param \StructType\TAdres[] $dodatkowyAdresProwadzenia
     * @return \StructType\TDzialanoscGospodarcza
     */
    public function setDodatkowyAdresProwadzenia(array $dodatkowyAdresProwadzenia = array())
    {
        // validation for constraint: array
        if ('' !== ($dodatkowyAdresProwadzeniaArrayErrorMessage = self::validateDodatkowyAdresProwadzeniaForArrayConstraintsFromSetDodatkowyAdresProwadzenia($dodatkowyAdresProwadzenia))) {
            throw new \InvalidArgumentException($dodatkowyAdresProwadzeniaArrayErrorMessage, __LINE__);
        }
        $this->DodatkowyAdresProwadzenia = $dodatkowyAdresProwadzenia;
        return $this;
    }
    /**
     * Add item to DodatkowyAdresProwadzenia value
     * @throws \InvalidArgumentException
     * @param \StructType\TAdres $item
     * @return \StructType\TDzialanoscGospodarcza
     */
    public function addToDodatkowyAdresProwadzenia(\StructType\TAdres $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TAdres) {
            throw new \InvalidArgumentException(sprintf('The DodatkowyAdresProwadzenia property can only contain items of type \StructType\TAdres, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DodatkowyAdresProwadzenia[] = $item;
        return $this;
    }
}
