<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAdresZagraniczny StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacje opisujące adres zagraniczny
 * @subpackage Structs
 */
class TAdresZagraniczny extends AbstractStructBase
{
    /**
     * The KodKraju
     * Meta information extracted from the WSDL
     * - documentation: Kod kraju, którego dotyczy adres. | Kod kraju
     * - base: xs:string
     * - length: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z][A-Z]
     * @var string
     */
    public $KodKraju;
    /**
     * The Miejscowosc
     * Meta information extracted from the WSDL
     * - documentation: Nazwa miejscowości [City] | Typ określający nazwę miejscowości
     * - base: xs:string
     * - maxLength: 90
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Miejscowosc;
    /**
     * The KodPocztowy
     * Meta information extracted from the WSDL
     * - documentation: Kod pocztowy [Postal code] | Kod pocztowy
     * - base: xs:token
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $KodPocztowy;
    /**
     * The Ulica
     * Meta information extracted from the WSDL
     * - documentation: Nazwa ulicy [Street] | Nazwa ulicy
     * - base: xs:token
     * - maxLength: 200
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ulica;
    /**
     * The NrDomu
     * Meta information extracted from the WSDL
     * - documentation: Numer budynku [Building number] | Numer budynku
     * - base: xs:token
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NrDomu;
    /**
     * The NrLokalu
     * Meta information extracted from the WSDL
     * - documentation: Numer lokalu [Flat number] | Numer lokalu
     * - base: xs:token
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NrLokalu;
    /**
     * Constructor method for TAdresZagraniczny
     * @uses TAdresZagraniczny::setKodKraju()
     * @uses TAdresZagraniczny::setMiejscowosc()
     * @uses TAdresZagraniczny::setKodPocztowy()
     * @uses TAdresZagraniczny::setUlica()
     * @uses TAdresZagraniczny::setNrDomu()
     * @uses TAdresZagraniczny::setNrLokalu()
     * @param string $kodKraju
     * @param string $miejscowosc
     * @param string $kodPocztowy
     * @param string $ulica
     * @param string $nrDomu
     * @param string $nrLokalu
     */
    public function __construct($kodKraju = null, $miejscowosc = null, $kodPocztowy = null, $ulica = null, $nrDomu = null, $nrLokalu = null)
    {
        $this
            ->setKodKraju($kodKraju)
            ->setMiejscowosc($miejscowosc)
            ->setKodPocztowy($kodPocztowy)
            ->setUlica($ulica)
            ->setNrDomu($nrDomu)
            ->setNrLokalu($nrLokalu);
    }
    /**
     * Get KodKraju value
     * @return string
     */
    public function getKodKraju()
    {
        return $this->KodKraju;
    }
    /**
     * Set KodKraju value
     * @param string $kodKraju
     * @return \StructType\TAdresZagraniczny
     */
    public function setKodKraju($kodKraju = null)
    {
        // validation for constraint: string
        if (!is_null($kodKraju) && !is_string($kodKraju)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodKraju, true), gettype($kodKraju)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($kodKraju) && mb_strlen($kodKraju) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($kodKraju)), __LINE__);
        }
        // validation for constraint: pattern([A-Z][A-Z])
        if (!is_null($kodKraju) && !preg_match('/[A-Z][A-Z]/', $kodKraju)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z][A-Z]', var_export($kodKraju, true)), __LINE__);
        }
        $this->KodKraju = $kodKraju;
        return $this;
    }
    /**
     * Get Miejscowosc value
     * @return string
     */
    public function getMiejscowosc()
    {
        return $this->Miejscowosc;
    }
    /**
     * Set Miejscowosc value
     * @param string $miejscowosc
     * @return \StructType\TAdresZagraniczny
     */
    public function setMiejscowosc($miejscowosc = null)
    {
        // validation for constraint: string
        if (!is_null($miejscowosc) && !is_string($miejscowosc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($miejscowosc, true), gettype($miejscowosc)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen($miejscowosc)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($miejscowosc)), __LINE__);
        }
        $this->Miejscowosc = $miejscowosc;
        return $this;
    }
    /**
     * Get KodPocztowy value
     * @return string|null
     */
    public function getKodPocztowy()
    {
        return $this->KodPocztowy;
    }
    /**
     * Set KodPocztowy value
     * @param string $kodPocztowy
     * @return \StructType\TAdresZagraniczny
     */
    public function setKodPocztowy($kodPocztowy = null)
    {
        // validation for constraint: string
        if (!is_null($kodPocztowy) && !is_string($kodPocztowy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodPocztowy, true), gettype($kodPocztowy)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($kodPocztowy) && mb_strlen($kodPocztowy) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($kodPocztowy)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kodPocztowy) && mb_strlen($kodPocztowy) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kodPocztowy)), __LINE__);
        }
        $this->KodPocztowy = $kodPocztowy;
        return $this;
    }
    /**
     * Get Ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->Ulica;
    }
    /**
     * Set Ulica value
     * @param string $ulica
     * @return \StructType\TAdresZagraniczny
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ulica) && mb_strlen($ulica) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($ulica)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ulica) && mb_strlen($ulica) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ulica)), __LINE__);
        }
        $this->Ulica = $ulica;
        return $this;
    }
    /**
     * Get NrDomu value
     * @return string|null
     */
    public function getNrDomu()
    {
        return $this->NrDomu;
    }
    /**
     * Set NrDomu value
     * @param string $nrDomu
     * @return \StructType\TAdresZagraniczny
     */
    public function setNrDomu($nrDomu = null)
    {
        // validation for constraint: string
        if (!is_null($nrDomu) && !is_string($nrDomu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrDomu, true), gettype($nrDomu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrDomu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrDomu)), __LINE__);
        }
        $this->NrDomu = $nrDomu;
        return $this;
    }
    /**
     * Get NrLokalu value
     * @return string|null
     */
    public function getNrLokalu()
    {
        return $this->NrLokalu;
    }
    /**
     * Set NrLokalu value
     * @param string $nrLokalu
     * @return \StructType\TAdresZagraniczny
     */
    public function setNrLokalu($nrLokalu = null)
    {
        // validation for constraint: string
        if (!is_null($nrLokalu) && !is_string($nrLokalu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrLokalu, true), gettype($nrLokalu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrLokalu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrLokalu)), __LINE__);
        }
        $this->NrLokalu = $nrLokalu;
        return $this;
    }
}
