<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SzczegolyWnioskuTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Szczegóły wniosku o informacje o spółkach i beneficjentach.
 * @subpackage Structs
 */
class SzczegolyWnioskuTyp extends AbstractStructBase
{
    /**
     * The NIP
     * Meta information extracted from the WSDL
     * - documentation: Numer NIP spółki, dla której chemy otrzymać informację o niej i o jej beneficjentach rzeczywistych. | Identyfikator NIP
     * - base: xs:string
     * - choice: NIP | PESEL | DataUrodzenia | PierwszeImie | Nazwisko
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [1-9]((\d[1-9])|([1-9]\d))\d{7}
     * @var string
     */
    public $NIP;
    /**
     * The PESEL
     * Meta information extracted from the WSDL
     * - documentation: Numer PESEL osoby, dla której chemy otrzymać informację o niej i spółkach, w których dana osoba jest beneficjentem. | Numer w rejestrze PESEL
     * - base: xs:string
     * - choice: NIP | PESEL | DataUrodzenia | PierwszeImie | Nazwisko
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \d{11}
     * @var string
     */
    public $PESEL;
    /**
     * The DataUrodzenia
     * Meta information extracted from the WSDL
     * - documentation: Data urodzenia dla beneficjenta nieposiadającego numeru PESEL.
     * - choice: NIP | PESEL | DataUrodzenia | PierwszeImie | Nazwisko
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $DataUrodzenia;
    /**
     * The PierwszeImie
     * Meta information extracted from the WSDL
     * - documentation: Pierwsze imię beneficjenta rzeczywistego. | Imię
     * - base: xs:token
     * - choice: NIP | PESEL | DataUrodzenia | PierwszeImie | Nazwisko
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 120
     * - minLength: 1
     * @var string
     */
    public $PierwszeImie;
    /**
     * The Nazwisko
     * Meta information extracted from the WSDL
     * - documentation: Nazwisko beneficjenta rzeczywistego. | Nazwisko
     * - base: xs:token
     * - choice: NIP | PESEL | DataUrodzenia | PierwszeImie | Nazwisko
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Nazwisko;
    /**
     * The DataOd
     * Meta information extracted from the WSDL
     * - documentation: Data od (włącznie) wyznaczająca zakres wyszukania informacji o spółkach i beneficjentach rzeczywistych.
     * - minOccurs: 0
     * @var string
     */
    public $DataOd;
    /**
     * The DataDo
     * Meta information extracted from the WSDL
     * - documentation: Data do (włącznie) wyznaczająca zakres wyszukania informacji o spółkach i beneficjentach rzeczywistych.
     * - minOccurs: 0
     * @var string
     */
    public $DataDo;
    /**
     * Constructor method for SzczegolyWnioskuTyp
     * @uses SzczegolyWnioskuTyp::setNIP()
     * @uses SzczegolyWnioskuTyp::setPESEL()
     * @uses SzczegolyWnioskuTyp::setDataUrodzenia()
     * @uses SzczegolyWnioskuTyp::setPierwszeImie()
     * @uses SzczegolyWnioskuTyp::setNazwisko()
     * @uses SzczegolyWnioskuTyp::setDataOd()
     * @uses SzczegolyWnioskuTyp::setDataDo()
     * @param string $nIP
     * @param string $pESEL
     * @param string $dataUrodzenia
     * @param string $pierwszeImie
     * @param string $nazwisko
     * @param string $dataOd
     * @param string $dataDo
     */
    public function __construct($nIP = null, $pESEL = null, $dataUrodzenia = null, $pierwszeImie = null, $nazwisko = null, $dataOd = null, $dataDo = null)
    {
        $this
            ->setNIP($nIP)
            ->setPESEL($pESEL)
            ->setDataUrodzenia($dataUrodzenia)
            ->setPierwszeImie($pierwszeImie)
            ->setNazwisko($nazwisko)
            ->setDataOd($dataOd)
            ->setDataDo($dataDo);
    }
    /**
     * Get NIP value
     * @return string|null
     */
    public function getNIP()
    {
        return isset($this->NIP) ? $this->NIP : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNIP method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNIP method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNIPForChoiceConstraintsFromSetNIP($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PESEL',
            'DataUrodzenia',
            'PierwszeImie',
            'Nazwisko',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NIP can\'t be set as the property %s is already set. Only one property must be set among these properties: NIP, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NIP value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $nIP
     * @return \StructType\SzczegolyWnioskuTyp
     */
    public function setNIP($nIP = null)
    {
        // validation for constraint: string
        if (!is_null($nIP) && !is_string($nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nIP, true), gettype($nIP)), __LINE__);
        }
        // validation for constraint: choice(NIP, PESEL, DataUrodzenia, PierwszeImie, Nazwisko)
        if ('' !== ($nIPChoiceErrorMessage = self::validateNIPForChoiceConstraintsFromSetNIP($nIP))) {
            throw new \InvalidArgumentException($nIPChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([1-9]((\d[1-9])|([1-9]\d))\d{7})
        if (!is_null($nIP) && !preg_match('/[1-9]((\\d[1-9])|([1-9]\\d))\\d{7}/', $nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]((\d[1-9])|([1-9]\d))\d{7}', var_export($nIP, true)), __LINE__);
        }
        if (is_null($nIP) || (is_array($nIP) && empty($nIP))) {
            unset($this->NIP);
        } else {
            $this->NIP = $nIP;
        }
        return $this;
    }
    /**
     * Get PESEL value
     * @return string|null
     */
    public function getPESEL()
    {
        return isset($this->PESEL) ? $this->PESEL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPESEL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPESEL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePESELForChoiceConstraintsFromSetPESEL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NIP',
            'DataUrodzenia',
            'PierwszeImie',
            'Nazwisko',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PESEL can\'t be set as the property %s is already set. Only one property must be set among these properties: PESEL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PESEL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pESEL
     * @return \StructType\SzczegolyWnioskuTyp
     */
    public function setPESEL($pESEL = null)
    {
        // validation for constraint: string
        if (!is_null($pESEL) && !is_string($pESEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pESEL, true), gettype($pESEL)), __LINE__);
        }
        // validation for constraint: choice(NIP, PESEL, DataUrodzenia, PierwszeImie, Nazwisko)
        if ('' !== ($pESELChoiceErrorMessage = self::validatePESELForChoiceConstraintsFromSetPESEL($pESEL))) {
            throw new \InvalidArgumentException($pESELChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\d{11})
        if (!is_null($pESEL) && !preg_match('/\\d{11}/', $pESEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{11}', var_export($pESEL, true)), __LINE__);
        }
        if (is_null($pESEL) || (is_array($pESEL) && empty($pESEL))) {
            unset($this->PESEL);
        } else {
            $this->PESEL = $pESEL;
        }
        return $this;
    }
    /**
     * Get DataUrodzenia value
     * @return string|null
     */
    public function getDataUrodzenia()
    {
        return isset($this->DataUrodzenia) ? $this->DataUrodzenia : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDataUrodzenia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDataUrodzenia method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDataUrodzeniaForChoiceConstraintsFromSetDataUrodzenia($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NIP',
            'PESEL',
            'PierwszeImie',
            'Nazwisko',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DataUrodzenia can\'t be set as the property %s is already set. Only one property must be set among these properties: DataUrodzenia, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DataUrodzenia value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dataUrodzenia
     * @return \StructType\SzczegolyWnioskuTyp
     */
    public function setDataUrodzenia($dataUrodzenia = null)
    {
        // validation for constraint: string
        if (!is_null($dataUrodzenia) && !is_string($dataUrodzenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataUrodzenia, true), gettype($dataUrodzenia)), __LINE__);
        }
        // validation for constraint: choice(NIP, PESEL, DataUrodzenia, PierwszeImie, Nazwisko)
        if ('' !== ($dataUrodzeniaChoiceErrorMessage = self::validateDataUrodzeniaForChoiceConstraintsFromSetDataUrodzenia($dataUrodzenia))) {
            throw new \InvalidArgumentException($dataUrodzeniaChoiceErrorMessage, __LINE__);
        }
        if (is_null($dataUrodzenia) || (is_array($dataUrodzenia) && empty($dataUrodzenia))) {
            unset($this->DataUrodzenia);
        } else {
            $this->DataUrodzenia = $dataUrodzenia;
        }
        return $this;
    }
    /**
     * Get PierwszeImie value
     * @return string|null
     */
    public function getPierwszeImie()
    {
        return isset($this->PierwszeImie) ? $this->PierwszeImie : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPierwszeImie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPierwszeImie method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePierwszeImieForChoiceConstraintsFromSetPierwszeImie($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NIP',
            'PESEL',
            'DataUrodzenia',
            'Nazwisko',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PierwszeImie can\'t be set as the property %s is already set. Only one property must be set among these properties: PierwszeImie, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PierwszeImie value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pierwszeImie
     * @return \StructType\SzczegolyWnioskuTyp
     */
    public function setPierwszeImie($pierwszeImie = null)
    {
        // validation for constraint: string
        if (!is_null($pierwszeImie) && !is_string($pierwszeImie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pierwszeImie, true), gettype($pierwszeImie)), __LINE__);
        }
        // validation for constraint: choice(NIP, PESEL, DataUrodzenia, PierwszeImie, Nazwisko)
        if ('' !== ($pierwszeImieChoiceErrorMessage = self::validatePierwszeImieForChoiceConstraintsFromSetPierwszeImie($pierwszeImie))) {
            throw new \InvalidArgumentException($pierwszeImieChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pierwszeImie) && mb_strlen($pierwszeImie) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pierwszeImie)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pierwszeImie) && mb_strlen($pierwszeImie) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pierwszeImie)), __LINE__);
        }
        if (is_null($pierwszeImie) || (is_array($pierwszeImie) && empty($pierwszeImie))) {
            unset($this->PierwszeImie);
        } else {
            $this->PierwszeImie = $pierwszeImie;
        }
        return $this;
    }
    /**
     * Get Nazwisko value
     * @return string|null
     */
    public function getNazwisko()
    {
        return isset($this->Nazwisko) ? $this->Nazwisko : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNazwisko method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNazwisko method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNazwiskoForChoiceConstraintsFromSetNazwisko($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NIP',
            'PESEL',
            'DataUrodzenia',
            'PierwszeImie',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Nazwisko can\'t be set as the property %s is already set. Only one property must be set among these properties: Nazwisko, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Nazwisko value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $nazwisko
     * @return \StructType\SzczegolyWnioskuTyp
     */
    public function setNazwisko($nazwisko = null)
    {
        // validation for constraint: string
        if (!is_null($nazwisko) && !is_string($nazwisko)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwisko, true), gettype($nazwisko)), __LINE__);
        }
        // validation for constraint: choice(NIP, PESEL, DataUrodzenia, PierwszeImie, Nazwisko)
        if ('' !== ($nazwiskoChoiceErrorMessage = self::validateNazwiskoForChoiceConstraintsFromSetNazwisko($nazwisko))) {
            throw new \InvalidArgumentException($nazwiskoChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($nazwisko) && mb_strlen($nazwisko) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($nazwisko)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwisko) && mb_strlen($nazwisko) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwisko)), __LINE__);
        }
        if (is_null($nazwisko) || (is_array($nazwisko) && empty($nazwisko))) {
            unset($this->Nazwisko);
        } else {
            $this->Nazwisko = $nazwisko;
        }
        return $this;
    }
    /**
     * Get DataOd value
     * @return string|null
     */
    public function getDataOd()
    {
        return $this->DataOd;
    }
    /**
     * Set DataOd value
     * @param string $dataOd
     * @return \StructType\SzczegolyWnioskuTyp
     */
    public function setDataOd($dataOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataOd) && !is_string($dataOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataOd, true), gettype($dataOd)), __LINE__);
        }
        $this->DataOd = $dataOd;
        return $this;
    }
    /**
     * Get DataDo value
     * @return string|null
     */
    public function getDataDo()
    {
        return $this->DataDo;
    }
    /**
     * Set DataDo value
     * @param string $dataDo
     * @return \StructType\SzczegolyWnioskuTyp
     */
    public function setDataDo($dataDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataDo) && !is_string($dataDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDo, true), gettype($dataDo)), __LINE__);
        }
        $this->DataDo = $dataDo;
        return $this;
    }
}
