<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReprezentantTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Osoba reprezentująca spółkę.
 * @subpackage Structs
 */
class ReprezentantTyp extends AbstractStructBase
{
    /**
     * The PierwszeImie
     * Meta information extracted from the WSDL
     * - documentation: Pierwsze imię reprezentanta. | Imię
     * - base: xs:token
     * - maxLength: 120
     * - minLength: 1
     * @var string
     */
    public $PierwszeImie;
    /**
     * The KolejneImiona
     * Meta information extracted from the WSDL
     * - documentation: Lista oddzielonych przecinkami [,] kolejnych imion reprezentanta.
     * - minOccurs: 0
     * @var string
     */
    public $KolejneImiona;
    /**
     * The Nazwisko
     * Meta information extracted from the WSDL
     * - documentation: Pełne nazwisko reprezentanta. | Nazwisko
     * - base: xs:token
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Nazwisko;
    /**
     * The PESEL
     * Meta information extracted from the WSDL
     * - documentation: Numer PESEL reprezentanta. | Numer w rejestrze PESEL
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: \d{11}
     * @var string
     */
    public $PESEL;
    /**
     * The DataUrodzenia
     * Meta information extracted from the WSDL
     * - documentation: Data urodzenia reprezentanta nieposiadającego numeru PESEL.
     * - minOccurs: 0
     * @var string
     */
    public $DataUrodzenia;
    /**
     * The Obywatelstwo
     * Meta information extracted from the WSDL
     * - documentation: 2-znakowe oznaczenie kraju, którego obywatelem jest reprezentant. | Kod kraju
     * - base: xs:string
     * - length: 2
     * - pattern: [A-Z][A-Z]
     * @var string
     */
    public $Obywatelstwo;
    /**
     * The KrajZamieszkania
     * Meta information extracted from the WSDL
     * - documentation: 2-znakowe oznaczenie kraju, w którym zamieszkuje na stałe lub ma obywatelstwo reprezentant. | Kod kraju
     * - base: xs:string
     * - length: 2
     * - pattern: [A-Z][A-Z]
     * @var string
     */
    public $KrajZamieszkania;
    /**
     * The RodzajReprezentacji
     * Meta information extracted from the WSDL
     * - documentation: Rodzaj reprezentacji spółki przez reprezentanta.
     * @var string
     */
    public $RodzajReprezentacji;
    /**
     * Constructor method for ReprezentantTyp
     * @uses ReprezentantTyp::setPierwszeImie()
     * @uses ReprezentantTyp::setKolejneImiona()
     * @uses ReprezentantTyp::setNazwisko()
     * @uses ReprezentantTyp::setPESEL()
     * @uses ReprezentantTyp::setDataUrodzenia()
     * @uses ReprezentantTyp::setObywatelstwo()
     * @uses ReprezentantTyp::setKrajZamieszkania()
     * @uses ReprezentantTyp::setRodzajReprezentacji()
     * @param string $pierwszeImie
     * @param string $kolejneImiona
     * @param string $nazwisko
     * @param string $pESEL
     * @param string $dataUrodzenia
     * @param string $obywatelstwo
     * @param string $krajZamieszkania
     * @param string $rodzajReprezentacji
     */
    public function __construct($pierwszeImie = null, $kolejneImiona = null, $nazwisko = null, $pESEL = null, $dataUrodzenia = null, $obywatelstwo = null, $krajZamieszkania = null, $rodzajReprezentacji = null)
    {
        $this
            ->setPierwszeImie($pierwszeImie)
            ->setKolejneImiona($kolejneImiona)
            ->setNazwisko($nazwisko)
            ->setPESEL($pESEL)
            ->setDataUrodzenia($dataUrodzenia)
            ->setObywatelstwo($obywatelstwo)
            ->setKrajZamieszkania($krajZamieszkania)
            ->setRodzajReprezentacji($rodzajReprezentacji);
    }
    /**
     * Get PierwszeImie value
     * @return string|null
     */
    public function getPierwszeImie()
    {
        return $this->PierwszeImie;
    }
    /**
     * Set PierwszeImie value
     * @param string $pierwszeImie
     * @return \StructType\ReprezentantTyp
     */
    public function setPierwszeImie($pierwszeImie = null)
    {
        // validation for constraint: string
        if (!is_null($pierwszeImie) && !is_string($pierwszeImie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pierwszeImie, true), gettype($pierwszeImie)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pierwszeImie) && mb_strlen($pierwszeImie) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pierwszeImie)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pierwszeImie) && mb_strlen($pierwszeImie) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pierwszeImie)), __LINE__);
        }
        $this->PierwszeImie = $pierwszeImie;
        return $this;
    }
    /**
     * Get KolejneImiona value
     * @return string|null
     */
    public function getKolejneImiona()
    {
        return $this->KolejneImiona;
    }
    /**
     * Set KolejneImiona value
     * @param string $kolejneImiona
     * @return \StructType\ReprezentantTyp
     */
    public function setKolejneImiona($kolejneImiona = null)
    {
        // validation for constraint: string
        if (!is_null($kolejneImiona) && !is_string($kolejneImiona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kolejneImiona, true), gettype($kolejneImiona)), __LINE__);
        }
        $this->KolejneImiona = $kolejneImiona;
        return $this;
    }
    /**
     * Get Nazwisko value
     * @return string|null
     */
    public function getNazwisko()
    {
        return $this->Nazwisko;
    }
    /**
     * Set Nazwisko value
     * @param string $nazwisko
     * @return \StructType\ReprezentantTyp
     */
    public function setNazwisko($nazwisko = null)
    {
        // validation for constraint: string
        if (!is_null($nazwisko) && !is_string($nazwisko)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwisko, true), gettype($nazwisko)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($nazwisko) && mb_strlen($nazwisko) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($nazwisko)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwisko) && mb_strlen($nazwisko) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwisko)), __LINE__);
        }
        $this->Nazwisko = $nazwisko;
        return $this;
    }
    /**
     * Get PESEL value
     * @return string|null
     */
    public function getPESEL()
    {
        return $this->PESEL;
    }
    /**
     * Set PESEL value
     * @param string $pESEL
     * @return \StructType\ReprezentantTyp
     */
    public function setPESEL($pESEL = null)
    {
        // validation for constraint: string
        if (!is_null($pESEL) && !is_string($pESEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pESEL, true), gettype($pESEL)), __LINE__);
        }
        // validation for constraint: pattern(\d{11})
        if (!is_null($pESEL) && !preg_match('/\\d{11}/', $pESEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{11}', var_export($pESEL, true)), __LINE__);
        }
        $this->PESEL = $pESEL;
        return $this;
    }
    /**
     * Get DataUrodzenia value
     * @return string|null
     */
    public function getDataUrodzenia()
    {
        return $this->DataUrodzenia;
    }
    /**
     * Set DataUrodzenia value
     * @param string $dataUrodzenia
     * @return \StructType\ReprezentantTyp
     */
    public function setDataUrodzenia($dataUrodzenia = null)
    {
        // validation for constraint: string
        if (!is_null($dataUrodzenia) && !is_string($dataUrodzenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataUrodzenia, true), gettype($dataUrodzenia)), __LINE__);
        }
        $this->DataUrodzenia = $dataUrodzenia;
        return $this;
    }
    /**
     * Get Obywatelstwo value
     * @return string|null
     */
    public function getObywatelstwo()
    {
        return $this->Obywatelstwo;
    }
    /**
     * Set Obywatelstwo value
     * @param string $obywatelstwo
     * @return \StructType\ReprezentantTyp
     */
    public function setObywatelstwo($obywatelstwo = null)
    {
        // validation for constraint: string
        if (!is_null($obywatelstwo) && !is_string($obywatelstwo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obywatelstwo, true), gettype($obywatelstwo)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($obywatelstwo) && mb_strlen($obywatelstwo) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($obywatelstwo)), __LINE__);
        }
        // validation for constraint: pattern([A-Z][A-Z])
        if (!is_null($obywatelstwo) && !preg_match('/[A-Z][A-Z]/', $obywatelstwo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z][A-Z]', var_export($obywatelstwo, true)), __LINE__);
        }
        $this->Obywatelstwo = $obywatelstwo;
        return $this;
    }
    /**
     * Get KrajZamieszkania value
     * @return string|null
     */
    public function getKrajZamieszkania()
    {
        return $this->KrajZamieszkania;
    }
    /**
     * Set KrajZamieszkania value
     * @param string $krajZamieszkania
     * @return \StructType\ReprezentantTyp
     */
    public function setKrajZamieszkania($krajZamieszkania = null)
    {
        // validation for constraint: string
        if (!is_null($krajZamieszkania) && !is_string($krajZamieszkania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krajZamieszkania, true), gettype($krajZamieszkania)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($krajZamieszkania) && mb_strlen($krajZamieszkania) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($krajZamieszkania)), __LINE__);
        }
        // validation for constraint: pattern([A-Z][A-Z])
        if (!is_null($krajZamieszkania) && !preg_match('/[A-Z][A-Z]/', $krajZamieszkania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z][A-Z]', var_export($krajZamieszkania, true)), __LINE__);
        }
        $this->KrajZamieszkania = $krajZamieszkania;
        return $this;
    }
    /**
     * Get RodzajReprezentacji value
     * @return string|null
     */
    public function getRodzajReprezentacji()
    {
        return $this->RodzajReprezentacji;
    }
    /**
     * Set RodzajReprezentacji value
     * @param string $rodzajReprezentacji
     * @return \StructType\ReprezentantTyp
     */
    public function setRodzajReprezentacji($rodzajReprezentacji = null)
    {
        // validation for constraint: string
        if (!is_null($rodzajReprezentacji) && !is_string($rodzajReprezentacji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rodzajReprezentacji, true), gettype($rodzajReprezentacji)), __LINE__);
        }
        $this->RodzajReprezentacji = $rodzajReprezentacji;
        return $this;
    }
}
