<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PobierzZgloszeniaDaneTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Komunikat żądania o listę zgłoszeń dla spółki.
 * @subpackage Structs
 */
class PobierzZgloszeniaDaneTyp extends AbstractStructBase
{
    /**
     * The NIP
     * Meta information extracted from the WSDL
     * - documentation: Szukany numer NIP spółki. | Identyfikator NIP
     * - base: xs:string
     * - pattern: [1-9]((\d[1-9])|([1-9]\d))\d{7}
     * @var string
     */
    public $NIP;
    /**
     * Constructor method for PobierzZgloszeniaDaneTyp
     * @uses PobierzZgloszeniaDaneTyp::setNIP()
     * @param string $nIP
     */
    public function __construct($nIP = null)
    {
        $this
            ->setNIP($nIP);
    }
    /**
     * Get NIP value
     * @return string|null
     */
    public function getNIP()
    {
        return $this->NIP;
    }
    /**
     * Set NIP value
     * @param string $nIP
     * @return \StructType\PobierzZgloszeniaDaneTyp
     */
    public function setNIP($nIP = null)
    {
        // validation for constraint: string
        if (!is_null($nIP) && !is_string($nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nIP, true), gettype($nIP)), __LINE__);
        }
        // validation for constraint: pattern([1-9]((\d[1-9])|([1-9]\d))\d{7})
        if (!is_null($nIP) && !preg_match('/[1-9]((\\d[1-9])|([1-9]\\d))\\d{7}/', $nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]((\d[1-9])|([1-9]\d))\d{7}', var_export($nIP, true)), __LINE__);
        }
        $this->NIP = $nIP;
        return $this;
    }
}
