<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Komunikat odpowiedzi na komunikat żądania informacji o spółkach i beneficjentach.
 * @subpackage Structs
 */
class PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp extends AbstractStructBase
{
    /**
     * The IdentyfikatorWniosku
     * Meta information extracted from the WSDL
     * - documentation: Unikalny, nadawany przez aplikację CRBR identyfikator złożonego wniosku.
     * @var string
     */
    public $IdentyfikatorWniosku;
    /**
     * The DataICzasZlozeniaWniosku
     * Meta information extracted from the WSDL
     * - documentation: Data i czas przekazania wniosku do UBD.
     * @var string
     */
    public $DataICzasZlozeniaWniosku;
    /**
     * The DataICzasUdostepnieniaWniosku
     * Meta information extracted from the WSDL
     * - documentation: Data i czas udostępnienia wniosku.
     * @var string
     */
    public $DataICzasUdostepnieniaWniosku;
    /**
     * The ListaInformacjiOSpolkachIBeneficjentach
     * Meta information extracted from the WSDL
     * - documentation: Lista informacji o spółkach i beneficjentach.
     * - minOccurs: 0
     * @var \StructType\ListaInformacjiOSpolkachIBeneficjentachApiZapytaniaTyp
     */
    public $ListaInformacjiOSpolkachIBeneficjentach;
    /**
     * The SzczegolyWniosku
     * Meta information extracted from the WSDL
     * - documentation: Szczegółowe dane przekazane we wniosku o informacje.
     * @var \StructType\SzczegolyWnioskuTyp
     */
    public $SzczegolyWniosku;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status zawierający informacje o wyniku zapytania.
     * @var string
     */
    public $Status;
    /**
     * The CelZapytania
     * Meta information extracted from the WSDL
     * - documentation: Opisuje cel zapytania. Możliwe jest zapytanie o spółkę i jej beneficjentów, albo o beneficjenta i spółki, w których jest beneficjentem.
     * @var string
     */
    public $CelZapytania;
    /**
     * Constructor method for PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     * @uses PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp::setIdentyfikatorWniosku()
     * @uses PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp::setDataICzasZlozeniaWniosku()
     * @uses PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp::setDataICzasUdostepnieniaWniosku()
     * @uses PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp::setListaInformacjiOSpolkachIBeneficjentach()
     * @uses PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp::setSzczegolyWniosku()
     * @uses PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp::setStatus()
     * @uses PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp::setCelZapytania()
     * @param string $identyfikatorWniosku
     * @param string $dataICzasZlozeniaWniosku
     * @param string $dataICzasUdostepnieniaWniosku
     * @param \StructType\ListaInformacjiOSpolkachIBeneficjentachApiZapytaniaTyp $listaInformacjiOSpolkachIBeneficjentach
     * @param \StructType\SzczegolyWnioskuTyp $szczegolyWniosku
     * @param string $status
     * @param string $celZapytania
     */
    public function __construct($identyfikatorWniosku = null, $dataICzasZlozeniaWniosku = null, $dataICzasUdostepnieniaWniosku = null, \StructType\ListaInformacjiOSpolkachIBeneficjentachApiZapytaniaTyp $listaInformacjiOSpolkachIBeneficjentach = null, \StructType\SzczegolyWnioskuTyp $szczegolyWniosku = null, $status = null, $celZapytania = null)
    {
        $this
            ->setIdentyfikatorWniosku($identyfikatorWniosku)
            ->setDataICzasZlozeniaWniosku($dataICzasZlozeniaWniosku)
            ->setDataICzasUdostepnieniaWniosku($dataICzasUdostepnieniaWniosku)
            ->setListaInformacjiOSpolkachIBeneficjentach($listaInformacjiOSpolkachIBeneficjentach)
            ->setSzczegolyWniosku($szczegolyWniosku)
            ->setStatus($status)
            ->setCelZapytania($celZapytania);
    }
    /**
     * Get IdentyfikatorWniosku value
     * @return string|null
     */
    public function getIdentyfikatorWniosku()
    {
        return $this->IdentyfikatorWniosku;
    }
    /**
     * Set IdentyfikatorWniosku value
     * @param string $identyfikatorWniosku
     * @return \StructType\PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     */
    public function setIdentyfikatorWniosku($identyfikatorWniosku = null)
    {
        // validation for constraint: string
        if (!is_null($identyfikatorWniosku) && !is_string($identyfikatorWniosku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identyfikatorWniosku, true), gettype($identyfikatorWniosku)), __LINE__);
        }
        $this->IdentyfikatorWniosku = $identyfikatorWniosku;
        return $this;
    }
    /**
     * Get DataICzasZlozeniaWniosku value
     * @return string|null
     */
    public function getDataICzasZlozeniaWniosku()
    {
        return $this->DataICzasZlozeniaWniosku;
    }
    /**
     * Set DataICzasZlozeniaWniosku value
     * @param string $dataICzasZlozeniaWniosku
     * @return \StructType\PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     */
    public function setDataICzasZlozeniaWniosku($dataICzasZlozeniaWniosku = null)
    {
        // validation for constraint: string
        if (!is_null($dataICzasZlozeniaWniosku) && !is_string($dataICzasZlozeniaWniosku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataICzasZlozeniaWniosku, true), gettype($dataICzasZlozeniaWniosku)), __LINE__);
        }
        $this->DataICzasZlozeniaWniosku = $dataICzasZlozeniaWniosku;
        return $this;
    }
    /**
     * Get DataICzasUdostepnieniaWniosku value
     * @return string|null
     */
    public function getDataICzasUdostepnieniaWniosku()
    {
        return $this->DataICzasUdostepnieniaWniosku;
    }
    /**
     * Set DataICzasUdostepnieniaWniosku value
     * @param string $dataICzasUdostepnieniaWniosku
     * @return \StructType\PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     */
    public function setDataICzasUdostepnieniaWniosku($dataICzasUdostepnieniaWniosku = null)
    {
        // validation for constraint: string
        if (!is_null($dataICzasUdostepnieniaWniosku) && !is_string($dataICzasUdostepnieniaWniosku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataICzasUdostepnieniaWniosku, true), gettype($dataICzasUdostepnieniaWniosku)), __LINE__);
        }
        $this->DataICzasUdostepnieniaWniosku = $dataICzasUdostepnieniaWniosku;
        return $this;
    }
    /**
     * Get ListaInformacjiOSpolkachIBeneficjentach value
     * @return \StructType\ListaInformacjiOSpolkachIBeneficjentachApiZapytaniaTyp|null
     */
    public function getListaInformacjiOSpolkachIBeneficjentach()
    {
        return $this->ListaInformacjiOSpolkachIBeneficjentach;
    }
    /**
     * Set ListaInformacjiOSpolkachIBeneficjentach value
     * @param \StructType\ListaInformacjiOSpolkachIBeneficjentachApiZapytaniaTyp $listaInformacjiOSpolkachIBeneficjentach
     * @return \StructType\PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     */
    public function setListaInformacjiOSpolkachIBeneficjentach(\StructType\ListaInformacjiOSpolkachIBeneficjentachApiZapytaniaTyp $listaInformacjiOSpolkachIBeneficjentach = null)
    {
        $this->ListaInformacjiOSpolkachIBeneficjentach = $listaInformacjiOSpolkachIBeneficjentach;
        return $this;
    }
    /**
     * Get SzczegolyWniosku value
     * @return \StructType\SzczegolyWnioskuTyp|null
     */
    public function getSzczegolyWniosku()
    {
        return $this->SzczegolyWniosku;
    }
    /**
     * Set SzczegolyWniosku value
     * @param \StructType\SzczegolyWnioskuTyp $szczegolyWniosku
     * @return \StructType\PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     */
    public function setSzczegolyWniosku(\StructType\SzczegolyWnioskuTyp $szczegolyWniosku = null)
    {
        $this->SzczegolyWniosku = $szczegolyWniosku;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\StatusTyp::valueIsValid()
     * @uses \EnumType\StatusTyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusTyp::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusTyp', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\StatusTyp::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CelZapytania value
     * @return string|null
     */
    public function getCelZapytania()
    {
        return $this->CelZapytania;
    }
    /**
     * Set CelZapytania value
     * @uses \EnumType\CelZapytaniaTyp::valueIsValid()
     * @uses \EnumType\CelZapytaniaTyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $celZapytania
     * @return \StructType\PobierzInformacjeOSpolkachIBeneficjentachOdpowiedzDaneTyp
     */
    public function setCelZapytania($celZapytania = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CelZapytaniaTyp::valueIsValid($celZapytania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CelZapytaniaTyp', is_array($celZapytania) ? implode(', ', $celZapytania) : var_export($celZapytania, true), implode(', ', \EnumType\CelZapytaniaTyp::getValidValues())), __LINE__);
        }
        $this->CelZapytania = $celZapytania;
        return $this;
    }
}
