<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The success
     * @var float
     */
    public $success;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * Constructor method for result
     * @uses Result::setSuccess()
     * @uses Result::setMessage()
     * @param float $success
     * @param string $message
     */
    public function __construct($success = null, $message = null)
    {
        $this
            ->setSuccess($success)
            ->setMessage($message);
    }
    /**
     * Get success value
     * @return float|null
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param float $success
     * @return Result
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: float
        if (!is_null($success) && !(is_float($success) || is_numeric($success))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->success = $success;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return Result
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
