<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The contact
     * @var Contact
     */
    public $contact;
    /**
     * The wishDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $wishDate;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $comment;
    /**
     * The services
     * @var Services
     */
    public $services;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * The paymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentStatus;
    /**
     * The resolvedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resolvedAt;
    /**
     * The accountId
     * @var string
     */
    public $accountId;
    /**
     * The createdAt
     * @var string
     */
    public $createdAt;
    /**
     * The totalPrice
     * @var float
     */
    public $totalPrice;
    /**
     * The resolveAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resolveAt;
    /**
     * Constructor method for order
     * @uses Order::setId()
     * @uses Order::setContact()
     * @uses Order::setWishDate()
     * @uses Order::setComment()
     * @uses Order::setServices()
     * @uses Order::setStatus()
     * @uses Order::setPaymentStatus()
     * @uses Order::setResolvedAt()
     * @uses Order::setAccountId()
     * @uses Order::setCreatedAt()
     * @uses Order::setTotalPrice()
     * @uses Order::setResolveAt()
     * @param string $id
     * @param Contact $contact
     * @param string $wishDate
     * @param string $comment
     * @param Services $services
     * @param string $status
     * @param string $paymentStatus
     * @param string $resolvedAt
     * @param string $accountId
     * @param string $createdAt
     * @param float $totalPrice
     * @param string $resolveAt
     */
    public function __construct($id = null, Contact $contact = null, $wishDate = null, $comment = null, Services $services = null, $status = null, $paymentStatus = null, $resolvedAt = null, $accountId = null, $createdAt = null, $totalPrice = null, $resolveAt = null)
    {
        $this
            ->setId($id)
            ->setContact($contact)
            ->setWishDate($wishDate)
            ->setComment($comment)
            ->setServices($services)
            ->setStatus($status)
            ->setPaymentStatus($paymentStatus)
            ->setResolvedAt($resolvedAt)
            ->setAccountId($accountId)
            ->setCreatedAt($createdAt)
            ->setTotalPrice($totalPrice)
            ->setResolveAt($resolveAt);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return Order
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get contact value
     * @return Contact|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param Contact $contact
     * @return Order
     */
    public function setContact(Contact $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get wishDate value
     * @return string|null
     */
    public function getWishDate()
    {
        return $this->wishDate;
    }
    /**
     * Set wishDate value
     * @param string $wishDate
     * @return Order
     */
    public function setWishDate($wishDate = null)
    {
        // validation for constraint: string
        if (!is_null($wishDate) && !is_string($wishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wishDate, true), gettype($wishDate)), __LINE__);
        }
        $this->wishDate = $wishDate;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return Order
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get services value
     * @return Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param Services $services
     * @return Order
     */
    public function setServices(Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return Order
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get paymentStatus value
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->paymentStatus;
    }
    /**
     * Set paymentStatus value
     * @param string $paymentStatus
     * @return Order
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatus) && !is_string($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatus, true), gettype($paymentStatus)), __LINE__);
        }
        $this->paymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get resolvedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResolvedAt()
    {
        return isset($this->resolvedAt) ? $this->resolvedAt : null;
    }
    /**
     * Set resolvedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resolvedAt
     * @return Order
     */
    public function setResolvedAt($resolvedAt = null)
    {
        // validation for constraint: string
        if (!is_null($resolvedAt) && !is_string($resolvedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolvedAt, true), gettype($resolvedAt)), __LINE__);
        }
        if (is_null($resolvedAt) || (is_array($resolvedAt) && empty($resolvedAt))) {
            unset($this->resolvedAt);
        } else {
            $this->resolvedAt = $resolvedAt;
        }
        return $this;
    }
    /**
     * Get accountId value
     * @return string|null
     */
    public function getAccountId()
    {
        return $this->accountId;
    }
    /**
     * Set accountId value
     * @param string $accountId
     * @return Order
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->accountId = $accountId;
        return $this;
    }
    /**
     * Get createdAt value
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }
    /**
     * Set createdAt value
     * @param string $createdAt
     * @return Order
     */
    public function setCreatedAt($createdAt = null)
    {
        // validation for constraint: string
        if (!is_null($createdAt) && !is_string($createdAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAt, true), gettype($createdAt)), __LINE__);
        }
        $this->createdAt = $createdAt;
        return $this;
    }
    /**
     * Get totalPrice value
     * @return float|null
     */
    public function getTotalPrice()
    {
        return $this->totalPrice;
    }
    /**
     * Set totalPrice value
     * @param float $totalPrice
     * @return Order
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->totalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get resolveAt value
     * @return string|null
     */
    public function getResolveAt()
    {
        return $this->resolveAt;
    }
    /**
     * Set resolveAt value
     * @param string $resolveAt
     * @return Order
     */
    public function setResolveAt($resolveAt = null)
    {
        // validation for constraint: string
        if (!is_null($resolveAt) && !is_string($resolveAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolveAt, true), gettype($resolveAt)), __LINE__);
        }
        $this->resolveAt = $resolveAt;
        return $this;
    }
}
