<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for service StructType
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The tarif
     * @var float
     */
    public $tarif;
    /**
     * The number
     * @var float
     */
    public $number;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $data;
    /**
     * Constructor method for service
     * @uses Service::setId()
     * @uses Service::setName()
     * @uses Service::setTarif()
     * @uses Service::setNumber()
     * @uses Service::setData()
     * @param string $id
     * @param string $name
     * @param float $tarif
     * @param float $number
     * @param string $data
     */
    public function __construct($id = null, $name = null, $tarif = null, $number = null, $data = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setTarif($tarif)
            ->setNumber($number)
            ->setData($data);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Service
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Service
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get tarif value
     * @return float|null
     */
    public function getTarif()
    {
        return $this->tarif;
    }
    /**
     * Set tarif value
     * @param float $tarif
     * @return \StructType\Service
     */
    public function setTarif($tarif = null)
    {
        // validation for constraint: float
        if (!is_null($tarif) && !(is_float($tarif) || is_numeric($tarif))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tarif, true), gettype($tarif)), __LINE__);
        }
        $this->tarif = $tarif;
        return $this;
    }
    /**
     * Get number value
     * @return float|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param float $number
     * @return \StructType\Service
     */
    public function setNumber($number = null)
    {
        // validation for constraint: float
        if (!is_null($number) && !(is_float($number) || is_numeric($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->data) ? $this->data : null;
    }
    /**
     * Set data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \StructType\Service
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->data);
        } else {
            $this->data = $data;
        }
        return $this;
    }
}
