<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderResponse StructType
 * @subpackage Structs
 */
class GetOrderResponse extends AbstractStructBase
{
    /**
     * The return
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $return;
    /**
     * The order
     * @var \StructType\Order
     */
    public $order;
    /**
     * Constructor method for GetOrderResponse
     * @uses GetOrderResponse::setReturn()
     * @uses GetOrderResponse::setOrder()
     * @param string $return
     * @param \StructType\Order $order
     */
    public function __construct($return = null, \StructType\Order $order = null)
    {
        $this
            ->setReturn($return)
            ->setOrder($order);
    }
    /**
     * Get return value
     * @return string|null
     */
    public function getReturn()
    {
        return $this->return;
    }
    /**
     * Set return value
     * @param string $return
     * @return \StructType\GetOrderResponse
     */
    public function setReturn($return = null)
    {
        // validation for constraint: string
        if (!is_null($return) && !is_string($return)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return, true), gettype($return)), __LINE__);
        }
        $this->return = $return;
        return $this;
    }
    /**
     * Get order value
     * @return \StructType\Order|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param \StructType\Order $order
     * @return \StructType\GetOrderResponse
     */
    public function setOrder(\StructType\Order $order = null)
    {
        $this->order = $order;
        return $this;
    }
}
