<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://shipperadmintest.dpd.be/PublicApi/soap/WSDL/ShipmentServiceV33.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://shipperadmintest.dpd.be/PublicApi/soap/WSDL/ShipmentServiceV33.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Dpd\ClassMap::get(),
);
/**
 * Samples for Store ServiceType
 */
$store = new \Dpd\ServiceType\Store($options);
$store->setSoapHeaderAuthentication(new \Dpd\StructType\Authentication());
/**
 * Sample call for storeOrders operation/method
 */
if ($store->storeOrders(new \Dpd\StructType\StoreOrders()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
