<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeOrders StructType
 * Meta information extracted from the WSDL
 * - type: tns:storeOrders
 * @subpackage Structs
 */
class StoreOrders extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 30
     * - minOccurs: 1
     * @var \Dpd\StructType\Order[]
     */
    public $order;
    /**
     * The printOptions
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\PrintOptions
     */
    public $printOptions;
    /**
     * Constructor method for storeOrders
     * @uses StoreOrders::setOrder()
     * @uses StoreOrders::setPrintOptions()
     * @param \Dpd\StructType\Order[] $order
     * @param \Dpd\StructType\PrintOptions $printOptions
     */
    public function __construct(array $order = array(), \Dpd\StructType\PrintOptions $printOptions = null)
    {
        $this
            ->setOrder($order)
            ->setPrintOptions($printOptions);
    }
    /**
     * Get order value
     * @return \Dpd\StructType\Order[]
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $storeOrdersOrderItem) {
            // validation for constraint: itemType
            if (!$storeOrdersOrderItem instanceof \Dpd\StructType\Order) {
                $invalidValues[] = is_object($storeOrdersOrderItem) ? get_class($storeOrdersOrderItem) : sprintf('%s(%s)', gettype($storeOrdersOrderItem), var_export($storeOrdersOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The order property can only contain items of type \Dpd\StructType\Order, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Order[] $order
     * @return \Dpd\StructType\StoreOrders
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($order) && count($order) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Order $item
     * @return \Dpd\StructType\StoreOrders
     */
    public function addToOrder(\Dpd\StructType\Order $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\Order) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of type \Dpd\StructType\Order, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->order) && count($this->order) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->order)), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Get printOptions value
     * @return \Dpd\StructType\PrintOptions|null
     */
    public function getPrintOptions()
    {
        return $this->printOptions;
    }
    /**
     * Set printOptions value
     * @param \Dpd\StructType\PrintOptions $printOptions
     * @return \Dpd\StructType\StoreOrders
     */
    public function setPrintOptions(\Dpd\StructType\PrintOptions $printOptions = null)
    {
        $this->printOptions = $printOptions;
        return $this;
    }
}
