<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for proactiveNotification StructType
 * @subpackage Structs
 */
class ProactiveNotification extends AbstractStructBase
{
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $channel;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $value;
    /**
     * The rule
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $rule;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $language;
    /**
     * Constructor method for proactiveNotification
     * @uses ProactiveNotification::setChannel()
     * @uses ProactiveNotification::setValue()
     * @uses ProactiveNotification::setRule()
     * @uses ProactiveNotification::setLanguage()
     * @param int $channel
     * @param string $value
     * @param int $rule
     * @param string $language
     */
    public function __construct($channel = null, $value = null, $rule = null, $language = null)
    {
        $this
            ->setChannel($channel)
            ->setValue($value)
            ->setRule($rule)
            ->setLanguage($language);
    }
    /**
     * Get channel value
     * @return int
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param int $channel
     * @return \Dpd\StructType\ProactiveNotification
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: int
        if (!is_null($channel) && !(is_int($channel) || ctype_digit($channel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get value value
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \Dpd\StructType\ProactiveNotification
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get rule value
     * @return int
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * Set rule value
     * @param int $rule
     * @return \Dpd\StructType\ProactiveNotification
     */
    public function setRule($rule = null)
    {
        // validation for constraint: int
        if (!is_null($rule) && !(is_int($rule) || ctype_digit($rule))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rule, true), gettype($rule)), __LINE__);
        }
        $this->rule = $rule;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \Dpd\StructType\ProactiveNotification
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
}
