<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printer StructType
 * @subpackage Structs
 */
class Printer extends AbstractStructBase
{
    /**
     * The offsetX
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $offsetX;
    /**
     * The offsetY
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $offsetY;
    /**
     * The connectionType
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $connectionType;
    /**
     * The barcodeCapable2D
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $barcodeCapable2D;
    /**
     * The manufacturer
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manufacturer;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The revision
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $revision;
    /**
     * Constructor method for printer
     * @uses Printer::setOffsetX()
     * @uses Printer::setOffsetY()
     * @uses Printer::setConnectionType()
     * @uses Printer::setBarcodeCapable2D()
     * @uses Printer::setManufacturer()
     * @uses Printer::setModel()
     * @uses Printer::setRevision()
     * @param float $offsetX
     * @param float $offsetY
     * @param string $connectionType
     * @param bool $barcodeCapable2D
     * @param string $manufacturer
     * @param string $model
     * @param string $revision
     */
    public function __construct($offsetX = null, $offsetY = null, $connectionType = null, $barcodeCapable2D = null, $manufacturer = null, $model = null, $revision = null)
    {
        $this
            ->setOffsetX($offsetX)
            ->setOffsetY($offsetY)
            ->setConnectionType($connectionType)
            ->setBarcodeCapable2D($barcodeCapable2D)
            ->setManufacturer($manufacturer)
            ->setModel($model)
            ->setRevision($revision);
    }
    /**
     * Get offsetX value
     * @return float
     */
    public function getOffsetX()
    {
        return $this->offsetX;
    }
    /**
     * Set offsetX value
     * @param float $offsetX
     * @return \Dpd\StructType\Printer
     */
    public function setOffsetX($offsetX = null)
    {
        // validation for constraint: float
        if (!is_null($offsetX) && !(is_float($offsetX) || is_numeric($offsetX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($offsetX, true), gettype($offsetX)), __LINE__);
        }
        $this->offsetX = $offsetX;
        return $this;
    }
    /**
     * Get offsetY value
     * @return float
     */
    public function getOffsetY()
    {
        return $this->offsetY;
    }
    /**
     * Set offsetY value
     * @param float $offsetY
     * @return \Dpd\StructType\Printer
     */
    public function setOffsetY($offsetY = null)
    {
        // validation for constraint: float
        if (!is_null($offsetY) && !(is_float($offsetY) || is_numeric($offsetY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($offsetY, true), gettype($offsetY)), __LINE__);
        }
        $this->offsetY = $offsetY;
        return $this;
    }
    /**
     * Get connectionType value
     * @return string
     */
    public function getConnectionType()
    {
        return $this->connectionType;
    }
    /**
     * Set connectionType value
     * @param string $connectionType
     * @return \Dpd\StructType\Printer
     */
    public function setConnectionType($connectionType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionType) && !is_string($connectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionType, true), gettype($connectionType)), __LINE__);
        }
        $this->connectionType = $connectionType;
        return $this;
    }
    /**
     * Get barcodeCapable2D value
     * @return bool
     */
    public function getBarcodeCapable2D()
    {
        return $this->barcodeCapable2D;
    }
    /**
     * Set barcodeCapable2D value
     * @param bool $barcodeCapable2D
     * @return \Dpd\StructType\Printer
     */
    public function setBarcodeCapable2D($barcodeCapable2D = null)
    {
        // validation for constraint: boolean
        if (!is_null($barcodeCapable2D) && !is_bool($barcodeCapable2D)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($barcodeCapable2D, true), gettype($barcodeCapable2D)), __LINE__);
        }
        $this->barcodeCapable2D = $barcodeCapable2D;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \Dpd\StructType\Printer
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \Dpd\StructType\Printer
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($model, true), gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get revision value
     * @return string|null
     */
    public function getRevision()
    {
        return $this->revision;
    }
    /**
     * Set revision value
     * @param string $revision
     * @return \Dpd\StructType\Printer
     */
    public function setRevision($revision = null)
    {
        // validation for constraint: string
        if (!is_null($revision) && !is_string($revision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revision, true), gettype($revision)), __LINE__);
        }
        $this->revision = $revision;
        return $this;
    }
}
