<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcels StructType
 * @subpackage Structs
 */
class Parcels extends AbstractStructBase
{
    /**
     * The parcelLabelNumber
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcelLabelNumber;
    /**
     * The customerReferenceNumber1
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber1;
    /**
     * The customerReferenceNumber2
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber2;
    /**
     * The customerReferenceNumber3
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber3;
    /**
     * The customerReferenceNumber4
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerReferenceNumber4;
    /**
     * The swap
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $swap;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $volume;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $weight;
    /**
     * The hazardousLimitedQuantities
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $hazardousLimitedQuantities;
    /**
     * The higherInsurance
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\HigherInsurance
     */
    public $higherInsurance;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * The addService
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $addService;
    /**
     * The messageNumber
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $messageNumber;
    /**
     * The function
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $function;
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameter;
    /**
     * The cod
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Cod
     */
    public $cod;
    /**
     * The international
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\International
     */
    public $international;
    /**
     * The hazardous
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Dpd\StructType\Hazardous[]
     */
    public $hazardous;
    /**
     * The printInfo1OnParcelLabel
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $printInfo1OnParcelLabel;
    /**
     * The info1
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $info1;
    /**
     * The info2
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $info2;
    /**
     * The returns
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $returns;
    /**
     * The customsTransportCost
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $customsTransportCost;
    /**
     * The customsTransportCostCurrency
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customsTransportCostCurrency;
    /**
     * Constructor method for parcels
     * @uses Parcels::setParcelLabelNumber()
     * @uses Parcels::setCustomerReferenceNumber1()
     * @uses Parcels::setCustomerReferenceNumber2()
     * @uses Parcels::setCustomerReferenceNumber3()
     * @uses Parcels::setCustomerReferenceNumber4()
     * @uses Parcels::setSwap()
     * @uses Parcels::setVolume()
     * @uses Parcels::setWeight()
     * @uses Parcels::setHazardousLimitedQuantities()
     * @uses Parcels::setHigherInsurance()
     * @uses Parcels::setContent()
     * @uses Parcels::setAddService()
     * @uses Parcels::setMessageNumber()
     * @uses Parcels::setFunction()
     * @uses Parcels::setParameter()
     * @uses Parcels::setCod()
     * @uses Parcels::setInternational()
     * @uses Parcels::setHazardous()
     * @uses Parcels::setPrintInfo1OnParcelLabel()
     * @uses Parcels::setInfo1()
     * @uses Parcels::setInfo2()
     * @uses Parcels::setReturns()
     * @uses Parcels::setCustomsTransportCost()
     * @uses Parcels::setCustomsTransportCostCurrency()
     * @param string $parcelLabelNumber
     * @param string $customerReferenceNumber1
     * @param string $customerReferenceNumber2
     * @param string $customerReferenceNumber3
     * @param string $customerReferenceNumber4
     * @param bool $swap
     * @param int $volume
     * @param int $weight
     * @param bool $hazardousLimitedQuantities
     * @param \Dpd\StructType\HigherInsurance $higherInsurance
     * @param string $content
     * @param int $addService
     * @param int $messageNumber
     * @param string $function
     * @param string $parameter
     * @param \Dpd\StructType\Cod $cod
     * @param \Dpd\StructType\International $international
     * @param \Dpd\StructType\Hazardous[] $hazardous
     * @param bool $printInfo1OnParcelLabel
     * @param string $info1
     * @param string $info2
     * @param bool $returns
     * @param int $customsTransportCost
     * @param string $customsTransportCostCurrency
     */
    public function __construct($parcelLabelNumber = null, $customerReferenceNumber1 = null, $customerReferenceNumber2 = null, $customerReferenceNumber3 = null, $customerReferenceNumber4 = null, $swap = null, $volume = null, $weight = null, $hazardousLimitedQuantities = null, \Dpd\StructType\HigherInsurance $higherInsurance = null, $content = null, $addService = null, $messageNumber = null, $function = null, $parameter = null, \Dpd\StructType\Cod $cod = null, \Dpd\StructType\International $international = null, array $hazardous = array(), $printInfo1OnParcelLabel = null, $info1 = null, $info2 = null, $returns = null, $customsTransportCost = null, $customsTransportCostCurrency = null)
    {
        $this
            ->setParcelLabelNumber($parcelLabelNumber)
            ->setCustomerReferenceNumber1($customerReferenceNumber1)
            ->setCustomerReferenceNumber2($customerReferenceNumber2)
            ->setCustomerReferenceNumber3($customerReferenceNumber3)
            ->setCustomerReferenceNumber4($customerReferenceNumber4)
            ->setSwap($swap)
            ->setVolume($volume)
            ->setWeight($weight)
            ->setHazardousLimitedQuantities($hazardousLimitedQuantities)
            ->setHigherInsurance($higherInsurance)
            ->setContent($content)
            ->setAddService($addService)
            ->setMessageNumber($messageNumber)
            ->setFunction($function)
            ->setParameter($parameter)
            ->setCod($cod)
            ->setInternational($international)
            ->setHazardous($hazardous)
            ->setPrintInfo1OnParcelLabel($printInfo1OnParcelLabel)
            ->setInfo1($info1)
            ->setInfo2($info2)
            ->setReturns($returns)
            ->setCustomsTransportCost($customsTransportCost)
            ->setCustomsTransportCostCurrency($customsTransportCostCurrency);
    }
    /**
     * Get parcelLabelNumber value
     * @return string|null
     */
    public function getParcelLabelNumber()
    {
        return $this->parcelLabelNumber;
    }
    /**
     * Set parcelLabelNumber value
     * @param string $parcelLabelNumber
     * @return \Dpd\StructType\Parcels
     */
    public function setParcelLabelNumber($parcelLabelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelLabelNumber) && !is_string($parcelLabelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelLabelNumber, true), gettype($parcelLabelNumber)), __LINE__);
        }
        $this->parcelLabelNumber = $parcelLabelNumber;
        return $this;
    }
    /**
     * Get customerReferenceNumber1 value
     * @return string|null
     */
    public function getCustomerReferenceNumber1()
    {
        return $this->customerReferenceNumber1;
    }
    /**
     * Set customerReferenceNumber1 value
     * @param string $customerReferenceNumber1
     * @return \Dpd\StructType\Parcels
     */
    public function setCustomerReferenceNumber1($customerReferenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber1) && !is_string($customerReferenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber1, true), gettype($customerReferenceNumber1)), __LINE__);
        }
        $this->customerReferenceNumber1 = $customerReferenceNumber1;
        return $this;
    }
    /**
     * Get customerReferenceNumber2 value
     * @return string|null
     */
    public function getCustomerReferenceNumber2()
    {
        return $this->customerReferenceNumber2;
    }
    /**
     * Set customerReferenceNumber2 value
     * @param string $customerReferenceNumber2
     * @return \Dpd\StructType\Parcels
     */
    public function setCustomerReferenceNumber2($customerReferenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber2) && !is_string($customerReferenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber2, true), gettype($customerReferenceNumber2)), __LINE__);
        }
        $this->customerReferenceNumber2 = $customerReferenceNumber2;
        return $this;
    }
    /**
     * Get customerReferenceNumber3 value
     * @return string|null
     */
    public function getCustomerReferenceNumber3()
    {
        return $this->customerReferenceNumber3;
    }
    /**
     * Set customerReferenceNumber3 value
     * @param string $customerReferenceNumber3
     * @return \Dpd\StructType\Parcels
     */
    public function setCustomerReferenceNumber3($customerReferenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber3) && !is_string($customerReferenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber3, true), gettype($customerReferenceNumber3)), __LINE__);
        }
        $this->customerReferenceNumber3 = $customerReferenceNumber3;
        return $this;
    }
    /**
     * Get customerReferenceNumber4 value
     * @return string|null
     */
    public function getCustomerReferenceNumber4()
    {
        return $this->customerReferenceNumber4;
    }
    /**
     * Set customerReferenceNumber4 value
     * @param string $customerReferenceNumber4
     * @return \Dpd\StructType\Parcels
     */
    public function setCustomerReferenceNumber4($customerReferenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferenceNumber4) && !is_string($customerReferenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferenceNumber4, true), gettype($customerReferenceNumber4)), __LINE__);
        }
        $this->customerReferenceNumber4 = $customerReferenceNumber4;
        return $this;
    }
    /**
     * Get swap value
     * @return bool|null
     */
    public function getSwap()
    {
        return $this->swap;
    }
    /**
     * Set swap value
     * @param bool $swap
     * @return \Dpd\StructType\Parcels
     */
    public function setSwap($swap = null)
    {
        // validation for constraint: boolean
        if (!is_null($swap) && !is_bool($swap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($swap, true), gettype($swap)), __LINE__);
        }
        $this->swap = $swap;
        return $this;
    }
    /**
     * Get volume value
     * @return int|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param int $volume
     * @return \Dpd\StructType\Parcels
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: int
        if (!is_null($volume) && !(is_int($volume) || ctype_digit($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \Dpd\StructType\Parcels
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get hazardousLimitedQuantities value
     * @return bool|null
     */
    public function getHazardousLimitedQuantities()
    {
        return $this->hazardousLimitedQuantities;
    }
    /**
     * Set hazardousLimitedQuantities value
     * @param bool $hazardousLimitedQuantities
     * @return \Dpd\StructType\Parcels
     */
    public function setHazardousLimitedQuantities($hazardousLimitedQuantities = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardousLimitedQuantities) && !is_bool($hazardousLimitedQuantities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hazardousLimitedQuantities, true), gettype($hazardousLimitedQuantities)), __LINE__);
        }
        $this->hazardousLimitedQuantities = $hazardousLimitedQuantities;
        return $this;
    }
    /**
     * Get higherInsurance value
     * @return \Dpd\StructType\HigherInsurance|null
     */
    public function getHigherInsurance()
    {
        return $this->higherInsurance;
    }
    /**
     * Set higherInsurance value
     * @param \Dpd\StructType\HigherInsurance $higherInsurance
     * @return \Dpd\StructType\Parcels
     */
    public function setHigherInsurance(\Dpd\StructType\HigherInsurance $higherInsurance = null)
    {
        $this->higherInsurance = $higherInsurance;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \Dpd\StructType\Parcels
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get addService value
     * @return int|null
     */
    public function getAddService()
    {
        return $this->addService;
    }
    /**
     * Set addService value
     * @param int $addService
     * @return \Dpd\StructType\Parcels
     */
    public function setAddService($addService = null)
    {
        // validation for constraint: int
        if (!is_null($addService) && !(is_int($addService) || ctype_digit($addService))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addService, true), gettype($addService)), __LINE__);
        }
        $this->addService = $addService;
        return $this;
    }
    /**
     * Get messageNumber value
     * @return int|null
     */
    public function getMessageNumber()
    {
        return $this->messageNumber;
    }
    /**
     * Set messageNumber value
     * @param int $messageNumber
     * @return \Dpd\StructType\Parcels
     */
    public function setMessageNumber($messageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($messageNumber) && !(is_int($messageNumber) || ctype_digit($messageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageNumber, true), gettype($messageNumber)), __LINE__);
        }
        $this->messageNumber = $messageNumber;
        return $this;
    }
    /**
     * Get function value
     * @return string|null
     */
    public function getFunction()
    {
        return $this->function;
    }
    /**
     * Set function value
     * @param string $function
     * @return \Dpd\StructType\Parcels
     */
    public function setFunction($function = null)
    {
        // validation for constraint: string
        if (!is_null($function) && !is_string($function)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($function, true), gettype($function)), __LINE__);
        }
        $this->function = $function;
        return $this;
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @param string $parameter
     * @return \Dpd\StructType\Parcels
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: string
        if (!is_null($parameter) && !is_string($parameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameter, true), gettype($parameter)), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get cod value
     * @return \Dpd\StructType\Cod|null
     */
    public function getCod()
    {
        return $this->cod;
    }
    /**
     * Set cod value
     * @param \Dpd\StructType\Cod $cod
     * @return \Dpd\StructType\Parcels
     */
    public function setCod(\Dpd\StructType\Cod $cod = null)
    {
        $this->cod = $cod;
        return $this;
    }
    /**
     * Get international value
     * @return \Dpd\StructType\International|null
     */
    public function getInternational()
    {
        return $this->international;
    }
    /**
     * Set international value
     * @param \Dpd\StructType\International $international
     * @return \Dpd\StructType\Parcels
     */
    public function setInternational(\Dpd\StructType\International $international = null)
    {
        $this->international = $international;
        return $this;
    }
    /**
     * Get hazardous value
     * @return \Dpd\StructType\Hazardous[]|null
     */
    public function getHazardous()
    {
        return $this->hazardous;
    }
    /**
     * This method is responsible for validating the values passed to the setHazardous method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazardous method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazardousForArrayConstraintsFromSetHazardous(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelsHazardousItem) {
            // validation for constraint: itemType
            if (!$parcelsHazardousItem instanceof \Dpd\StructType\Hazardous) {
                $invalidValues[] = is_object($parcelsHazardousItem) ? get_class($parcelsHazardousItem) : sprintf('%s(%s)', gettype($parcelsHazardousItem), var_export($parcelsHazardousItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hazardous property can only contain items of type \Dpd\StructType\Hazardous, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hazardous value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Hazardous[] $hazardous
     * @return \Dpd\StructType\Parcels
     */
    public function setHazardous(array $hazardous = array())
    {
        // validation for constraint: array
        if ('' !== ($hazardousArrayErrorMessage = self::validateHazardousForArrayConstraintsFromSetHazardous($hazardous))) {
            throw new \InvalidArgumentException($hazardousArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($hazardous) && count($hazardous) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($hazardous)), __LINE__);
        }
        $this->hazardous = $hazardous;
        return $this;
    }
    /**
     * Add item to hazardous value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Hazardous $item
     * @return \Dpd\StructType\Parcels
     */
    public function addToHazardous(\Dpd\StructType\Hazardous $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\Hazardous) {
            throw new \InvalidArgumentException(sprintf('The hazardous property can only contain items of type \Dpd\StructType\Hazardous, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->hazardous) && count($this->hazardous) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->hazardous)), __LINE__);
        }
        $this->hazardous[] = $item;
        return $this;
    }
    /**
     * Get printInfo1OnParcelLabel value
     * @return bool|null
     */
    public function getPrintInfo1OnParcelLabel()
    {
        return $this->printInfo1OnParcelLabel;
    }
    /**
     * Set printInfo1OnParcelLabel value
     * @param bool $printInfo1OnParcelLabel
     * @return \Dpd\StructType\Parcels
     */
    public function setPrintInfo1OnParcelLabel($printInfo1OnParcelLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($printInfo1OnParcelLabel) && !is_bool($printInfo1OnParcelLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printInfo1OnParcelLabel, true), gettype($printInfo1OnParcelLabel)), __LINE__);
        }
        $this->printInfo1OnParcelLabel = $printInfo1OnParcelLabel;
        return $this;
    }
    /**
     * Get info1 value
     * @return string|null
     */
    public function getInfo1()
    {
        return $this->info1;
    }
    /**
     * Set info1 value
     * @param string $info1
     * @return \Dpd\StructType\Parcels
     */
    public function setInfo1($info1 = null)
    {
        // validation for constraint: string
        if (!is_null($info1) && !is_string($info1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info1, true), gettype($info1)), __LINE__);
        }
        $this->info1 = $info1;
        return $this;
    }
    /**
     * Get info2 value
     * @return string|null
     */
    public function getInfo2()
    {
        return $this->info2;
    }
    /**
     * Set info2 value
     * @param string $info2
     * @return \Dpd\StructType\Parcels
     */
    public function setInfo2($info2 = null)
    {
        // validation for constraint: string
        if (!is_null($info2) && !is_string($info2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info2, true), gettype($info2)), __LINE__);
        }
        $this->info2 = $info2;
        return $this;
    }
    /**
     * Get returns value
     * @return bool|null
     */
    public function getReturns()
    {
        return $this->returns;
    }
    /**
     * Set returns value
     * @param bool $returns
     * @return \Dpd\StructType\Parcels
     */
    public function setReturns($returns = null)
    {
        // validation for constraint: boolean
        if (!is_null($returns) && !is_bool($returns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returns, true), gettype($returns)), __LINE__);
        }
        $this->returns = $returns;
        return $this;
    }
    /**
     * Get customsTransportCost value
     * @return int|null
     */
    public function getCustomsTransportCost()
    {
        return $this->customsTransportCost;
    }
    /**
     * Set customsTransportCost value
     * @param int $customsTransportCost
     * @return \Dpd\StructType\Parcels
     */
    public function setCustomsTransportCost($customsTransportCost = null)
    {
        // validation for constraint: int
        if (!is_null($customsTransportCost) && !(is_int($customsTransportCost) || ctype_digit($customsTransportCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsTransportCost, true), gettype($customsTransportCost)), __LINE__);
        }
        $this->customsTransportCost = $customsTransportCost;
        return $this;
    }
    /**
     * Get customsTransportCostCurrency value
     * @return string|null
     */
    public function getCustomsTransportCostCurrency()
    {
        return $this->customsTransportCostCurrency;
    }
    /**
     * Set customsTransportCostCurrency value
     * @param string $customsTransportCostCurrency
     * @return \Dpd\StructType\Parcels
     */
    public function setCustomsTransportCostCurrency($customsTransportCostCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($customsTransportCostCurrency) && !is_string($customsTransportCostCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTransportCostCurrency, true), gettype($customsTransportCostCurrency)), __LINE__);
        }
        $this->customsTransportCostCurrency = $customsTransportCostCurrency;
        return $this;
    }
}
