<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for international StructType
 * @subpackage Structs
 */
class International extends AbstractStructBase
{
    /**
     * The parcelType
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $parcelType;
    /**
     * The customsAmount
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customsAmount;
    /**
     * The customsCurrency
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customsCurrency;
    /**
     * The customsAmountEx
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customsAmountEx;
    /**
     * The customsCurrencyEx
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customsCurrencyEx;
    /**
     * The exportReason
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $exportReason;
    /**
     * The customsTerms
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customsTerms;
    /**
     * The customsContent
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customsContent;
    /**
     * The customsInvoice
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $customsInvoice;
    /**
     * The customsInvoiceDate
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customsInvoiceDate;
    /**
     * The commercialInvoiceConsignee
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Dpd\StructType\Address
     */
    public $commercialInvoiceConsignee;
    /**
     * The commercialInvoiceConsignor
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Dpd\StructType\Address
     */
    public $commercialInvoiceConsignor;
    /**
     * The commercialInvoiceLine
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Dpd\StructType\InternationalLine[]
     */
    public $commercialInvoiceLine;
    /**
     * The clearanceCleared
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clearanceCleared;
    /**
     * The prealertStatus
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prealertStatus;
    /**
     * The customsPaper
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customsPaper;
    /**
     * The customsEnclosure
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $customsEnclosure;
    /**
     * The customsAmountParcel
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $customsAmountParcel;
    /**
     * The linehaul
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $linehaul;
    /**
     * The shipMrn
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipMrn;
    /**
     * The collectiveCustomsClearance
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $collectiveCustomsClearance;
    /**
     * The comment1
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment1;
    /**
     * The comment2
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment2;
    /**
     * The commercialInvoiceConsigneeVatNumber
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $commercialInvoiceConsigneeVatNumber;
    /**
     * Constructor method for international
     * @uses International::setParcelType()
     * @uses International::setCustomsAmount()
     * @uses International::setCustomsCurrency()
     * @uses International::setCustomsAmountEx()
     * @uses International::setCustomsCurrencyEx()
     * @uses International::setExportReason()
     * @uses International::setCustomsTerms()
     * @uses International::setCustomsContent()
     * @uses International::setCustomsInvoice()
     * @uses International::setCustomsInvoiceDate()
     * @uses International::setCommercialInvoiceConsignee()
     * @uses International::setCommercialInvoiceConsignor()
     * @uses International::setCommercialInvoiceLine()
     * @uses International::setClearanceCleared()
     * @uses International::setPrealertStatus()
     * @uses International::setCustomsPaper()
     * @uses International::setCustomsEnclosure()
     * @uses International::setCustomsAmountParcel()
     * @uses International::setLinehaul()
     * @uses International::setShipMrn()
     * @uses International::setCollectiveCustomsClearance()
     * @uses International::setComment1()
     * @uses International::setComment2()
     * @uses International::setCommercialInvoiceConsigneeVatNumber()
     * @param bool $parcelType
     * @param int $customsAmount
     * @param string $customsCurrency
     * @param int $customsAmountEx
     * @param string $customsCurrencyEx
     * @param string $exportReason
     * @param string $customsTerms
     * @param string $customsContent
     * @param string $customsInvoice
     * @param int $customsInvoiceDate
     * @param \Dpd\StructType\Address $commercialInvoiceConsignee
     * @param \Dpd\StructType\Address $commercialInvoiceConsignor
     * @param \Dpd\StructType\InternationalLine[] $commercialInvoiceLine
     * @param string $clearanceCleared
     * @param string $prealertStatus
     * @param string $customsPaper
     * @param bool $customsEnclosure
     * @param int $customsAmountParcel
     * @param string $linehaul
     * @param string $shipMrn
     * @param bool $collectiveCustomsClearance
     * @param string $comment1
     * @param string $comment2
     * @param string $commercialInvoiceConsigneeVatNumber
     */
    public function __construct($parcelType = null, $customsAmount = null, $customsCurrency = null, $customsAmountEx = null, $customsCurrencyEx = null, $exportReason = null, $customsTerms = null, $customsContent = null, $customsInvoice = null, $customsInvoiceDate = null, \Dpd\StructType\Address $commercialInvoiceConsignee = null, \Dpd\StructType\Address $commercialInvoiceConsignor = null, array $commercialInvoiceLine = array(), $clearanceCleared = null, $prealertStatus = null, $customsPaper = null, $customsEnclosure = null, $customsAmountParcel = null, $linehaul = null, $shipMrn = null, $collectiveCustomsClearance = null, $comment1 = null, $comment2 = null, $commercialInvoiceConsigneeVatNumber = null)
    {
        $this
            ->setParcelType($parcelType)
            ->setCustomsAmount($customsAmount)
            ->setCustomsCurrency($customsCurrency)
            ->setCustomsAmountEx($customsAmountEx)
            ->setCustomsCurrencyEx($customsCurrencyEx)
            ->setExportReason($exportReason)
            ->setCustomsTerms($customsTerms)
            ->setCustomsContent($customsContent)
            ->setCustomsInvoice($customsInvoice)
            ->setCustomsInvoiceDate($customsInvoiceDate)
            ->setCommercialInvoiceConsignee($commercialInvoiceConsignee)
            ->setCommercialInvoiceConsignor($commercialInvoiceConsignor)
            ->setCommercialInvoiceLine($commercialInvoiceLine)
            ->setClearanceCleared($clearanceCleared)
            ->setPrealertStatus($prealertStatus)
            ->setCustomsPaper($customsPaper)
            ->setCustomsEnclosure($customsEnclosure)
            ->setCustomsAmountParcel($customsAmountParcel)
            ->setLinehaul($linehaul)
            ->setShipMrn($shipMrn)
            ->setCollectiveCustomsClearance($collectiveCustomsClearance)
            ->setComment1($comment1)
            ->setComment2($comment2)
            ->setCommercialInvoiceConsigneeVatNumber($commercialInvoiceConsigneeVatNumber);
    }
    /**
     * Get parcelType value
     * @return bool
     */
    public function getParcelType()
    {
        return $this->parcelType;
    }
    /**
     * Set parcelType value
     * @param bool $parcelType
     * @return \Dpd\StructType\International
     */
    public function setParcelType($parcelType = null)
    {
        // validation for constraint: boolean
        if (!is_null($parcelType) && !is_bool($parcelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parcelType, true), gettype($parcelType)), __LINE__);
        }
        $this->parcelType = $parcelType;
        return $this;
    }
    /**
     * Get customsAmount value
     * @return int
     */
    public function getCustomsAmount()
    {
        return $this->customsAmount;
    }
    /**
     * Set customsAmount value
     * @param int $customsAmount
     * @return \Dpd\StructType\International
     */
    public function setCustomsAmount($customsAmount = null)
    {
        // validation for constraint: int
        if (!is_null($customsAmount) && !(is_int($customsAmount) || ctype_digit($customsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsAmount, true), gettype($customsAmount)), __LINE__);
        }
        $this->customsAmount = $customsAmount;
        return $this;
    }
    /**
     * Get customsCurrency value
     * @return string
     */
    public function getCustomsCurrency()
    {
        return $this->customsCurrency;
    }
    /**
     * Set customsCurrency value
     * @param string $customsCurrency
     * @return \Dpd\StructType\International
     */
    public function setCustomsCurrency($customsCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($customsCurrency) && !is_string($customsCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsCurrency, true), gettype($customsCurrency)), __LINE__);
        }
        $this->customsCurrency = $customsCurrency;
        return $this;
    }
    /**
     * Get customsAmountEx value
     * @return int
     */
    public function getCustomsAmountEx()
    {
        return $this->customsAmountEx;
    }
    /**
     * Set customsAmountEx value
     * @param int $customsAmountEx
     * @return \Dpd\StructType\International
     */
    public function setCustomsAmountEx($customsAmountEx = null)
    {
        // validation for constraint: int
        if (!is_null($customsAmountEx) && !(is_int($customsAmountEx) || ctype_digit($customsAmountEx))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsAmountEx, true), gettype($customsAmountEx)), __LINE__);
        }
        $this->customsAmountEx = $customsAmountEx;
        return $this;
    }
    /**
     * Get customsCurrencyEx value
     * @return string
     */
    public function getCustomsCurrencyEx()
    {
        return $this->customsCurrencyEx;
    }
    /**
     * Set customsCurrencyEx value
     * @param string $customsCurrencyEx
     * @return \Dpd\StructType\International
     */
    public function setCustomsCurrencyEx($customsCurrencyEx = null)
    {
        // validation for constraint: string
        if (!is_null($customsCurrencyEx) && !is_string($customsCurrencyEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsCurrencyEx, true), gettype($customsCurrencyEx)), __LINE__);
        }
        $this->customsCurrencyEx = $customsCurrencyEx;
        return $this;
    }
    /**
     * Get exportReason value
     * @return string
     */
    public function getExportReason()
    {
        return $this->exportReason;
    }
    /**
     * Set exportReason value
     * @param string $exportReason
     * @return \Dpd\StructType\International
     */
    public function setExportReason($exportReason = null)
    {
        // validation for constraint: string
        if (!is_null($exportReason) && !is_string($exportReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportReason, true), gettype($exportReason)), __LINE__);
        }
        $this->exportReason = $exportReason;
        return $this;
    }
    /**
     * Get customsTerms value
     * @return string
     */
    public function getCustomsTerms()
    {
        return $this->customsTerms;
    }
    /**
     * Set customsTerms value
     * @param string $customsTerms
     * @return \Dpd\StructType\International
     */
    public function setCustomsTerms($customsTerms = null)
    {
        // validation for constraint: string
        if (!is_null($customsTerms) && !is_string($customsTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTerms, true), gettype($customsTerms)), __LINE__);
        }
        $this->customsTerms = $customsTerms;
        return $this;
    }
    /**
     * Get customsContent value
     * @return string
     */
    public function getCustomsContent()
    {
        return $this->customsContent;
    }
    /**
     * Set customsContent value
     * @param string $customsContent
     * @return \Dpd\StructType\International
     */
    public function setCustomsContent($customsContent = null)
    {
        // validation for constraint: string
        if (!is_null($customsContent) && !is_string($customsContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsContent, true), gettype($customsContent)), __LINE__);
        }
        $this->customsContent = $customsContent;
        return $this;
    }
    /**
     * Get customsInvoice value
     * @return string
     */
    public function getCustomsInvoice()
    {
        return $this->customsInvoice;
    }
    /**
     * Set customsInvoice value
     * @param string $customsInvoice
     * @return \Dpd\StructType\International
     */
    public function setCustomsInvoice($customsInvoice = null)
    {
        // validation for constraint: string
        if (!is_null($customsInvoice) && !is_string($customsInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsInvoice, true), gettype($customsInvoice)), __LINE__);
        }
        $this->customsInvoice = $customsInvoice;
        return $this;
    }
    /**
     * Get customsInvoiceDate value
     * @return int
     */
    public function getCustomsInvoiceDate()
    {
        return $this->customsInvoiceDate;
    }
    /**
     * Set customsInvoiceDate value
     * @param int $customsInvoiceDate
     * @return \Dpd\StructType\International
     */
    public function setCustomsInvoiceDate($customsInvoiceDate = null)
    {
        // validation for constraint: int
        if (!is_null($customsInvoiceDate) && !(is_int($customsInvoiceDate) || ctype_digit($customsInvoiceDate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsInvoiceDate, true), gettype($customsInvoiceDate)), __LINE__);
        }
        $this->customsInvoiceDate = $customsInvoiceDate;
        return $this;
    }
    /**
     * Get commercialInvoiceConsignee value
     * @return \Dpd\StructType\Address
     */
    public function getCommercialInvoiceConsignee()
    {
        return $this->commercialInvoiceConsignee;
    }
    /**
     * Set commercialInvoiceConsignee value
     * @param \Dpd\StructType\Address $commercialInvoiceConsignee
     * @return \Dpd\StructType\International
     */
    public function setCommercialInvoiceConsignee(\Dpd\StructType\Address $commercialInvoiceConsignee = null)
    {
        $this->commercialInvoiceConsignee = $commercialInvoiceConsignee;
        return $this;
    }
    /**
     * Get commercialInvoiceConsignor value
     * @return \Dpd\StructType\Address
     */
    public function getCommercialInvoiceConsignor()
    {
        return $this->commercialInvoiceConsignor;
    }
    /**
     * Set commercialInvoiceConsignor value
     * @param \Dpd\StructType\Address $commercialInvoiceConsignor
     * @return \Dpd\StructType\International
     */
    public function setCommercialInvoiceConsignor(\Dpd\StructType\Address $commercialInvoiceConsignor = null)
    {
        $this->commercialInvoiceConsignor = $commercialInvoiceConsignor;
        return $this;
    }
    /**
     * Get commercialInvoiceLine value
     * @return \Dpd\StructType\InternationalLine[]
     */
    public function getCommercialInvoiceLine()
    {
        return $this->commercialInvoiceLine;
    }
    /**
     * This method is responsible for validating the values passed to the setCommercialInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommercialInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommercialInvoiceLineForArrayConstraintsFromSetCommercialInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internationalCommercialInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$internationalCommercialInvoiceLineItem instanceof \Dpd\StructType\InternationalLine) {
                $invalidValues[] = is_object($internationalCommercialInvoiceLineItem) ? get_class($internationalCommercialInvoiceLineItem) : sprintf('%s(%s)', gettype($internationalCommercialInvoiceLineItem), var_export($internationalCommercialInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The commercialInvoiceLine property can only contain items of type \Dpd\StructType\InternationalLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set commercialInvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\InternationalLine[] $commercialInvoiceLine
     * @return \Dpd\StructType\International
     */
    public function setCommercialInvoiceLine(array $commercialInvoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($commercialInvoiceLineArrayErrorMessage = self::validateCommercialInvoiceLineForArrayConstraintsFromSetCommercialInvoiceLine($commercialInvoiceLine))) {
            throw new \InvalidArgumentException($commercialInvoiceLineArrayErrorMessage, __LINE__);
        }
        $this->commercialInvoiceLine = $commercialInvoiceLine;
        return $this;
    }
    /**
     * Add item to commercialInvoiceLine value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\InternationalLine $item
     * @return \Dpd\StructType\International
     */
    public function addToCommercialInvoiceLine(\Dpd\StructType\InternationalLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\InternationalLine) {
            throw new \InvalidArgumentException(sprintf('The commercialInvoiceLine property can only contain items of type \Dpd\StructType\InternationalLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->commercialInvoiceLine[] = $item;
        return $this;
    }
    /**
     * Get clearanceCleared value
     * @return string|null
     */
    public function getClearanceCleared()
    {
        return $this->clearanceCleared;
    }
    /**
     * Set clearanceCleared value
     * @param string $clearanceCleared
     * @return \Dpd\StructType\International
     */
    public function setClearanceCleared($clearanceCleared = null)
    {
        // validation for constraint: string
        if (!is_null($clearanceCleared) && !is_string($clearanceCleared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearanceCleared, true), gettype($clearanceCleared)), __LINE__);
        }
        $this->clearanceCleared = $clearanceCleared;
        return $this;
    }
    /**
     * Get prealertStatus value
     * @return string|null
     */
    public function getPrealertStatus()
    {
        return $this->prealertStatus;
    }
    /**
     * Set prealertStatus value
     * @param string $prealertStatus
     * @return \Dpd\StructType\International
     */
    public function setPrealertStatus($prealertStatus = null)
    {
        // validation for constraint: string
        if (!is_null($prealertStatus) && !is_string($prealertStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prealertStatus, true), gettype($prealertStatus)), __LINE__);
        }
        $this->prealertStatus = $prealertStatus;
        return $this;
    }
    /**
     * Get customsPaper value
     * @return string|null
     */
    public function getCustomsPaper()
    {
        return $this->customsPaper;
    }
    /**
     * Set customsPaper value
     * @param string $customsPaper
     * @return \Dpd\StructType\International
     */
    public function setCustomsPaper($customsPaper = null)
    {
        // validation for constraint: string
        if (!is_null($customsPaper) && !is_string($customsPaper)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsPaper, true), gettype($customsPaper)), __LINE__);
        }
        $this->customsPaper = $customsPaper;
        return $this;
    }
    /**
     * Get customsEnclosure value
     * @return bool|null
     */
    public function getCustomsEnclosure()
    {
        return $this->customsEnclosure;
    }
    /**
     * Set customsEnclosure value
     * @param bool $customsEnclosure
     * @return \Dpd\StructType\International
     */
    public function setCustomsEnclosure($customsEnclosure = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsEnclosure) && !is_bool($customsEnclosure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customsEnclosure, true), gettype($customsEnclosure)), __LINE__);
        }
        $this->customsEnclosure = $customsEnclosure;
        return $this;
    }
    /**
     * Get customsAmountParcel value
     * @return int|null
     */
    public function getCustomsAmountParcel()
    {
        return $this->customsAmountParcel;
    }
    /**
     * Set customsAmountParcel value
     * @param int $customsAmountParcel
     * @return \Dpd\StructType\International
     */
    public function setCustomsAmountParcel($customsAmountParcel = null)
    {
        // validation for constraint: int
        if (!is_null($customsAmountParcel) && !(is_int($customsAmountParcel) || ctype_digit($customsAmountParcel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customsAmountParcel, true), gettype($customsAmountParcel)), __LINE__);
        }
        $this->customsAmountParcel = $customsAmountParcel;
        return $this;
    }
    /**
     * Get linehaul value
     * @return string|null
     */
    public function getLinehaul()
    {
        return $this->linehaul;
    }
    /**
     * Set linehaul value
     * @param string $linehaul
     * @return \Dpd\StructType\International
     */
    public function setLinehaul($linehaul = null)
    {
        // validation for constraint: string
        if (!is_null($linehaul) && !is_string($linehaul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linehaul, true), gettype($linehaul)), __LINE__);
        }
        $this->linehaul = $linehaul;
        return $this;
    }
    /**
     * Get shipMrn value
     * @return string|null
     */
    public function getShipMrn()
    {
        return $this->shipMrn;
    }
    /**
     * Set shipMrn value
     * @param string $shipMrn
     * @return \Dpd\StructType\International
     */
    public function setShipMrn($shipMrn = null)
    {
        // validation for constraint: string
        if (!is_null($shipMrn) && !is_string($shipMrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipMrn, true), gettype($shipMrn)), __LINE__);
        }
        $this->shipMrn = $shipMrn;
        return $this;
    }
    /**
     * Get collectiveCustomsClearance value
     * @return bool|null
     */
    public function getCollectiveCustomsClearance()
    {
        return $this->collectiveCustomsClearance;
    }
    /**
     * Set collectiveCustomsClearance value
     * @param bool $collectiveCustomsClearance
     * @return \Dpd\StructType\International
     */
    public function setCollectiveCustomsClearance($collectiveCustomsClearance = null)
    {
        // validation for constraint: boolean
        if (!is_null($collectiveCustomsClearance) && !is_bool($collectiveCustomsClearance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($collectiveCustomsClearance, true), gettype($collectiveCustomsClearance)), __LINE__);
        }
        $this->collectiveCustomsClearance = $collectiveCustomsClearance;
        return $this;
    }
    /**
     * Get comment1 value
     * @return string|null
     */
    public function getComment1()
    {
        return $this->comment1;
    }
    /**
     * Set comment1 value
     * @param string $comment1
     * @return \Dpd\StructType\International
     */
    public function setComment1($comment1 = null)
    {
        // validation for constraint: string
        if (!is_null($comment1) && !is_string($comment1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment1, true), gettype($comment1)), __LINE__);
        }
        $this->comment1 = $comment1;
        return $this;
    }
    /**
     * Get comment2 value
     * @return string|null
     */
    public function getComment2()
    {
        return $this->comment2;
    }
    /**
     * Set comment2 value
     * @param string $comment2
     * @return \Dpd\StructType\International
     */
    public function setComment2($comment2 = null)
    {
        // validation for constraint: string
        if (!is_null($comment2) && !is_string($comment2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment2, true), gettype($comment2)), __LINE__);
        }
        $this->comment2 = $comment2;
        return $this;
    }
    /**
     * Get commercialInvoiceConsigneeVatNumber value
     * @return string|null
     */
    public function getCommercialInvoiceConsigneeVatNumber()
    {
        return $this->commercialInvoiceConsigneeVatNumber;
    }
    /**
     * Set commercialInvoiceConsigneeVatNumber value
     * @param string $commercialInvoiceConsigneeVatNumber
     * @return \Dpd\StructType\International
     */
    public function setCommercialInvoiceConsigneeVatNumber($commercialInvoiceConsigneeVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($commercialInvoiceConsigneeVatNumber) && !is_string($commercialInvoiceConsigneeVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commercialInvoiceConsigneeVatNumber, true), gettype($commercialInvoiceConsigneeVatNumber)), __LINE__);
        }
        $this->commercialInvoiceConsigneeVatNumber = $commercialInvoiceConsigneeVatNumber;
        return $this;
    }
}
