<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hazardous StructType
 * @subpackage Structs
 */
class Hazardous extends AbstractStructBase
{
    /**
     * The identificationUnNo
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identificationUnNo;
    /**
     * The identificationClass
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $identificationClass;
    /**
     * The packingCode
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $packingCode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The hazardousWeight
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $hazardousWeight;
    /**
     * The factor
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $factor;
    /**
     * The classificationCode
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $classificationCode;
    /**
     * The packingGroup
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packingGroup;
    /**
     * The subsidiaryRisk
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subsidiaryRisk;
    /**
     * The tunnelRestrictionCode
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tunnelRestrictionCode;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $netWeight;
    /**
     * The notOtherwiseSpecified
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $notOtherwiseSpecified;
    /**
     * Constructor method for hazardous
     * @uses Hazardous::setIdentificationUnNo()
     * @uses Hazardous::setIdentificationClass()
     * @uses Hazardous::setPackingCode()
     * @uses Hazardous::setDescription()
     * @uses Hazardous::setHazardousWeight()
     * @uses Hazardous::setFactor()
     * @uses Hazardous::setClassificationCode()
     * @uses Hazardous::setPackingGroup()
     * @uses Hazardous::setSubsidiaryRisk()
     * @uses Hazardous::setTunnelRestrictionCode()
     * @uses Hazardous::setNetWeight()
     * @uses Hazardous::setNotOtherwiseSpecified()
     * @param string $identificationUnNo
     * @param string $identificationClass
     * @param string $packingCode
     * @param string $description
     * @param float $hazardousWeight
     * @param int $factor
     * @param string $classificationCode
     * @param string $packingGroup
     * @param string $subsidiaryRisk
     * @param string $tunnelRestrictionCode
     * @param float $netWeight
     * @param string $notOtherwiseSpecified
     */
    public function __construct($identificationUnNo = null, $identificationClass = null, $packingCode = null, $description = null, $hazardousWeight = null, $factor = null, $classificationCode = null, $packingGroup = null, $subsidiaryRisk = null, $tunnelRestrictionCode = null, $netWeight = null, $notOtherwiseSpecified = null)
    {
        $this
            ->setIdentificationUnNo($identificationUnNo)
            ->setIdentificationClass($identificationClass)
            ->setPackingCode($packingCode)
            ->setDescription($description)
            ->setHazardousWeight($hazardousWeight)
            ->setFactor($factor)
            ->setClassificationCode($classificationCode)
            ->setPackingGroup($packingGroup)
            ->setSubsidiaryRisk($subsidiaryRisk)
            ->setTunnelRestrictionCode($tunnelRestrictionCode)
            ->setNetWeight($netWeight)
            ->setNotOtherwiseSpecified($notOtherwiseSpecified);
    }
    /**
     * Get identificationUnNo value
     * @return string
     */
    public function getIdentificationUnNo()
    {
        return $this->identificationUnNo;
    }
    /**
     * Set identificationUnNo value
     * @param string $identificationUnNo
     * @return \Dpd\StructType\Hazardous
     */
    public function setIdentificationUnNo($identificationUnNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationUnNo) && !is_string($identificationUnNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationUnNo, true), gettype($identificationUnNo)), __LINE__);
        }
        $this->identificationUnNo = $identificationUnNo;
        return $this;
    }
    /**
     * Get identificationClass value
     * @return string
     */
    public function getIdentificationClass()
    {
        return $this->identificationClass;
    }
    /**
     * Set identificationClass value
     * @param string $identificationClass
     * @return \Dpd\StructType\Hazardous
     */
    public function setIdentificationClass($identificationClass = null)
    {
        // validation for constraint: string
        if (!is_null($identificationClass) && !is_string($identificationClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationClass, true), gettype($identificationClass)), __LINE__);
        }
        $this->identificationClass = $identificationClass;
        return $this;
    }
    /**
     * Get packingCode value
     * @return string
     */
    public function getPackingCode()
    {
        return $this->packingCode;
    }
    /**
     * Set packingCode value
     * @param string $packingCode
     * @return \Dpd\StructType\Hazardous
     */
    public function setPackingCode($packingCode = null)
    {
        // validation for constraint: string
        if (!is_null($packingCode) && !is_string($packingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packingCode, true), gettype($packingCode)), __LINE__);
        }
        $this->packingCode = $packingCode;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Dpd\StructType\Hazardous
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get hazardousWeight value
     * @return float
     */
    public function getHazardousWeight()
    {
        return $this->hazardousWeight;
    }
    /**
     * Set hazardousWeight value
     * @param float $hazardousWeight
     * @return \Dpd\StructType\Hazardous
     */
    public function setHazardousWeight($hazardousWeight = null)
    {
        // validation for constraint: float
        if (!is_null($hazardousWeight) && !(is_float($hazardousWeight) || is_numeric($hazardousWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hazardousWeight, true), gettype($hazardousWeight)), __LINE__);
        }
        $this->hazardousWeight = $hazardousWeight;
        return $this;
    }
    /**
     * Get factor value
     * @return int
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param int $factor
     * @return \Dpd\StructType\Hazardous
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: int
        if (!is_null($factor) && !(is_int($factor) || ctype_digit($factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($factor, true), gettype($factor)), __LINE__);
        }
        $this->factor = $factor;
        return $this;
    }
    /**
     * Get classificationCode value
     * @return string|null
     */
    public function getClassificationCode()
    {
        return $this->classificationCode;
    }
    /**
     * Set classificationCode value
     * @param string $classificationCode
     * @return \Dpd\StructType\Hazardous
     */
    public function setClassificationCode($classificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($classificationCode) && !is_string($classificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classificationCode, true), gettype($classificationCode)), __LINE__);
        }
        $this->classificationCode = $classificationCode;
        return $this;
    }
    /**
     * Get packingGroup value
     * @return string|null
     */
    public function getPackingGroup()
    {
        return $this->packingGroup;
    }
    /**
     * Set packingGroup value
     * @param string $packingGroup
     * @return \Dpd\StructType\Hazardous
     */
    public function setPackingGroup($packingGroup = null)
    {
        // validation for constraint: string
        if (!is_null($packingGroup) && !is_string($packingGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packingGroup, true), gettype($packingGroup)), __LINE__);
        }
        $this->packingGroup = $packingGroup;
        return $this;
    }
    /**
     * Get subsidiaryRisk value
     * @return string|null
     */
    public function getSubsidiaryRisk()
    {
        return $this->subsidiaryRisk;
    }
    /**
     * Set subsidiaryRisk value
     * @param string $subsidiaryRisk
     * @return \Dpd\StructType\Hazardous
     */
    public function setSubsidiaryRisk($subsidiaryRisk = null)
    {
        // validation for constraint: string
        if (!is_null($subsidiaryRisk) && !is_string($subsidiaryRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidiaryRisk, true), gettype($subsidiaryRisk)), __LINE__);
        }
        $this->subsidiaryRisk = $subsidiaryRisk;
        return $this;
    }
    /**
     * Get tunnelRestrictionCode value
     * @return string|null
     */
    public function getTunnelRestrictionCode()
    {
        return $this->tunnelRestrictionCode;
    }
    /**
     * Set tunnelRestrictionCode value
     * @param string $tunnelRestrictionCode
     * @return \Dpd\StructType\Hazardous
     */
    public function setTunnelRestrictionCode($tunnelRestrictionCode = null)
    {
        // validation for constraint: string
        if (!is_null($tunnelRestrictionCode) && !is_string($tunnelRestrictionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tunnelRestrictionCode, true), gettype($tunnelRestrictionCode)), __LINE__);
        }
        $this->tunnelRestrictionCode = $tunnelRestrictionCode;
        return $this;
    }
    /**
     * Get netWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param float $netWeight
     * @return \Dpd\StructType\Hazardous
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: float
        if (!is_null($netWeight) && !(is_float($netWeight) || is_numeric($netWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeight, true), gettype($netWeight)), __LINE__);
        }
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get notOtherwiseSpecified value
     * @return string|null
     */
    public function getNotOtherwiseSpecified()
    {
        return $this->notOtherwiseSpecified;
    }
    /**
     * Set notOtherwiseSpecified value
     * @param string $notOtherwiseSpecified
     * @return \Dpd\StructType\Hazardous
     */
    public function setNotOtherwiseSpecified($notOtherwiseSpecified = null)
    {
        // validation for constraint: string
        if (!is_null($notOtherwiseSpecified) && !is_string($notOtherwiseSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notOtherwiseSpecified, true), gettype($notOtherwiseSpecified)), __LINE__);
        }
        $this->notOtherwiseSpecified = $notOtherwiseSpecified;
        return $this;
    }
}
