<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generalShipmentData StructType
 * @subpackage Structs
 */
class GeneralShipmentData extends AbstractStructBase
{
    /**
     * The sendingDepot
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sendingDepot;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Dpd\StructType\Address
     */
    public $sender;
    /**
     * The recipient
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Dpd\StructType\Address
     */
    public $recipient;
    /**
     * The mpsId
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsId;
    /**
     * The cUser
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cUser;
    /**
     * The mpsCustomerReferenceNumber1
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber1;
    /**
     * The mpsCustomerReferenceNumber2
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber2;
    /**
     * The mpsCustomerReferenceNumber3
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber3;
    /**
     * The mpsCustomerReferenceNumber4
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsCustomerReferenceNumber4;
    /**
     * The identificationNumber
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identificationNumber;
    /**
     * The mpsCompleteDelivery
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $mpsCompleteDelivery;
    /**
     * The mpsCompleteDeliveryLabel
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $mpsCompleteDeliveryLabel;
    /**
     * The mpsVolume
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $mpsVolume;
    /**
     * The mpsWeight
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $mpsWeight;
    /**
     * The mpsExpectedSendingDate
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsExpectedSendingDate;
    /**
     * The mpsExpectedSendingTime
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsExpectedSendingTime;
    /**
     * Constructor method for generalShipmentData
     * @uses GeneralShipmentData::setSendingDepot()
     * @uses GeneralShipmentData::setProduct()
     * @uses GeneralShipmentData::setSender()
     * @uses GeneralShipmentData::setRecipient()
     * @uses GeneralShipmentData::setMpsId()
     * @uses GeneralShipmentData::setCUser()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber1()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber2()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber3()
     * @uses GeneralShipmentData::setMpsCustomerReferenceNumber4()
     * @uses GeneralShipmentData::setIdentificationNumber()
     * @uses GeneralShipmentData::setMpsCompleteDelivery()
     * @uses GeneralShipmentData::setMpsCompleteDeliveryLabel()
     * @uses GeneralShipmentData::setMpsVolume()
     * @uses GeneralShipmentData::setMpsWeight()
     * @uses GeneralShipmentData::setMpsExpectedSendingDate()
     * @uses GeneralShipmentData::setMpsExpectedSendingTime()
     * @param string $sendingDepot
     * @param string $product
     * @param \Dpd\StructType\Address $sender
     * @param \Dpd\StructType\Address $recipient
     * @param string $mpsId
     * @param string $cUser
     * @param string $mpsCustomerReferenceNumber1
     * @param string $mpsCustomerReferenceNumber2
     * @param string $mpsCustomerReferenceNumber3
     * @param string $mpsCustomerReferenceNumber4
     * @param string $identificationNumber
     * @param bool $mpsCompleteDelivery
     * @param bool $mpsCompleteDeliveryLabel
     * @param int $mpsVolume
     * @param int $mpsWeight
     * @param string $mpsExpectedSendingDate
     * @param string $mpsExpectedSendingTime
     */
    public function __construct($sendingDepot = null, $product = null, \Dpd\StructType\Address $sender = null, \Dpd\StructType\Address $recipient = null, $mpsId = null, $cUser = null, $mpsCustomerReferenceNumber1 = null, $mpsCustomerReferenceNumber2 = null, $mpsCustomerReferenceNumber3 = null, $mpsCustomerReferenceNumber4 = null, $identificationNumber = null, $mpsCompleteDelivery = null, $mpsCompleteDeliveryLabel = null, $mpsVolume = null, $mpsWeight = null, $mpsExpectedSendingDate = null, $mpsExpectedSendingTime = null)
    {
        $this
            ->setSendingDepot($sendingDepot)
            ->setProduct($product)
            ->setSender($sender)
            ->setRecipient($recipient)
            ->setMpsId($mpsId)
            ->setCUser($cUser)
            ->setMpsCustomerReferenceNumber1($mpsCustomerReferenceNumber1)
            ->setMpsCustomerReferenceNumber2($mpsCustomerReferenceNumber2)
            ->setMpsCustomerReferenceNumber3($mpsCustomerReferenceNumber3)
            ->setMpsCustomerReferenceNumber4($mpsCustomerReferenceNumber4)
            ->setIdentificationNumber($identificationNumber)
            ->setMpsCompleteDelivery($mpsCompleteDelivery)
            ->setMpsCompleteDeliveryLabel($mpsCompleteDeliveryLabel)
            ->setMpsVolume($mpsVolume)
            ->setMpsWeight($mpsWeight)
            ->setMpsExpectedSendingDate($mpsExpectedSendingDate)
            ->setMpsExpectedSendingTime($mpsExpectedSendingTime);
    }
    /**
     * Get sendingDepot value
     * @return string
     */
    public function getSendingDepot()
    {
        return $this->sendingDepot;
    }
    /**
     * Set sendingDepot value
     * @param string $sendingDepot
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setSendingDepot($sendingDepot = null)
    {
        // validation for constraint: string
        if (!is_null($sendingDepot) && !is_string($sendingDepot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendingDepot, true), gettype($sendingDepot)), __LINE__);
        }
        $this->sendingDepot = $sendingDepot;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get sender value
     * @return \Dpd\StructType\Address
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \Dpd\StructType\Address $sender
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setSender(\Dpd\StructType\Address $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get recipient value
     * @return \Dpd\StructType\Address
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @param \Dpd\StructType\Address $recipient
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setRecipient(\Dpd\StructType\Address $recipient = null)
    {
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Get mpsId value
     * @return string|null
     */
    public function getMpsId()
    {
        return $this->mpsId;
    }
    /**
     * Set mpsId value
     * @param string $mpsId
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsId($mpsId = null)
    {
        // validation for constraint: string
        if (!is_null($mpsId) && !is_string($mpsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsId, true), gettype($mpsId)), __LINE__);
        }
        $this->mpsId = $mpsId;
        return $this;
    }
    /**
     * Get cUser value
     * @return string|null
     */
    public function getCUser()
    {
        return $this->cUser;
    }
    /**
     * Set cUser value
     * @param string $cUser
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setCUser($cUser = null)
    {
        // validation for constraint: string
        if (!is_null($cUser) && !is_string($cUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cUser, true), gettype($cUser)), __LINE__);
        }
        $this->cUser = $cUser;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber1 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber1()
    {
        return $this->mpsCustomerReferenceNumber1;
    }
    /**
     * Set mpsCustomerReferenceNumber1 value
     * @param string $mpsCustomerReferenceNumber1
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber1($mpsCustomerReferenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber1) && !is_string($mpsCustomerReferenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber1, true), gettype($mpsCustomerReferenceNumber1)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber1 = $mpsCustomerReferenceNumber1;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber2 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber2()
    {
        return $this->mpsCustomerReferenceNumber2;
    }
    /**
     * Set mpsCustomerReferenceNumber2 value
     * @param string $mpsCustomerReferenceNumber2
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber2($mpsCustomerReferenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber2) && !is_string($mpsCustomerReferenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber2, true), gettype($mpsCustomerReferenceNumber2)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber2 = $mpsCustomerReferenceNumber2;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber3 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber3()
    {
        return $this->mpsCustomerReferenceNumber3;
    }
    /**
     * Set mpsCustomerReferenceNumber3 value
     * @param string $mpsCustomerReferenceNumber3
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber3($mpsCustomerReferenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber3) && !is_string($mpsCustomerReferenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber3, true), gettype($mpsCustomerReferenceNumber3)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber3 = $mpsCustomerReferenceNumber3;
        return $this;
    }
    /**
     * Get mpsCustomerReferenceNumber4 value
     * @return string|null
     */
    public function getMpsCustomerReferenceNumber4()
    {
        return $this->mpsCustomerReferenceNumber4;
    }
    /**
     * Set mpsCustomerReferenceNumber4 value
     * @param string $mpsCustomerReferenceNumber4
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsCustomerReferenceNumber4($mpsCustomerReferenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($mpsCustomerReferenceNumber4) && !is_string($mpsCustomerReferenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsCustomerReferenceNumber4, true), gettype($mpsCustomerReferenceNumber4)), __LINE__);
        }
        $this->mpsCustomerReferenceNumber4 = $mpsCustomerReferenceNumber4;
        return $this;
    }
    /**
     * Get identificationNumber value
     * @return string|null
     */
    public function getIdentificationNumber()
    {
        return $this->identificationNumber;
    }
    /**
     * Set identificationNumber value
     * @param string $identificationNumber
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNumber, true), gettype($identificationNumber)), __LINE__);
        }
        $this->identificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get mpsCompleteDelivery value
     * @return bool|null
     */
    public function getMpsCompleteDelivery()
    {
        return $this->mpsCompleteDelivery;
    }
    /**
     * Set mpsCompleteDelivery value
     * @param bool $mpsCompleteDelivery
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsCompleteDelivery($mpsCompleteDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($mpsCompleteDelivery) && !is_bool($mpsCompleteDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mpsCompleteDelivery, true), gettype($mpsCompleteDelivery)), __LINE__);
        }
        $this->mpsCompleteDelivery = $mpsCompleteDelivery;
        return $this;
    }
    /**
     * Get mpsCompleteDeliveryLabel value
     * @return bool|null
     */
    public function getMpsCompleteDeliveryLabel()
    {
        return $this->mpsCompleteDeliveryLabel;
    }
    /**
     * Set mpsCompleteDeliveryLabel value
     * @param bool $mpsCompleteDeliveryLabel
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsCompleteDeliveryLabel($mpsCompleteDeliveryLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($mpsCompleteDeliveryLabel) && !is_bool($mpsCompleteDeliveryLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mpsCompleteDeliveryLabel, true), gettype($mpsCompleteDeliveryLabel)), __LINE__);
        }
        $this->mpsCompleteDeliveryLabel = $mpsCompleteDeliveryLabel;
        return $this;
    }
    /**
     * Get mpsVolume value
     * @return int|null
     */
    public function getMpsVolume()
    {
        return $this->mpsVolume;
    }
    /**
     * Set mpsVolume value
     * @param int $mpsVolume
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsVolume($mpsVolume = null)
    {
        // validation for constraint: int
        if (!is_null($mpsVolume) && !(is_int($mpsVolume) || ctype_digit($mpsVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mpsVolume, true), gettype($mpsVolume)), __LINE__);
        }
        $this->mpsVolume = $mpsVolume;
        return $this;
    }
    /**
     * Get mpsWeight value
     * @return int|null
     */
    public function getMpsWeight()
    {
        return $this->mpsWeight;
    }
    /**
     * Set mpsWeight value
     * @param int $mpsWeight
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsWeight($mpsWeight = null)
    {
        // validation for constraint: int
        if (!is_null($mpsWeight) && !(is_int($mpsWeight) || ctype_digit($mpsWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mpsWeight, true), gettype($mpsWeight)), __LINE__);
        }
        $this->mpsWeight = $mpsWeight;
        return $this;
    }
    /**
     * Get mpsExpectedSendingDate value
     * @return string|null
     */
    public function getMpsExpectedSendingDate()
    {
        return $this->mpsExpectedSendingDate;
    }
    /**
     * Set mpsExpectedSendingDate value
     * @param string $mpsExpectedSendingDate
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsExpectedSendingDate($mpsExpectedSendingDate = null)
    {
        // validation for constraint: string
        if (!is_null($mpsExpectedSendingDate) && !is_string($mpsExpectedSendingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsExpectedSendingDate, true), gettype($mpsExpectedSendingDate)), __LINE__);
        }
        $this->mpsExpectedSendingDate = $mpsExpectedSendingDate;
        return $this;
    }
    /**
     * Get mpsExpectedSendingTime value
     * @return string|null
     */
    public function getMpsExpectedSendingTime()
    {
        return $this->mpsExpectedSendingTime;
    }
    /**
     * Set mpsExpectedSendingTime value
     * @param string $mpsExpectedSendingTime
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function setMpsExpectedSendingTime($mpsExpectedSendingTime = null)
    {
        // validation for constraint: string
        if (!is_null($mpsExpectedSendingTime) && !is_string($mpsExpectedSendingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsExpectedSendingTime, true), gettype($mpsExpectedSendingTime)), __LINE__);
        }
        $this->mpsExpectedSendingTime = $mpsExpectedSendingTime;
        return $this;
    }
}
