<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cod StructType
 * @subpackage Structs
 */
class Cod extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The inkasso
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $inkasso;
    /**
     * The purpose
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $purpose;
    /**
     * The bankCode
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankCode;
    /**
     * The bankName
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankName;
    /**
     * The bankAccountNumber
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The bankAccountHolder
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankAccountHolder;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iban;
    /**
     * The bic
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bic;
    /**
     * Constructor method for cod
     * @uses Cod::setAmount()
     * @uses Cod::setCurrency()
     * @uses Cod::setInkasso()
     * @uses Cod::setPurpose()
     * @uses Cod::setBankCode()
     * @uses Cod::setBankName()
     * @uses Cod::setBankAccountNumber()
     * @uses Cod::setBankAccountHolder()
     * @uses Cod::setIban()
     * @uses Cod::setBic()
     * @param int $amount
     * @param string $currency
     * @param int $inkasso
     * @param string $purpose
     * @param string $bankCode
     * @param string $bankName
     * @param string $bankAccountNumber
     * @param string $bankAccountHolder
     * @param string $iban
     * @param string $bic
     */
    public function __construct($amount = null, $currency = null, $inkasso = null, $purpose = null, $bankCode = null, $bankName = null, $bankAccountNumber = null, $bankAccountHolder = null, $iban = null, $bic = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setInkasso($inkasso)
            ->setPurpose($purpose)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBankAccountNumber($bankAccountNumber)
            ->setBankAccountHolder($bankAccountHolder)
            ->setIban($iban)
            ->setBic($bic);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \Dpd\StructType\Cod
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \Dpd\StructType\Cod
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get inkasso value
     * @return int
     */
    public function getInkasso()
    {
        return $this->inkasso;
    }
    /**
     * Set inkasso value
     * @param int $inkasso
     * @return \Dpd\StructType\Cod
     */
    public function setInkasso($inkasso = null)
    {
        // validation for constraint: int
        if (!is_null($inkasso) && !(is_int($inkasso) || ctype_digit($inkasso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inkasso, true), gettype($inkasso)), __LINE__);
        }
        $this->inkasso = $inkasso;
        return $this;
    }
    /**
     * Get purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->purpose;
    }
    /**
     * Set purpose value
     * @param string $purpose
     * @return \Dpd\StructType\Cod
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        $this->purpose = $purpose;
        return $this;
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \Dpd\StructType\Cod
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \Dpd\StructType\Cod
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \Dpd\StructType\Cod
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountNumber, true), gettype($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get bankAccountHolder value
     * @return string|null
     */
    public function getBankAccountHolder()
    {
        return $this->bankAccountHolder;
    }
    /**
     * Set bankAccountHolder value
     * @param string $bankAccountHolder
     * @return \Dpd\StructType\Cod
     */
    public function setBankAccountHolder($bankAccountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountHolder) && !is_string($bankAccountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountHolder, true), gettype($bankAccountHolder)), __LINE__);
        }
        $this->bankAccountHolder = $bankAccountHolder;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \Dpd\StructType\Cod
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \Dpd\StructType\Cod
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
}
