<?php

namespace Dpd;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'storeOrders' => '\\Dpd\\StructType\\StoreOrders',
            'printOptions' => '\\Dpd\\StructType\\PrintOptions',
            'printer' => '\\Dpd\\StructType\\Printer',
            'order' => '\\Dpd\\StructType\\Order',
            'generalShipmentData' => '\\Dpd\\StructType\\GeneralShipmentData',
            'address' => '\\Dpd\\StructType\\Address',
            'parcels' => '\\Dpd\\StructType\\Parcels',
            'higherInsurance' => '\\Dpd\\StructType\\HigherInsurance',
            'cod' => '\\Dpd\\StructType\\Cod',
            'international' => '\\Dpd\\StructType\\International',
            'internationalLine' => '\\Dpd\\StructType\\InternationalLine',
            'hazardous' => '\\Dpd\\StructType\\Hazardous',
            'productAndServiceData' => '\\Dpd\\StructType\\ProductAndServiceData',
            'personalDelivery' => '\\Dpd\\StructType\\PersonalDelivery',
            'pickup' => '\\Dpd\\StructType\\Pickup',
            'parcelShopDelivery' => '\\Dpd\\StructType\\ParcelShopDelivery',
            'notification' => '\\Dpd\\StructType\\Notification',
            'proactiveNotification' => '\\Dpd\\StructType\\ProactiveNotification',
            'delivery' => '\\Dpd\\StructType\\Delivery',
            'storeOrdersResponse' => '\\Dpd\\StructType\\StoreOrdersResponse',
            'StoreOrdersResponseDto33' => '\\Dpd\\StructType\\StoreOrdersResponseDto33',
            'storeOrdersResponseType' => '\\Dpd\\StructType\\StoreOrdersResponseType',
            'shipmentResponses' => '\\Dpd\\StructType\\ShipmentResponses',
            'parcelInformation' => '\\Dpd\\StructType\\ParcelInformation',
            'faults' => '\\Dpd\\StructType\\Faults',
            'authentication' => '\\Dpd\\StructType\\Authentication',
            'authenticationFault' => '\\Dpd\\StructType\\AuthenticationFault',
        );
    }
}
