<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printOptions StructType
 * @subpackage Structs
 */
class PrintOptions extends AbstractStructBase
{
    /**
     * The printerLanguage
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $printerLanguage;
    /**
     * The paperFormat
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paperFormat;
    /**
     * The printer
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Printer
     */
    public $printer;
    /**
     * The startPosition
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startPosition;
    /**
     * The printerResolution
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $printerResolution;
    /**
     * Constructor method for printOptions
     * @uses PrintOptions::setPrinterLanguage()
     * @uses PrintOptions::setPaperFormat()
     * @uses PrintOptions::setPrinter()
     * @uses PrintOptions::setStartPosition()
     * @uses PrintOptions::setPrinterResolution()
     * @param string $printerLanguage
     * @param string $paperFormat
     * @param \Dpd\StructType\Printer $printer
     * @param string $startPosition
     * @param float $printerResolution
     */
    public function __construct($printerLanguage = null, $paperFormat = null, \Dpd\StructType\Printer $printer = null, $startPosition = null, $printerResolution = null)
    {
        $this
            ->setPrinterLanguage($printerLanguage)
            ->setPaperFormat($paperFormat)
            ->setPrinter($printer)
            ->setStartPosition($startPosition)
            ->setPrinterResolution($printerResolution);
    }
    /**
     * Get printerLanguage value
     * @return string
     */
    public function getPrinterLanguage()
    {
        return $this->printerLanguage;
    }
    /**
     * Set printerLanguage value
     * @param string $printerLanguage
     * @return \Dpd\StructType\PrintOptions
     */
    public function setPrinterLanguage($printerLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($printerLanguage) && !is_string($printerLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerLanguage, true), gettype($printerLanguage)), __LINE__);
        }
        $this->printerLanguage = $printerLanguage;
        return $this;
    }
    /**
     * Get paperFormat value
     * @return string
     */
    public function getPaperFormat()
    {
        return $this->paperFormat;
    }
    /**
     * Set paperFormat value
     * @param string $paperFormat
     * @return \Dpd\StructType\PrintOptions
     */
    public function setPaperFormat($paperFormat = null)
    {
        // validation for constraint: string
        if (!is_null($paperFormat) && !is_string($paperFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paperFormat, true), gettype($paperFormat)), __LINE__);
        }
        $this->paperFormat = $paperFormat;
        return $this;
    }
    /**
     * Get printer value
     * @return \Dpd\StructType\Printer|null
     */
    public function getPrinter()
    {
        return $this->printer;
    }
    /**
     * Set printer value
     * @param \Dpd\StructType\Printer $printer
     * @return \Dpd\StructType\PrintOptions
     */
    public function setPrinter(\Dpd\StructType\Printer $printer = null)
    {
        $this->printer = $printer;
        return $this;
    }
    /**
     * Get startPosition value
     * @return string|null
     */
    public function getStartPosition()
    {
        return $this->startPosition;
    }
    /**
     * Set startPosition value
     * @uses \Dpd\EnumType\StartPositionEnum::valueIsValid()
     * @uses \Dpd\EnumType\StartPositionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startPosition
     * @return \Dpd\StructType\PrintOptions
     */
    public function setStartPosition($startPosition = null)
    {
        // validation for constraint: enumeration
        if (!\Dpd\EnumType\StartPositionEnum::valueIsValid($startPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Dpd\EnumType\StartPositionEnum', is_array($startPosition) ? implode(', ', $startPosition) : var_export($startPosition, true), implode(', ', \Dpd\EnumType\StartPositionEnum::getValidValues())), __LINE__);
        }
        $this->startPosition = $startPosition;
        return $this;
    }
    /**
     * Get printerResolution value
     * @return float|null
     */
    public function getPrinterResolution()
    {
        return $this->printerResolution;
    }
    /**
     * Set printerResolution value
     * @param float $printerResolution
     * @return \Dpd\StructType\PrintOptions
     */
    public function setPrinterResolution($printerResolution = null)
    {
        // validation for constraint: float
        if (!is_null($printerResolution) && !(is_float($printerResolution) || is_numeric($printerResolution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($printerResolution, true), gettype($printerResolution)), __LINE__);
        }
        $this->printerResolution = $printerResolution;
        return $this;
    }
}
