<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelInformation StructType
 * @subpackage Structs
 */
class ParcelInformation extends AbstractStructBase
{
    /**
     * The parcelLabelNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcelLabelNumber;
    /**
     * The dpdReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dpdReference;
    /**
     * Constructor method for parcelInformation
     * @uses ParcelInformation::setParcelLabelNumber()
     * @uses ParcelInformation::setDpdReference()
     * @param string $parcelLabelNumber
     * @param string $dpdReference
     */
    public function __construct($parcelLabelNumber = null, $dpdReference = null)
    {
        $this
            ->setParcelLabelNumber($parcelLabelNumber)
            ->setDpdReference($dpdReference);
    }
    /**
     * Get parcelLabelNumber value
     * @return string|null
     */
    public function getParcelLabelNumber()
    {
        return $this->parcelLabelNumber;
    }
    /**
     * Set parcelLabelNumber value
     * @param string $parcelLabelNumber
     * @return \Dpd\StructType\ParcelInformation
     */
    public function setParcelLabelNumber($parcelLabelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelLabelNumber) && !is_string($parcelLabelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelLabelNumber, true), gettype($parcelLabelNumber)), __LINE__);
        }
        $this->parcelLabelNumber = $parcelLabelNumber;
        return $this;
    }
    /**
     * Get dpdReference value
     * @return string|null
     */
    public function getDpdReference()
    {
        return $this->dpdReference;
    }
    /**
     * Set dpdReference value
     * @param string $dpdReference
     * @return \Dpd\StructType\ParcelInformation
     */
    public function setDpdReference($dpdReference = null)
    {
        // validation for constraint: string
        if (!is_null($dpdReference) && !is_string($dpdReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dpdReference, true), gettype($dpdReference)), __LINE__);
        }
        $this->dpdReference = $dpdReference;
        return $this;
    }
}
