<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The generalShipmentData
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Dpd\StructType\GeneralShipmentData
     */
    public $generalShipmentData;
    /**
     * The productAndServiceData
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Dpd\StructType\ProductAndServiceData
     */
    public $productAndServiceData;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Dpd\StructType\Parcels[]
     */
    public $parcels;
    /**
     * Constructor method for order
     * @uses Order::setGeneralShipmentData()
     * @uses Order::setProductAndServiceData()
     * @uses Order::setParcels()
     * @param \Dpd\StructType\GeneralShipmentData $generalShipmentData
     * @param \Dpd\StructType\ProductAndServiceData $productAndServiceData
     * @param \Dpd\StructType\Parcels[] $parcels
     */
    public function __construct(\Dpd\StructType\GeneralShipmentData $generalShipmentData = null, \Dpd\StructType\ProductAndServiceData $productAndServiceData = null, array $parcels = array())
    {
        $this
            ->setGeneralShipmentData($generalShipmentData)
            ->setProductAndServiceData($productAndServiceData)
            ->setParcels($parcels);
    }
    /**
     * Get generalShipmentData value
     * @return \Dpd\StructType\GeneralShipmentData
     */
    public function getGeneralShipmentData()
    {
        return $this->generalShipmentData;
    }
    /**
     * Set generalShipmentData value
     * @param \Dpd\StructType\GeneralShipmentData $generalShipmentData
     * @return \Dpd\StructType\Order
     */
    public function setGeneralShipmentData(\Dpd\StructType\GeneralShipmentData $generalShipmentData = null)
    {
        $this->generalShipmentData = $generalShipmentData;
        return $this;
    }
    /**
     * Get productAndServiceData value
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function getProductAndServiceData()
    {
        return $this->productAndServiceData;
    }
    /**
     * Set productAndServiceData value
     * @param \Dpd\StructType\ProductAndServiceData $productAndServiceData
     * @return \Dpd\StructType\Order
     */
    public function setProductAndServiceData(\Dpd\StructType\ProductAndServiceData $productAndServiceData = null)
    {
        $this->productAndServiceData = $productAndServiceData;
        return $this;
    }
    /**
     * Get parcels value
     * @return \Dpd\StructType\Parcels[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderParcelsItem) {
            // validation for constraint: itemType
            if (!$orderParcelsItem instanceof \Dpd\StructType\Parcels) {
                $invalidValues[] = is_object($orderParcelsItem) ? get_class($orderParcelsItem) : sprintf('%s(%s)', gettype($orderParcelsItem), var_export($orderParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \Dpd\StructType\Parcels, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Parcels[] $parcels
     * @return \Dpd\StructType\Order
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Parcels $item
     * @return \Dpd\StructType\Order
     */
    public function addToParcels(\Dpd\StructType\Parcels $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\Parcels) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \Dpd\StructType\Parcels, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
}
