<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authentication StructType
 * Meta information extracted from the WSDL
 * - type: s1:authentication
 * @subpackage Structs
 */
class Authentication extends AbstractStructBase
{
    /**
     * The delisId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $delisId;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $authToken;
    /**
     * The messageLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $messageLanguage;
    /**
     * Constructor method for authentication
     * @uses Authentication::setDelisId()
     * @uses Authentication::setAuthToken()
     * @uses Authentication::setMessageLanguage()
     * @param string $delisId
     * @param string $authToken
     * @param string $messageLanguage
     */
    public function __construct($delisId = null, $authToken = null, $messageLanguage = null)
    {
        $this
            ->setDelisId($delisId)
            ->setAuthToken($authToken)
            ->setMessageLanguage($messageLanguage);
    }
    /**
     * Get delisId value
     * @return string
     */
    public function getDelisId()
    {
        return $this->delisId;
    }
    /**
     * Set delisId value
     * @param string $delisId
     * @return \Dpd\StructType\Authentication
     */
    public function setDelisId($delisId = null)
    {
        // validation for constraint: string
        if (!is_null($delisId) && !is_string($delisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delisId, true), gettype($delisId)), __LINE__);
        }
        $this->delisId = $delisId;
        return $this;
    }
    /**
     * Get authToken value
     * @return string
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \Dpd\StructType\Authentication
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get messageLanguage value
     * @return string
     */
    public function getMessageLanguage()
    {
        return $this->messageLanguage;
    }
    /**
     * Set messageLanguage value
     * @param string $messageLanguage
     * @return \Dpd\StructType\Authentication
     */
    public function setMessageLanguage($messageLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($messageLanguage) && !is_string($messageLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageLanguage, true), gettype($messageLanguage)), __LINE__);
        }
        $this->messageLanguage = $messageLanguage;
        return $this;
    }
}
