<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for storeOrdersResponseType StructType
 * @subpackage Structs
 */
class StoreOrdersResponseType extends AbstractStructBase
{
    /**
     * The parcellabelsPDF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcellabelsPDF;
    /**
     * The shipmentResponses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Dpd\StructType\ShipmentResponses[]
     */
    public $shipmentResponses;
    /**
     * Constructor method for storeOrdersResponseType
     * @uses StoreOrdersResponseType::setParcellabelsPDF()
     * @uses StoreOrdersResponseType::setShipmentResponses()
     * @param string $parcellabelsPDF
     * @param \Dpd\StructType\ShipmentResponses[] $shipmentResponses
     */
    public function __construct($parcellabelsPDF = null, array $shipmentResponses = array())
    {
        $this
            ->setParcellabelsPDF($parcellabelsPDF)
            ->setShipmentResponses($shipmentResponses);
    }
    /**
     * Get parcellabelsPDF value
     * @return string|null
     */
    public function getParcellabelsPDF()
    {
        return $this->parcellabelsPDF;
    }
    /**
     * Set parcellabelsPDF value
     * @param string $parcellabelsPDF
     * @return \Dpd\StructType\StoreOrdersResponseType
     */
    public function setParcellabelsPDF($parcellabelsPDF = null)
    {
        // validation for constraint: string
        if (!is_null($parcellabelsPDF) && !is_string($parcellabelsPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcellabelsPDF, true), gettype($parcellabelsPDF)), __LINE__);
        }
        $this->parcellabelsPDF = $parcellabelsPDF;
        return $this;
    }
    /**
     * Get shipmentResponses value
     * @return \Dpd\StructType\ShipmentResponses[]|null
     */
    public function getShipmentResponses()
    {
        return $this->shipmentResponses;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentResponses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentResponses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentResponsesForArrayConstraintsFromSetShipmentResponses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $storeOrdersResponseTypeShipmentResponsesItem) {
            // validation for constraint: itemType
            if (!$storeOrdersResponseTypeShipmentResponsesItem instanceof \Dpd\StructType\ShipmentResponses) {
                $invalidValues[] = is_object($storeOrdersResponseTypeShipmentResponsesItem) ? get_class($storeOrdersResponseTypeShipmentResponsesItem) : sprintf('%s(%s)', gettype($storeOrdersResponseTypeShipmentResponsesItem), var_export($storeOrdersResponseTypeShipmentResponsesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentResponses property can only contain items of type \Dpd\StructType\ShipmentResponses, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentResponses value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ShipmentResponses[] $shipmentResponses
     * @return \Dpd\StructType\StoreOrdersResponseType
     */
    public function setShipmentResponses(array $shipmentResponses = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentResponsesArrayErrorMessage = self::validateShipmentResponsesForArrayConstraintsFromSetShipmentResponses($shipmentResponses))) {
            throw new \InvalidArgumentException($shipmentResponsesArrayErrorMessage, __LINE__);
        }
        $this->shipmentResponses = $shipmentResponses;
        return $this;
    }
    /**
     * Add item to shipmentResponses value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ShipmentResponses $item
     * @return \Dpd\StructType\StoreOrdersResponseType
     */
    public function addToShipmentResponses(\Dpd\StructType\ShipmentResponses $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\ShipmentResponses) {
            throw new \InvalidArgumentException(sprintf('The shipmentResponses property can only contain items of type \Dpd\StructType\ShipmentResponses, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipmentResponses[] = $item;
        return $this;
    }
}
