<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentResponses StructType
 * @subpackage Structs
 */
class ShipmentResponses extends AbstractStructBase
{
    /**
     * The identificationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identificationNumber;
    /**
     * The mpsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mpsId;
    /**
     * The parcelInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Dpd\StructType\ParcelInformation[]
     */
    public $parcelInformation;
    /**
     * The faults
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Dpd\StructType\Faults[]
     */
    public $faults;
    /**
     * Constructor method for shipmentResponses
     * @uses ShipmentResponses::setIdentificationNumber()
     * @uses ShipmentResponses::setMpsId()
     * @uses ShipmentResponses::setParcelInformation()
     * @uses ShipmentResponses::setFaults()
     * @param string $identificationNumber
     * @param string $mpsId
     * @param \Dpd\StructType\ParcelInformation[] $parcelInformation
     * @param \Dpd\StructType\Faults[] $faults
     */
    public function __construct($identificationNumber = null, $mpsId = null, array $parcelInformation = array(), array $faults = array())
    {
        $this
            ->setIdentificationNumber($identificationNumber)
            ->setMpsId($mpsId)
            ->setParcelInformation($parcelInformation)
            ->setFaults($faults);
    }
    /**
     * Get identificationNumber value
     * @return string|null
     */
    public function getIdentificationNumber()
    {
        return $this->identificationNumber;
    }
    /**
     * Set identificationNumber value
     * @param string $identificationNumber
     * @return \Dpd\StructType\ShipmentResponses
     */
    public function setIdentificationNumber($identificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNumber) && !is_string($identificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNumber, true), gettype($identificationNumber)), __LINE__);
        }
        $this->identificationNumber = $identificationNumber;
        return $this;
    }
    /**
     * Get mpsId value
     * @return string|null
     */
    public function getMpsId()
    {
        return $this->mpsId;
    }
    /**
     * Set mpsId value
     * @param string $mpsId
     * @return \Dpd\StructType\ShipmentResponses
     */
    public function setMpsId($mpsId = null)
    {
        // validation for constraint: string
        if (!is_null($mpsId) && !is_string($mpsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mpsId, true), gettype($mpsId)), __LINE__);
        }
        $this->mpsId = $mpsId;
        return $this;
    }
    /**
     * Get parcelInformation value
     * @return \Dpd\StructType\ParcelInformation[]|null
     */
    public function getParcelInformation()
    {
        return $this->parcelInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelInformationForArrayConstraintsFromSetParcelInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResponsesParcelInformationItem) {
            // validation for constraint: itemType
            if (!$shipmentResponsesParcelInformationItem instanceof \Dpd\StructType\ParcelInformation) {
                $invalidValues[] = is_object($shipmentResponsesParcelInformationItem) ? get_class($shipmentResponsesParcelInformationItem) : sprintf('%s(%s)', gettype($shipmentResponsesParcelInformationItem), var_export($shipmentResponsesParcelInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcelInformation property can only contain items of type \Dpd\StructType\ParcelInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcelInformation value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ParcelInformation[] $parcelInformation
     * @return \Dpd\StructType\ShipmentResponses
     */
    public function setParcelInformation(array $parcelInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelInformationArrayErrorMessage = self::validateParcelInformationForArrayConstraintsFromSetParcelInformation($parcelInformation))) {
            throw new \InvalidArgumentException($parcelInformationArrayErrorMessage, __LINE__);
        }
        $this->parcelInformation = $parcelInformation;
        return $this;
    }
    /**
     * Add item to parcelInformation value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ParcelInformation $item
     * @return \Dpd\StructType\ShipmentResponses
     */
    public function addToParcelInformation(\Dpd\StructType\ParcelInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\ParcelInformation) {
            throw new \InvalidArgumentException(sprintf('The parcelInformation property can only contain items of type \Dpd\StructType\ParcelInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcelInformation[] = $item;
        return $this;
    }
    /**
     * Get faults value
     * @return \Dpd\StructType\Faults[]|null
     */
    public function getFaults()
    {
        return $this->faults;
    }
    /**
     * This method is responsible for validating the values passed to the setFaults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFaults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFaultsForArrayConstraintsFromSetFaults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentResponsesFaultsItem) {
            // validation for constraint: itemType
            if (!$shipmentResponsesFaultsItem instanceof \Dpd\StructType\Faults) {
                $invalidValues[] = is_object($shipmentResponsesFaultsItem) ? get_class($shipmentResponsesFaultsItem) : sprintf('%s(%s)', gettype($shipmentResponsesFaultsItem), var_export($shipmentResponsesFaultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The faults property can only contain items of type \Dpd\StructType\Faults, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set faults value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Faults[] $faults
     * @return \Dpd\StructType\ShipmentResponses
     */
    public function setFaults(array $faults = array())
    {
        // validation for constraint: array
        if ('' !== ($faultsArrayErrorMessage = self::validateFaultsForArrayConstraintsFromSetFaults($faults))) {
            throw new \InvalidArgumentException($faultsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($faults) && count($faults) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($faults)), __LINE__);
        }
        $this->faults = $faults;
        return $this;
    }
    /**
     * Add item to faults value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\Faults $item
     * @return \Dpd\StructType\ShipmentResponses
     */
    public function addToFaults(\Dpd\StructType\Faults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\Faults) {
            throw new \InvalidArgumentException(sprintf('The faults property can only contain items of type \Dpd\StructType\Faults, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->faults) && count($this->faults) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->faults)), __LINE__);
        }
        $this->faults[] = $item;
        return $this;
    }
}
