<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productAndServiceData StructType
 * @subpackage Structs
 */
class ProductAndServiceData extends AbstractStructBase
{
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $orderType;
    /**
     * The saturdayDelivery
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $saturdayDelivery;
    /**
     * The exWorksDelivery
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $exWorksDelivery;
    /**
     * The guarantee
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $guarantee;
    /**
     * The tyres
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $tyres;
    /**
     * The personalDelivery
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\PersonalDelivery
     */
    public $personalDelivery;
    /**
     * The pickup
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Pickup
     */
    public $pickup;
    /**
     * The parcelShopDelivery
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\ParcelShopDelivery
     */
    public $parcelShopDelivery;
    /**
     * The predict
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Notification
     */
    public $predict;
    /**
     * The personalDeliveryNotification
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Notification
     */
    public $personalDeliveryNotification;
    /**
     * The proactiveNotification
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Dpd\StructType\ProactiveNotification[]
     */
    public $proactiveNotification;
    /**
     * The delivery
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Delivery
     */
    public $delivery;
    /**
     * The invoiceAddress
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Address
     */
    public $invoiceAddress;
    /**
     * The countrySpecificService
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countrySpecificService;
    /**
     * Constructor method for productAndServiceData
     * @uses ProductAndServiceData::setOrderType()
     * @uses ProductAndServiceData::setSaturdayDelivery()
     * @uses ProductAndServiceData::setExWorksDelivery()
     * @uses ProductAndServiceData::setGuarantee()
     * @uses ProductAndServiceData::setTyres()
     * @uses ProductAndServiceData::setPersonalDelivery()
     * @uses ProductAndServiceData::setPickup()
     * @uses ProductAndServiceData::setParcelShopDelivery()
     * @uses ProductAndServiceData::setPredict()
     * @uses ProductAndServiceData::setPersonalDeliveryNotification()
     * @uses ProductAndServiceData::setProactiveNotification()
     * @uses ProductAndServiceData::setDelivery()
     * @uses ProductAndServiceData::setInvoiceAddress()
     * @uses ProductAndServiceData::setCountrySpecificService()
     * @param string $orderType
     * @param bool $saturdayDelivery
     * @param bool $exWorksDelivery
     * @param bool $guarantee
     * @param bool $tyres
     * @param \Dpd\StructType\PersonalDelivery $personalDelivery
     * @param \Dpd\StructType\Pickup $pickup
     * @param \Dpd\StructType\ParcelShopDelivery $parcelShopDelivery
     * @param \Dpd\StructType\Notification $predict
     * @param \Dpd\StructType\Notification $personalDeliveryNotification
     * @param \Dpd\StructType\ProactiveNotification[] $proactiveNotification
     * @param \Dpd\StructType\Delivery $delivery
     * @param \Dpd\StructType\Address $invoiceAddress
     * @param string $countrySpecificService
     */
    public function __construct($orderType = null, $saturdayDelivery = null, $exWorksDelivery = null, $guarantee = null, $tyres = null, \Dpd\StructType\PersonalDelivery $personalDelivery = null, \Dpd\StructType\Pickup $pickup = null, \Dpd\StructType\ParcelShopDelivery $parcelShopDelivery = null, \Dpd\StructType\Notification $predict = null, \Dpd\StructType\Notification $personalDeliveryNotification = null, array $proactiveNotification = array(), \Dpd\StructType\Delivery $delivery = null, \Dpd\StructType\Address $invoiceAddress = null, $countrySpecificService = null)
    {
        $this
            ->setOrderType($orderType)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setExWorksDelivery($exWorksDelivery)
            ->setGuarantee($guarantee)
            ->setTyres($tyres)
            ->setPersonalDelivery($personalDelivery)
            ->setPickup($pickup)
            ->setParcelShopDelivery($parcelShopDelivery)
            ->setPredict($predict)
            ->setPersonalDeliveryNotification($personalDeliveryNotification)
            ->setProactiveNotification($proactiveNotification)
            ->setDelivery($delivery)
            ->setInvoiceAddress($invoiceAddress)
            ->setCountrySpecificService($countrySpecificService);
    }
    /**
     * Get orderType value
     * @return string
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @param string $orderType
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get saturdayDelivery value
     * @return bool|null
     */
    public function getSaturdayDelivery()
    {
        return $this->saturdayDelivery;
    }
    /**
     * Set saturdayDelivery value
     * @param bool $saturdayDelivery
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setSaturdayDelivery($saturdayDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturdayDelivery) && !is_bool($saturdayDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($saturdayDelivery, true), gettype($saturdayDelivery)), __LINE__);
        }
        $this->saturdayDelivery = $saturdayDelivery;
        return $this;
    }
    /**
     * Get exWorksDelivery value
     * @return bool|null
     */
    public function getExWorksDelivery()
    {
        return $this->exWorksDelivery;
    }
    /**
     * Set exWorksDelivery value
     * @param bool $exWorksDelivery
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setExWorksDelivery($exWorksDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($exWorksDelivery) && !is_bool($exWorksDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exWorksDelivery, true), gettype($exWorksDelivery)), __LINE__);
        }
        $this->exWorksDelivery = $exWorksDelivery;
        return $this;
    }
    /**
     * Get guarantee value
     * @return bool|null
     */
    public function getGuarantee()
    {
        return $this->guarantee;
    }
    /**
     * Set guarantee value
     * @param bool $guarantee
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setGuarantee($guarantee = null)
    {
        // validation for constraint: boolean
        if (!is_null($guarantee) && !is_bool($guarantee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guarantee, true), gettype($guarantee)), __LINE__);
        }
        $this->guarantee = $guarantee;
        return $this;
    }
    /**
     * Get tyres value
     * @return bool|null
     */
    public function getTyres()
    {
        return $this->tyres;
    }
    /**
     * Set tyres value
     * @param bool $tyres
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setTyres($tyres = null)
    {
        // validation for constraint: boolean
        if (!is_null($tyres) && !is_bool($tyres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tyres, true), gettype($tyres)), __LINE__);
        }
        $this->tyres = $tyres;
        return $this;
    }
    /**
     * Get personalDelivery value
     * @return \Dpd\StructType\PersonalDelivery|null
     */
    public function getPersonalDelivery()
    {
        return $this->personalDelivery;
    }
    /**
     * Set personalDelivery value
     * @param \Dpd\StructType\PersonalDelivery $personalDelivery
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setPersonalDelivery(\Dpd\StructType\PersonalDelivery $personalDelivery = null)
    {
        $this->personalDelivery = $personalDelivery;
        return $this;
    }
    /**
     * Get pickup value
     * @return \Dpd\StructType\Pickup|null
     */
    public function getPickup()
    {
        return $this->pickup;
    }
    /**
     * Set pickup value
     * @param \Dpd\StructType\Pickup $pickup
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setPickup(\Dpd\StructType\Pickup $pickup = null)
    {
        $this->pickup = $pickup;
        return $this;
    }
    /**
     * Get parcelShopDelivery value
     * @return \Dpd\StructType\ParcelShopDelivery|null
     */
    public function getParcelShopDelivery()
    {
        return $this->parcelShopDelivery;
    }
    /**
     * Set parcelShopDelivery value
     * @param \Dpd\StructType\ParcelShopDelivery $parcelShopDelivery
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setParcelShopDelivery(\Dpd\StructType\ParcelShopDelivery $parcelShopDelivery = null)
    {
        $this->parcelShopDelivery = $parcelShopDelivery;
        return $this;
    }
    /**
     * Get predict value
     * @return \Dpd\StructType\Notification|null
     */
    public function getPredict()
    {
        return $this->predict;
    }
    /**
     * Set predict value
     * @param \Dpd\StructType\Notification $predict
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setPredict(\Dpd\StructType\Notification $predict = null)
    {
        $this->predict = $predict;
        return $this;
    }
    /**
     * Get personalDeliveryNotification value
     * @return \Dpd\StructType\Notification|null
     */
    public function getPersonalDeliveryNotification()
    {
        return $this->personalDeliveryNotification;
    }
    /**
     * Set personalDeliveryNotification value
     * @param \Dpd\StructType\Notification $personalDeliveryNotification
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setPersonalDeliveryNotification(\Dpd\StructType\Notification $personalDeliveryNotification = null)
    {
        $this->personalDeliveryNotification = $personalDeliveryNotification;
        return $this;
    }
    /**
     * Get proactiveNotification value
     * @return \Dpd\StructType\ProactiveNotification[]|null
     */
    public function getProactiveNotification()
    {
        return $this->proactiveNotification;
    }
    /**
     * This method is responsible for validating the values passed to the setProactiveNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProactiveNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProactiveNotificationForArrayConstraintsFromSetProactiveNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productAndServiceDataProactiveNotificationItem) {
            // validation for constraint: itemType
            if (!$productAndServiceDataProactiveNotificationItem instanceof \Dpd\StructType\ProactiveNotification) {
                $invalidValues[] = is_object($productAndServiceDataProactiveNotificationItem) ? get_class($productAndServiceDataProactiveNotificationItem) : sprintf('%s(%s)', gettype($productAndServiceDataProactiveNotificationItem), var_export($productAndServiceDataProactiveNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The proactiveNotification property can only contain items of type \Dpd\StructType\ProactiveNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set proactiveNotification value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ProactiveNotification[] $proactiveNotification
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setProactiveNotification(array $proactiveNotification = array())
    {
        // validation for constraint: array
        if ('' !== ($proactiveNotificationArrayErrorMessage = self::validateProactiveNotificationForArrayConstraintsFromSetProactiveNotification($proactiveNotification))) {
            throw new \InvalidArgumentException($proactiveNotificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($proactiveNotification) && count($proactiveNotification) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($proactiveNotification)), __LINE__);
        }
        $this->proactiveNotification = $proactiveNotification;
        return $this;
    }
    /**
     * Add item to proactiveNotification value
     * @throws \InvalidArgumentException
     * @param \Dpd\StructType\ProactiveNotification $item
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function addToProactiveNotification(\Dpd\StructType\ProactiveNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Dpd\StructType\ProactiveNotification) {
            throw new \InvalidArgumentException(sprintf('The proactiveNotification property can only contain items of type \Dpd\StructType\ProactiveNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->proactiveNotification) && count($this->proactiveNotification) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->proactiveNotification)), __LINE__);
        }
        $this->proactiveNotification[] = $item;
        return $this;
    }
    /**
     * Get delivery value
     * @return \Dpd\StructType\Delivery|null
     */
    public function getDelivery()
    {
        return $this->delivery;
    }
    /**
     * Set delivery value
     * @param \Dpd\StructType\Delivery $delivery
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setDelivery(\Dpd\StructType\Delivery $delivery = null)
    {
        $this->delivery = $delivery;
        return $this;
    }
    /**
     * Get invoiceAddress value
     * @return \Dpd\StructType\Address|null
     */
    public function getInvoiceAddress()
    {
        return $this->invoiceAddress;
    }
    /**
     * Set invoiceAddress value
     * @param \Dpd\StructType\Address $invoiceAddress
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setInvoiceAddress(\Dpd\StructType\Address $invoiceAddress = null)
    {
        $this->invoiceAddress = $invoiceAddress;
        return $this;
    }
    /**
     * Get countrySpecificService value
     * @return string|null
     */
    public function getCountrySpecificService()
    {
        return $this->countrySpecificService;
    }
    /**
     * Set countrySpecificService value
     * @param string $countrySpecificService
     * @return \Dpd\StructType\ProductAndServiceData
     */
    public function setCountrySpecificService($countrySpecificService = null)
    {
        // validation for constraint: string
        if (!is_null($countrySpecificService) && !is_string($countrySpecificService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrySpecificService, true), gettype($countrySpecificService)), __LINE__);
        }
        $this->countrySpecificService = $countrySpecificService;
        return $this;
    }
}
