<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickup StructType
 * @subpackage Structs
 */
class Pickup extends AbstractStructBase
{
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $date;
    /**
     * The day
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $day;
    /**
     * The tour
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $tour;
    /**
     * The fromTime1
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $fromTime1;
    /**
     * The toTime1
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $toTime1;
    /**
     * The fromTime2
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $fromTime2;
    /**
     * The toTime2
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $toTime2;
    /**
     * The extraPickup
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $extraPickup;
    /**
     * The collectionRequestAddress
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Dpd\StructType\Address
     */
    public $collectionRequestAddress;
    /**
     * Constructor method for pickup
     * @uses Pickup::setQuantity()
     * @uses Pickup::setDate()
     * @uses Pickup::setDay()
     * @uses Pickup::setTour()
     * @uses Pickup::setFromTime1()
     * @uses Pickup::setToTime1()
     * @uses Pickup::setFromTime2()
     * @uses Pickup::setToTime2()
     * @uses Pickup::setExtraPickup()
     * @uses Pickup::setCollectionRequestAddress()
     * @param int $quantity
     * @param int $date
     * @param int $day
     * @param int $tour
     * @param int $fromTime1
     * @param int $toTime1
     * @param int $fromTime2
     * @param int $toTime2
     * @param bool $extraPickup
     * @param \Dpd\StructType\Address $collectionRequestAddress
     */
    public function __construct($quantity = null, $date = null, $day = null, $tour = null, $fromTime1 = null, $toTime1 = null, $fromTime2 = null, $toTime2 = null, $extraPickup = null, \Dpd\StructType\Address $collectionRequestAddress = null)
    {
        $this
            ->setQuantity($quantity)
            ->setDate($date)
            ->setDay($day)
            ->setTour($tour)
            ->setFromTime1($fromTime1)
            ->setToTime1($toTime1)
            ->setFromTime2($fromTime2)
            ->setToTime2($toTime2)
            ->setExtraPickup($extraPickup)
            ->setCollectionRequestAddress($collectionRequestAddress);
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \Dpd\StructType\Pickup
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get date value
     * @return int
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param int $date
     * @return \Dpd\StructType\Pickup
     */
    public function setDate($date = null)
    {
        // validation for constraint: int
        if (!is_null($date) && !(is_int($date) || ctype_digit($date))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get day value
     * @return int
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \Dpd\StructType\Pickup
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get tour value
     * @return int|null
     */
    public function getTour()
    {
        return $this->tour;
    }
    /**
     * Set tour value
     * @param int $tour
     * @return \Dpd\StructType\Pickup
     */
    public function setTour($tour = null)
    {
        // validation for constraint: int
        if (!is_null($tour) && !(is_int($tour) || ctype_digit($tour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tour, true), gettype($tour)), __LINE__);
        }
        $this->tour = $tour;
        return $this;
    }
    /**
     * Get fromTime1 value
     * @return int|null
     */
    public function getFromTime1()
    {
        return $this->fromTime1;
    }
    /**
     * Set fromTime1 value
     * @param int $fromTime1
     * @return \Dpd\StructType\Pickup
     */
    public function setFromTime1($fromTime1 = null)
    {
        // validation for constraint: int
        if (!is_null($fromTime1) && !(is_int($fromTime1) || ctype_digit($fromTime1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTime1, true), gettype($fromTime1)), __LINE__);
        }
        $this->fromTime1 = $fromTime1;
        return $this;
    }
    /**
     * Get toTime1 value
     * @return int|null
     */
    public function getToTime1()
    {
        return $this->toTime1;
    }
    /**
     * Set toTime1 value
     * @param int $toTime1
     * @return \Dpd\StructType\Pickup
     */
    public function setToTime1($toTime1 = null)
    {
        // validation for constraint: int
        if (!is_null($toTime1) && !(is_int($toTime1) || ctype_digit($toTime1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toTime1, true), gettype($toTime1)), __LINE__);
        }
        $this->toTime1 = $toTime1;
        return $this;
    }
    /**
     * Get fromTime2 value
     * @return int|null
     */
    public function getFromTime2()
    {
        return $this->fromTime2;
    }
    /**
     * Set fromTime2 value
     * @param int $fromTime2
     * @return \Dpd\StructType\Pickup
     */
    public function setFromTime2($fromTime2 = null)
    {
        // validation for constraint: int
        if (!is_null($fromTime2) && !(is_int($fromTime2) || ctype_digit($fromTime2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTime2, true), gettype($fromTime2)), __LINE__);
        }
        $this->fromTime2 = $fromTime2;
        return $this;
    }
    /**
     * Get toTime2 value
     * @return int|null
     */
    public function getToTime2()
    {
        return $this->toTime2;
    }
    /**
     * Set toTime2 value
     * @param int $toTime2
     * @return \Dpd\StructType\Pickup
     */
    public function setToTime2($toTime2 = null)
    {
        // validation for constraint: int
        if (!is_null($toTime2) && !(is_int($toTime2) || ctype_digit($toTime2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toTime2, true), gettype($toTime2)), __LINE__);
        }
        $this->toTime2 = $toTime2;
        return $this;
    }
    /**
     * Get extraPickup value
     * @return bool|null
     */
    public function getExtraPickup()
    {
        return $this->extraPickup;
    }
    /**
     * Set extraPickup value
     * @param bool $extraPickup
     * @return \Dpd\StructType\Pickup
     */
    public function setExtraPickup($extraPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraPickup) && !is_bool($extraPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extraPickup, true), gettype($extraPickup)), __LINE__);
        }
        $this->extraPickup = $extraPickup;
        return $this;
    }
    /**
     * Get collectionRequestAddress value
     * @return \Dpd\StructType\Address|null
     */
    public function getCollectionRequestAddress()
    {
        return $this->collectionRequestAddress;
    }
    /**
     * Set collectionRequestAddress value
     * @param \Dpd\StructType\Address $collectionRequestAddress
     * @return \Dpd\StructType\Pickup
     */
    public function setCollectionRequestAddress(\Dpd\StructType\Address $collectionRequestAddress = null)
    {
        $this->collectionRequestAddress = $collectionRequestAddress;
        return $this;
    }
}
