<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelShopDelivery StructType
 * @subpackage Structs
 */
class ParcelShopDelivery extends AbstractStructBase
{
    /**
     * The parcelShopId
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $parcelShopId;
    /**
     * The parcelShopNotification
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Dpd\StructType\Notification
     */
    public $parcelShopNotification;
    /**
     * Constructor method for parcelShopDelivery
     * @uses ParcelShopDelivery::setParcelShopId()
     * @uses ParcelShopDelivery::setParcelShopNotification()
     * @param int $parcelShopId
     * @param \Dpd\StructType\Notification $parcelShopNotification
     */
    public function __construct($parcelShopId = null, \Dpd\StructType\Notification $parcelShopNotification = null)
    {
        $this
            ->setParcelShopId($parcelShopId)
            ->setParcelShopNotification($parcelShopNotification);
    }
    /**
     * Get parcelShopId value
     * @return int
     */
    public function getParcelShopId()
    {
        return $this->parcelShopId;
    }
    /**
     * Set parcelShopId value
     * @param int $parcelShopId
     * @return \Dpd\StructType\ParcelShopDelivery
     */
    public function setParcelShopId($parcelShopId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelShopId) && !(is_int($parcelShopId) || ctype_digit($parcelShopId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelShopId, true), gettype($parcelShopId)), __LINE__);
        }
        $this->parcelShopId = $parcelShopId;
        return $this;
    }
    /**
     * Get parcelShopNotification value
     * @return \Dpd\StructType\Notification
     */
    public function getParcelShopNotification()
    {
        return $this->parcelShopNotification;
    }
    /**
     * Set parcelShopNotification value
     * @param \Dpd\StructType\Notification $parcelShopNotification
     * @return \Dpd\StructType\ParcelShopDelivery
     */
    public function setParcelShopNotification(\Dpd\StructType\Notification $parcelShopNotification = null)
    {
        $this->parcelShopNotification = $parcelShopNotification;
        return $this;
    }
}
