<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $channel;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $value;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * Constructor method for notification
     * @uses Notification::setChannel()
     * @uses Notification::setValue()
     * @uses Notification::setLanguage()
     * @param int $channel
     * @param string $value
     * @param string $language
     */
    public function __construct($channel = null, $value = null, $language = null)
    {
        $this
            ->setChannel($channel)
            ->setValue($value)
            ->setLanguage($language);
    }
    /**
     * Get channel value
     * @return int
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @param int $channel
     * @return \Dpd\StructType\Notification
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: int
        if (!is_null($channel) && !(is_int($channel) || ctype_digit($channel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Get value value
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \Dpd\StructType\Notification
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \Dpd\StructType\Notification
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
}
