<?php

namespace Dpd\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for faults StructType
 * Meta information extracted from the WSDL
 * - type: tns:faults
 * @subpackage Structs
 */
class Faults extends AbstractStructBase
{
    /**
     * The faultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $faultCode;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $message;
    /**
     * Constructor method for faults
     * @uses Faults::setFaultCode()
     * @uses Faults::setMessage()
     * @param string $faultCode
     * @param string $message
     */
    public function __construct($faultCode = null, $message = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setMessage($message);
    }
    /**
     * Get faultCode value
     * @return string
     */
    public function getFaultCode()
    {
        return $this->faultCode;
    }
    /**
     * Set faultCode value
     * @param string $faultCode
     * @return \Dpd\StructType\Faults
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        $this->faultCode = $faultCode;
        return $this;
    }
    /**
     * Get message value
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \Dpd\StructType\Faults
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
