<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for WSIC ServiceType
 * @subpackage Services
 */
class WSIC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WSI2_CreationExpedition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WSI2_CreationExpedition $parameters
     * @return \StructType\WSI2_CreationExpeditionResponse|bool
     */
    public function WSI2_CreationExpedition(\StructType\WSI2_CreationExpedition $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WSI2_CreationExpedition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WSI2_CreationEtiquette
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WSI2_CreationEtiquette $parameters
     * @return \StructType\WSI2_CreationEtiquetteResponse|bool
     */
    public function WSI2_CreationEtiquette(\StructType\WSI2_CreationEtiquette $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WSI2_CreationEtiquette($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WSI2_CreationEtiquetteResponse|\StructType\WSI2_CreationExpeditionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
