<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessXML
     * Meta information extracted from the WSDL
     * - documentation: Process incoming XML. Updated version 11/2006.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessXML $parameters
     * @return \StructType\ProcessXMLResponse|bool
     */
    public function ProcessXML(\StructType\ProcessXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
