<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRateDetailItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfRateDetailItem extends AbstractStructArrayBase
{
    /**
     * The RateDetailItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RateDetailItem[]
     */
    public $RateDetailItem;
    /**
     * Constructor method for ArrayOfRateDetailItem
     * @uses ArrayOfRateDetailItem::setRateDetailItem()
     * @param \StructType\RateDetailItem[] $rateDetailItem
     */
    public function __construct(array $rateDetailItem = array())
    {
        $this
            ->setRateDetailItem($rateDetailItem);
    }
    /**
     * Get RateDetailItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RateDetailItem[]|null
     */
    public function getRateDetailItem()
    {
        return isset($this->RateDetailItem) ? $this->RateDetailItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRateDetailItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateDetailItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateDetailItemForArrayConstraintsFromSetRateDetailItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRateDetailItemRateDetailItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfRateDetailItemRateDetailItemItem instanceof \StructType\RateDetailItem) {
                $invalidValues[] = is_object($arrayOfRateDetailItemRateDetailItemItem) ? get_class($arrayOfRateDetailItemRateDetailItemItem) : sprintf('%s(%s)', gettype($arrayOfRateDetailItemRateDetailItemItem), var_export($arrayOfRateDetailItemRateDetailItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateDetailItem property can only contain items of type \StructType\RateDetailItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateDetailItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RateDetailItem[] $rateDetailItem
     * @return \ArrayType\ArrayOfRateDetailItem
     */
    public function setRateDetailItem(array $rateDetailItem = array())
    {
        // validation for constraint: array
        if ('' !== ($rateDetailItemArrayErrorMessage = self::validateRateDetailItemForArrayConstraintsFromSetRateDetailItem($rateDetailItem))) {
            throw new \InvalidArgumentException($rateDetailItemArrayErrorMessage, __LINE__);
        }
        if (is_null($rateDetailItem) || (is_array($rateDetailItem) && empty($rateDetailItem))) {
            unset($this->RateDetailItem);
        } else {
            $this->RateDetailItem = $rateDetailItem;
        }
        return $this;
    }
    /**
     * Add item to RateDetailItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RateDetailItem $item
     * @return \ArrayType\ArrayOfRateDetailItem
     */
    public function addToRateDetailItem(\StructType\RateDetailItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateDetailItem) {
            throw new \InvalidArgumentException(sprintf('The RateDetailItem property can only contain items of type \StructType\RateDetailItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RateDetailItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RateDetailItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RateDetailItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RateDetailItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RateDetailItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RateDetailItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RateDetailItem
     */
    public function getAttributeName()
    {
        return 'RateDetailItem';
    }
}
