<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The QuoteNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QuoteNumber;
    /**
     * The TotalInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalInvoice;
    /**
     * The GuaranteeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GuaranteeAmount;
    /**
     * The GuaranteeAmount2pm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GuaranteeAmount2pm;
    /**
     * The GuaranteeAmount12pm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GuaranteeAmount12pm;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DiscountPercent;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DiscountAmount;
    /**
     * The ActualWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualWeight;
    /**
     * The RatedWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RatedWeight;
    /**
     * The StandardServiceDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StandardServiceDays;
    /**
     * The FuelSurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelSurchargePercent;
    /**
     * The FuelSurchargeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FuelSurchargeAmount;
    /**
     * The DeficitWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeficitWeight;
    /**
     * The DeficitRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeficitRate;
    /**
     * The DeficitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeficitAmount;
    /**
     * The FullValueCoverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FullValueCoverage;
    /**
     * The CODFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CODFee;
    /**
     * The TotalCube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCube;
    /**
     * The OriginTerminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TerminalItem
     */
    public $OriginTerminal;
    /**
     * The DestinationTerminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TerminalItem
     */
    public $DestinationTerminal;
    /**
     * The RateDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRateDetailItem
     */
    public $RateDetails;
    /**
     * The RateAccessorials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRateAccessorialItem
     */
    public $RateAccessorials;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Element
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Element;
    /**
     * The Fault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fault;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The TestMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestMode;
    /**
     * The Tariff
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tariff;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The EstimatedDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedDeliveryDate;
    /**
     * The DirectPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DirectPoint;
    /**
     * The RateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateType;
    /**
     * The WeightUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WeightUnits;
    /**
     * The TotalCubeUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TotalCubeUnits;
    /**
     * The ExcessiveLengthTotalInches
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExcessiveLengthTotalInches;
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Promotion;
    /**
     * Constructor method for Response
     * @uses Response::setQuoteNumber()
     * @uses Response::setTotalInvoice()
     * @uses Response::setGuaranteeAmount()
     * @uses Response::setGuaranteeAmount2pm()
     * @uses Response::setGuaranteeAmount12pm()
     * @uses Response::setDiscountPercent()
     * @uses Response::setDiscountAmount()
     * @uses Response::setActualWeight()
     * @uses Response::setRatedWeight()
     * @uses Response::setStandardServiceDays()
     * @uses Response::setFuelSurchargePercent()
     * @uses Response::setFuelSurchargeAmount()
     * @uses Response::setDeficitWeight()
     * @uses Response::setDeficitRate()
     * @uses Response::setDeficitAmount()
     * @uses Response::setFullValueCoverage()
     * @uses Response::setCODFee()
     * @uses Response::setTotalCube()
     * @uses Response::setOriginTerminal()
     * @uses Response::setDestinationTerminal()
     * @uses Response::setRateDetails()
     * @uses Response::setRateAccessorials()
     * @uses Response::setCode()
     * @uses Response::setElement()
     * @uses Response::setFault()
     * @uses Response::setMessage()
     * @uses Response::setTestMode()
     * @uses Response::setTariff()
     * @uses Response::setEffectiveDate()
     * @uses Response::setExpirationDate()
     * @uses Response::setEstimatedDeliveryDate()
     * @uses Response::setDirectPoint()
     * @uses Response::setRateType()
     * @uses Response::setWeightUnits()
     * @uses Response::setTotalCubeUnits()
     * @uses Response::setExcessiveLengthTotalInches()
     * @uses Response::setPromotion()
     * @param float $quoteNumber
     * @param float $totalInvoice
     * @param float $guaranteeAmount
     * @param float $guaranteeAmount2pm
     * @param float $guaranteeAmount12pm
     * @param float $discountPercent
     * @param float $discountAmount
     * @param float $actualWeight
     * @param float $ratedWeight
     * @param float $standardServiceDays
     * @param float $fuelSurchargePercent
     * @param float $fuelSurchargeAmount
     * @param float $deficitWeight
     * @param float $deficitRate
     * @param float $deficitAmount
     * @param float $fullValueCoverage
     * @param float $cODFee
     * @param float $totalCube
     * @param \StructType\TerminalItem $originTerminal
     * @param \StructType\TerminalItem $destinationTerminal
     * @param \ArrayType\ArrayOfRateDetailItem $rateDetails
     * @param \ArrayType\ArrayOfRateAccessorialItem $rateAccessorials
     * @param string $code
     * @param string $element
     * @param string $fault
     * @param string $message
     * @param string $testMode
     * @param string $tariff
     * @param string $effectiveDate
     * @param string $expirationDate
     * @param string $estimatedDeliveryDate
     * @param string $directPoint
     * @param string $rateType
     * @param string $weightUnits
     * @param string $totalCubeUnits
     * @param string $excessiveLengthTotalInches
     * @param string $promotion
     */
    public function __construct($quoteNumber = null, $totalInvoice = null, $guaranteeAmount = null, $guaranteeAmount2pm = null, $guaranteeAmount12pm = null, $discountPercent = null, $discountAmount = null, $actualWeight = null, $ratedWeight = null, $standardServiceDays = null, $fuelSurchargePercent = null, $fuelSurchargeAmount = null, $deficitWeight = null, $deficitRate = null, $deficitAmount = null, $fullValueCoverage = null, $cODFee = null, $totalCube = null, \StructType\TerminalItem $originTerminal = null, \StructType\TerminalItem $destinationTerminal = null, \ArrayType\ArrayOfRateDetailItem $rateDetails = null, \ArrayType\ArrayOfRateAccessorialItem $rateAccessorials = null, $code = null, $element = null, $fault = null, $message = null, $testMode = null, $tariff = null, $effectiveDate = null, $expirationDate = null, $estimatedDeliveryDate = null, $directPoint = null, $rateType = null, $weightUnits = null, $totalCubeUnits = null, $excessiveLengthTotalInches = null, $promotion = null)
    {
        $this
            ->setQuoteNumber($quoteNumber)
            ->setTotalInvoice($totalInvoice)
            ->setGuaranteeAmount($guaranteeAmount)
            ->setGuaranteeAmount2pm($guaranteeAmount2pm)
            ->setGuaranteeAmount12pm($guaranteeAmount12pm)
            ->setDiscountPercent($discountPercent)
            ->setDiscountAmount($discountAmount)
            ->setActualWeight($actualWeight)
            ->setRatedWeight($ratedWeight)
            ->setStandardServiceDays($standardServiceDays)
            ->setFuelSurchargePercent($fuelSurchargePercent)
            ->setFuelSurchargeAmount($fuelSurchargeAmount)
            ->setDeficitWeight($deficitWeight)
            ->setDeficitRate($deficitRate)
            ->setDeficitAmount($deficitAmount)
            ->setFullValueCoverage($fullValueCoverage)
            ->setCODFee($cODFee)
            ->setTotalCube($totalCube)
            ->setOriginTerminal($originTerminal)
            ->setDestinationTerminal($destinationTerminal)
            ->setRateDetails($rateDetails)
            ->setRateAccessorials($rateAccessorials)
            ->setCode($code)
            ->setElement($element)
            ->setFault($fault)
            ->setMessage($message)
            ->setTestMode($testMode)
            ->setTariff($tariff)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate)
            ->setEstimatedDeliveryDate($estimatedDeliveryDate)
            ->setDirectPoint($directPoint)
            ->setRateType($rateType)
            ->setWeightUnits($weightUnits)
            ->setTotalCubeUnits($totalCubeUnits)
            ->setExcessiveLengthTotalInches($excessiveLengthTotalInches)
            ->setPromotion($promotion);
    }
    /**
     * Get QuoteNumber value
     * @return float
     */
    public function getQuoteNumber()
    {
        return $this->QuoteNumber;
    }
    /**
     * Set QuoteNumber value
     * @param float $quoteNumber
     * @return \StructType\Response
     */
    public function setQuoteNumber($quoteNumber = null)
    {
        // validation for constraint: float
        if (!is_null($quoteNumber) && !(is_float($quoteNumber) || is_numeric($quoteNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quoteNumber, true), gettype($quoteNumber)), __LINE__);
        }
        $this->QuoteNumber = $quoteNumber;
        return $this;
    }
    /**
     * Get TotalInvoice value
     * @return float
     */
    public function getTotalInvoice()
    {
        return $this->TotalInvoice;
    }
    /**
     * Set TotalInvoice value
     * @param float $totalInvoice
     * @return \StructType\Response
     */
    public function setTotalInvoice($totalInvoice = null)
    {
        // validation for constraint: float
        if (!is_null($totalInvoice) && !(is_float($totalInvoice) || is_numeric($totalInvoice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalInvoice, true), gettype($totalInvoice)), __LINE__);
        }
        $this->TotalInvoice = $totalInvoice;
        return $this;
    }
    /**
     * Get GuaranteeAmount value
     * @return float
     */
    public function getGuaranteeAmount()
    {
        return $this->GuaranteeAmount;
    }
    /**
     * Set GuaranteeAmount value
     * @param float $guaranteeAmount
     * @return \StructType\Response
     */
    public function setGuaranteeAmount($guaranteeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($guaranteeAmount) && !(is_float($guaranteeAmount) || is_numeric($guaranteeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($guaranteeAmount, true), gettype($guaranteeAmount)), __LINE__);
        }
        $this->GuaranteeAmount = $guaranteeAmount;
        return $this;
    }
    /**
     * Get GuaranteeAmount2pm value
     * @return float
     */
    public function getGuaranteeAmount2pm()
    {
        return $this->GuaranteeAmount2pm;
    }
    /**
     * Set GuaranteeAmount2pm value
     * @param float $guaranteeAmount2pm
     * @return \StructType\Response
     */
    public function setGuaranteeAmount2pm($guaranteeAmount2pm = null)
    {
        // validation for constraint: float
        if (!is_null($guaranteeAmount2pm) && !(is_float($guaranteeAmount2pm) || is_numeric($guaranteeAmount2pm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($guaranteeAmount2pm, true), gettype($guaranteeAmount2pm)), __LINE__);
        }
        $this->GuaranteeAmount2pm = $guaranteeAmount2pm;
        return $this;
    }
    /**
     * Get GuaranteeAmount12pm value
     * @return float
     */
    public function getGuaranteeAmount12pm()
    {
        return $this->GuaranteeAmount12pm;
    }
    /**
     * Set GuaranteeAmount12pm value
     * @param float $guaranteeAmount12pm
     * @return \StructType\Response
     */
    public function setGuaranteeAmount12pm($guaranteeAmount12pm = null)
    {
        // validation for constraint: float
        if (!is_null($guaranteeAmount12pm) && !(is_float($guaranteeAmount12pm) || is_numeric($guaranteeAmount12pm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($guaranteeAmount12pm, true), gettype($guaranteeAmount12pm)), __LINE__);
        }
        $this->GuaranteeAmount12pm = $guaranteeAmount12pm;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return float
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param float $discountPercent
     * @return \StructType\Response
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \StructType\Response
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get ActualWeight value
     * @return float
     */
    public function getActualWeight()
    {
        return $this->ActualWeight;
    }
    /**
     * Set ActualWeight value
     * @param float $actualWeight
     * @return \StructType\Response
     */
    public function setActualWeight($actualWeight = null)
    {
        // validation for constraint: float
        if (!is_null($actualWeight) && !(is_float($actualWeight) || is_numeric($actualWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actualWeight, true), gettype($actualWeight)), __LINE__);
        }
        $this->ActualWeight = $actualWeight;
        return $this;
    }
    /**
     * Get RatedWeight value
     * @return float
     */
    public function getRatedWeight()
    {
        return $this->RatedWeight;
    }
    /**
     * Set RatedWeight value
     * @param float $ratedWeight
     * @return \StructType\Response
     */
    public function setRatedWeight($ratedWeight = null)
    {
        // validation for constraint: float
        if (!is_null($ratedWeight) && !(is_float($ratedWeight) || is_numeric($ratedWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ratedWeight, true), gettype($ratedWeight)), __LINE__);
        }
        $this->RatedWeight = $ratedWeight;
        return $this;
    }
    /**
     * Get StandardServiceDays value
     * @return float
     */
    public function getStandardServiceDays()
    {
        return $this->StandardServiceDays;
    }
    /**
     * Set StandardServiceDays value
     * @param float $standardServiceDays
     * @return \StructType\Response
     */
    public function setStandardServiceDays($standardServiceDays = null)
    {
        // validation for constraint: float
        if (!is_null($standardServiceDays) && !(is_float($standardServiceDays) || is_numeric($standardServiceDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standardServiceDays, true), gettype($standardServiceDays)), __LINE__);
        }
        $this->StandardServiceDays = $standardServiceDays;
        return $this;
    }
    /**
     * Get FuelSurchargePercent value
     * @return float
     */
    public function getFuelSurchargePercent()
    {
        return $this->FuelSurchargePercent;
    }
    /**
     * Set FuelSurchargePercent value
     * @param float $fuelSurchargePercent
     * @return \StructType\Response
     */
    public function setFuelSurchargePercent($fuelSurchargePercent = null)
    {
        // validation for constraint: float
        if (!is_null($fuelSurchargePercent) && !(is_float($fuelSurchargePercent) || is_numeric($fuelSurchargePercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelSurchargePercent, true), gettype($fuelSurchargePercent)), __LINE__);
        }
        $this->FuelSurchargePercent = $fuelSurchargePercent;
        return $this;
    }
    /**
     * Get FuelSurchargeAmount value
     * @return float
     */
    public function getFuelSurchargeAmount()
    {
        return $this->FuelSurchargeAmount;
    }
    /**
     * Set FuelSurchargeAmount value
     * @param float $fuelSurchargeAmount
     * @return \StructType\Response
     */
    public function setFuelSurchargeAmount($fuelSurchargeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fuelSurchargeAmount) && !(is_float($fuelSurchargeAmount) || is_numeric($fuelSurchargeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fuelSurchargeAmount, true), gettype($fuelSurchargeAmount)), __LINE__);
        }
        $this->FuelSurchargeAmount = $fuelSurchargeAmount;
        return $this;
    }
    /**
     * Get DeficitWeight value
     * @return float
     */
    public function getDeficitWeight()
    {
        return $this->DeficitWeight;
    }
    /**
     * Set DeficitWeight value
     * @param float $deficitWeight
     * @return \StructType\Response
     */
    public function setDeficitWeight($deficitWeight = null)
    {
        // validation for constraint: float
        if (!is_null($deficitWeight) && !(is_float($deficitWeight) || is_numeric($deficitWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deficitWeight, true), gettype($deficitWeight)), __LINE__);
        }
        $this->DeficitWeight = $deficitWeight;
        return $this;
    }
    /**
     * Get DeficitRate value
     * @return float
     */
    public function getDeficitRate()
    {
        return $this->DeficitRate;
    }
    /**
     * Set DeficitRate value
     * @param float $deficitRate
     * @return \StructType\Response
     */
    public function setDeficitRate($deficitRate = null)
    {
        // validation for constraint: float
        if (!is_null($deficitRate) && !(is_float($deficitRate) || is_numeric($deficitRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deficitRate, true), gettype($deficitRate)), __LINE__);
        }
        $this->DeficitRate = $deficitRate;
        return $this;
    }
    /**
     * Get DeficitAmount value
     * @return float
     */
    public function getDeficitAmount()
    {
        return $this->DeficitAmount;
    }
    /**
     * Set DeficitAmount value
     * @param float $deficitAmount
     * @return \StructType\Response
     */
    public function setDeficitAmount($deficitAmount = null)
    {
        // validation for constraint: float
        if (!is_null($deficitAmount) && !(is_float($deficitAmount) || is_numeric($deficitAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deficitAmount, true), gettype($deficitAmount)), __LINE__);
        }
        $this->DeficitAmount = $deficitAmount;
        return $this;
    }
    /**
     * Get FullValueCoverage value
     * @return float
     */
    public function getFullValueCoverage()
    {
        return $this->FullValueCoverage;
    }
    /**
     * Set FullValueCoverage value
     * @param float $fullValueCoverage
     * @return \StructType\Response
     */
    public function setFullValueCoverage($fullValueCoverage = null)
    {
        // validation for constraint: float
        if (!is_null($fullValueCoverage) && !(is_float($fullValueCoverage) || is_numeric($fullValueCoverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullValueCoverage, true), gettype($fullValueCoverage)), __LINE__);
        }
        $this->FullValueCoverage = $fullValueCoverage;
        return $this;
    }
    /**
     * Get CODFee value
     * @return float
     */
    public function getCODFee()
    {
        return $this->CODFee;
    }
    /**
     * Set CODFee value
     * @param float $cODFee
     * @return \StructType\Response
     */
    public function setCODFee($cODFee = null)
    {
        // validation for constraint: float
        if (!is_null($cODFee) && !(is_float($cODFee) || is_numeric($cODFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cODFee, true), gettype($cODFee)), __LINE__);
        }
        $this->CODFee = $cODFee;
        return $this;
    }
    /**
     * Get TotalCube value
     * @return float
     */
    public function getTotalCube()
    {
        return $this->TotalCube;
    }
    /**
     * Set TotalCube value
     * @param float $totalCube
     * @return \StructType\Response
     */
    public function setTotalCube($totalCube = null)
    {
        // validation for constraint: float
        if (!is_null($totalCube) && !(is_float($totalCube) || is_numeric($totalCube))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCube, true), gettype($totalCube)), __LINE__);
        }
        $this->TotalCube = $totalCube;
        return $this;
    }
    /**
     * Get OriginTerminal value
     * @return \StructType\TerminalItem|null
     */
    public function getOriginTerminal()
    {
        return $this->OriginTerminal;
    }
    /**
     * Set OriginTerminal value
     * @param \StructType\TerminalItem $originTerminal
     * @return \StructType\Response
     */
    public function setOriginTerminal(\StructType\TerminalItem $originTerminal = null)
    {
        $this->OriginTerminal = $originTerminal;
        return $this;
    }
    /**
     * Get DestinationTerminal value
     * @return \StructType\TerminalItem|null
     */
    public function getDestinationTerminal()
    {
        return $this->DestinationTerminal;
    }
    /**
     * Set DestinationTerminal value
     * @param \StructType\TerminalItem $destinationTerminal
     * @return \StructType\Response
     */
    public function setDestinationTerminal(\StructType\TerminalItem $destinationTerminal = null)
    {
        $this->DestinationTerminal = $destinationTerminal;
        return $this;
    }
    /**
     * Get RateDetails value
     * @return \ArrayType\ArrayOfRateDetailItem|null
     */
    public function getRateDetails()
    {
        return $this->RateDetails;
    }
    /**
     * Set RateDetails value
     * @param \ArrayType\ArrayOfRateDetailItem $rateDetails
     * @return \StructType\Response
     */
    public function setRateDetails(\ArrayType\ArrayOfRateDetailItem $rateDetails = null)
    {
        $this->RateDetails = $rateDetails;
        return $this;
    }
    /**
     * Get RateAccessorials value
     * @return \ArrayType\ArrayOfRateAccessorialItem|null
     */
    public function getRateAccessorials()
    {
        return $this->RateAccessorials;
    }
    /**
     * Set RateAccessorials value
     * @param \ArrayType\ArrayOfRateAccessorialItem $rateAccessorials
     * @return \StructType\Response
     */
    public function setRateAccessorials(\ArrayType\ArrayOfRateAccessorialItem $rateAccessorials = null)
    {
        $this->RateAccessorials = $rateAccessorials;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Response
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Element value
     * @return string|null
     */
    public function getElement()
    {
        return $this->Element;
    }
    /**
     * Set Element value
     * @param string $element
     * @return \StructType\Response
     */
    public function setElement($element = null)
    {
        // validation for constraint: string
        if (!is_null($element) && !is_string($element)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($element, true), gettype($element)), __LINE__);
        }
        $this->Element = $element;
        return $this;
    }
    /**
     * Get Fault value
     * @return string|null
     */
    public function getFault()
    {
        return $this->Fault;
    }
    /**
     * Set Fault value
     * @param string $fault
     * @return \StructType\Response
     */
    public function setFault($fault = null)
    {
        // validation for constraint: string
        if (!is_null($fault) && !is_string($fault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fault, true), gettype($fault)), __LINE__);
        }
        $this->Fault = $fault;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\Response
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get TestMode value
     * @return string|null
     */
    public function getTestMode()
    {
        return $this->TestMode;
    }
    /**
     * Set TestMode value
     * @param string $testMode
     * @return \StructType\Response
     */
    public function setTestMode($testMode = null)
    {
        // validation for constraint: string
        if (!is_null($testMode) && !is_string($testMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testMode, true), gettype($testMode)), __LINE__);
        }
        $this->TestMode = $testMode;
        return $this;
    }
    /**
     * Get Tariff value
     * @return string|null
     */
    public function getTariff()
    {
        return $this->Tariff;
    }
    /**
     * Set Tariff value
     * @param string $tariff
     * @return \StructType\Response
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: string
        if (!is_null($tariff) && !is_string($tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        $this->Tariff = $tariff;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Response
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Response
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get EstimatedDeliveryDate value
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->EstimatedDeliveryDate;
    }
    /**
     * Set EstimatedDeliveryDate value
     * @param string $estimatedDeliveryDate
     * @return \StructType\Response
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDate) && !is_string($estimatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryDate, true), gettype($estimatedDeliveryDate)), __LINE__);
        }
        $this->EstimatedDeliveryDate = $estimatedDeliveryDate;
        return $this;
    }
    /**
     * Get DirectPoint value
     * @return string|null
     */
    public function getDirectPoint()
    {
        return $this->DirectPoint;
    }
    /**
     * Set DirectPoint value
     * @param string $directPoint
     * @return \StructType\Response
     */
    public function setDirectPoint($directPoint = null)
    {
        // validation for constraint: string
        if (!is_null($directPoint) && !is_string($directPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directPoint, true), gettype($directPoint)), __LINE__);
        }
        $this->DirectPoint = $directPoint;
        return $this;
    }
    /**
     * Get RateType value
     * @return string|null
     */
    public function getRateType()
    {
        return $this->RateType;
    }
    /**
     * Set RateType value
     * @param string $rateType
     * @return \StructType\Response
     */
    public function setRateType($rateType = null)
    {
        // validation for constraint: string
        if (!is_null($rateType) && !is_string($rateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateType, true), gettype($rateType)), __LINE__);
        }
        $this->RateType = $rateType;
        return $this;
    }
    /**
     * Get WeightUnits value
     * @return string|null
     */
    public function getWeightUnits()
    {
        return $this->WeightUnits;
    }
    /**
     * Set WeightUnits value
     * @param string $weightUnits
     * @return \StructType\Response
     */
    public function setWeightUnits($weightUnits = null)
    {
        // validation for constraint: string
        if (!is_null($weightUnits) && !is_string($weightUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightUnits, true), gettype($weightUnits)), __LINE__);
        }
        $this->WeightUnits = $weightUnits;
        return $this;
    }
    /**
     * Get TotalCubeUnits value
     * @return string|null
     */
    public function getTotalCubeUnits()
    {
        return $this->TotalCubeUnits;
    }
    /**
     * Set TotalCubeUnits value
     * @param string $totalCubeUnits
     * @return \StructType\Response
     */
    public function setTotalCubeUnits($totalCubeUnits = null)
    {
        // validation for constraint: string
        if (!is_null($totalCubeUnits) && !is_string($totalCubeUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalCubeUnits, true), gettype($totalCubeUnits)), __LINE__);
        }
        $this->TotalCubeUnits = $totalCubeUnits;
        return $this;
    }
    /**
     * Get ExcessiveLengthTotalInches value
     * @return string|null
     */
    public function getExcessiveLengthTotalInches()
    {
        return $this->ExcessiveLengthTotalInches;
    }
    /**
     * Set ExcessiveLengthTotalInches value
     * @param string $excessiveLengthTotalInches
     * @return \StructType\Response
     */
    public function setExcessiveLengthTotalInches($excessiveLengthTotalInches = null)
    {
        // validation for constraint: string
        if (!is_null($excessiveLengthTotalInches) && !is_string($excessiveLengthTotalInches)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excessiveLengthTotalInches, true), gettype($excessiveLengthTotalInches)), __LINE__);
        }
        $this->ExcessiveLengthTotalInches = $excessiveLengthTotalInches;
        return $this;
    }
    /**
     * Get Promotion value
     * @return string|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * Set Promotion value
     * @param string $promotion
     * @return \StructType\Response
     */
    public function setPromotion($promotion = null)
    {
        // validation for constraint: string
        if (!is_null($promotion) && !is_string($promotion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotion, true), gettype($promotion)), __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
}
