<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Create StructType
 * @subpackage Structs
 */
class Create extends AbstractStructBase
{
    /**
     * The FullValueCoverage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FullValueCoverage;
    /**
     * The CODAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CODAmount;
    /**
     * The TotalCube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCube;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DeclaredValue;
    /**
     * The request
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Create
     */
    public $request;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDetailItem
     */
    public $Details;
    /**
     * The Accessorials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAccessorialItem
     */
    public $Accessorials;
    /**
     * The Dimensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDimensionItem
     */
    public $Dimensions;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The TestMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestMode;
    /**
     * The BillingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingTerms;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Application;
    /**
     * The OriginCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginCity;
    /**
     * The OriginState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginState;
    /**
     * The OriginZipcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginZipcode;
    /**
     * The DestinationCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCity;
    /**
     * The DestinationState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationState;
    /**
     * The DestinationZipcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DestinationZipcode;
    /**
     * The WeightUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WeightUnits;
    /**
     * The TotalCubeUnits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TotalCubeUnits;
    /**
     * The CommodityDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommodityDescription;
    /**
     * The BorderLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BorderLocation;
    /**
     * The ExcessiveLengthTotalInches
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExcessiveLengthTotalInches;
    /**
     * Constructor method for Create
     * @uses Create::setFullValueCoverage()
     * @uses Create::setCODAmount()
     * @uses Create::setTotalCube()
     * @uses Create::setDeclaredValue()
     * @uses Create::setRequest()
     * @uses Create::setDetails()
     * @uses Create::setAccessorials()
     * @uses Create::setDimensions()
     * @uses Create::setUserID()
     * @uses Create::setPassword()
     * @uses Create::setTestMode()
     * @uses Create::setBillingTerms()
     * @uses Create::setAccountNumber()
     * @uses Create::setApplication()
     * @uses Create::setOriginCity()
     * @uses Create::setOriginState()
     * @uses Create::setOriginZipcode()
     * @uses Create::setDestinationCity()
     * @uses Create::setDestinationState()
     * @uses Create::setDestinationZipcode()
     * @uses Create::setWeightUnits()
     * @uses Create::setTotalCubeUnits()
     * @uses Create::setCommodityDescription()
     * @uses Create::setBorderLocation()
     * @uses Create::setExcessiveLengthTotalInches()
     * @param float $fullValueCoverage
     * @param float $cODAmount
     * @param float $totalCube
     * @param float $declaredValue
     * @param \StructType\Create $request
     * @param \ArrayType\ArrayOfDetailItem $details
     * @param \ArrayType\ArrayOfAccessorialItem $accessorials
     * @param \ArrayType\ArrayOfDimensionItem $dimensions
     * @param string $userID
     * @param string $password
     * @param string $testMode
     * @param string $billingTerms
     * @param string $accountNumber
     * @param string $application
     * @param string $originCity
     * @param string $originState
     * @param string $originZipcode
     * @param string $destinationCity
     * @param string $destinationState
     * @param string $destinationZipcode
     * @param string $weightUnits
     * @param string $totalCubeUnits
     * @param string $commodityDescription
     * @param string $borderLocation
     * @param string $excessiveLengthTotalInches
     */
    public function __construct($fullValueCoverage = null, $cODAmount = null, $totalCube = null, $declaredValue = null, \StructType\Create $request = null, \ArrayType\ArrayOfDetailItem $details = null, \ArrayType\ArrayOfAccessorialItem $accessorials = null, \ArrayType\ArrayOfDimensionItem $dimensions = null, $userID = null, $password = null, $testMode = null, $billingTerms = null, $accountNumber = null, $application = null, $originCity = null, $originState = null, $originZipcode = null, $destinationCity = null, $destinationState = null, $destinationZipcode = null, $weightUnits = null, $totalCubeUnits = null, $commodityDescription = null, $borderLocation = null, $excessiveLengthTotalInches = null)
    {
        $this
            ->setFullValueCoverage($fullValueCoverage)
            ->setCODAmount($cODAmount)
            ->setTotalCube($totalCube)
            ->setDeclaredValue($declaredValue)
            ->setRequest($request)
            ->setDetails($details)
            ->setAccessorials($accessorials)
            ->setDimensions($dimensions)
            ->setUserID($userID)
            ->setPassword($password)
            ->setTestMode($testMode)
            ->setBillingTerms($billingTerms)
            ->setAccountNumber($accountNumber)
            ->setApplication($application)
            ->setOriginCity($originCity)
            ->setOriginState($originState)
            ->setOriginZipcode($originZipcode)
            ->setDestinationCity($destinationCity)
            ->setDestinationState($destinationState)
            ->setDestinationZipcode($destinationZipcode)
            ->setWeightUnits($weightUnits)
            ->setTotalCubeUnits($totalCubeUnits)
            ->setCommodityDescription($commodityDescription)
            ->setBorderLocation($borderLocation)
            ->setExcessiveLengthTotalInches($excessiveLengthTotalInches);
    }
    /**
     * Get FullValueCoverage value
     * @return float
     */
    public function getFullValueCoverage()
    {
        return $this->FullValueCoverage;
    }
    /**
     * Set FullValueCoverage value
     * @param float $fullValueCoverage
     * @return \StructType\Create
     */
    public function setFullValueCoverage($fullValueCoverage = null)
    {
        // validation for constraint: float
        if (!is_null($fullValueCoverage) && !(is_float($fullValueCoverage) || is_numeric($fullValueCoverage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fullValueCoverage, true), gettype($fullValueCoverage)), __LINE__);
        }
        $this->FullValueCoverage = $fullValueCoverage;
        return $this;
    }
    /**
     * Get CODAmount value
     * @return float
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param float $cODAmount
     * @return \StructType\Create
     */
    public function setCODAmount($cODAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cODAmount) && !(is_float($cODAmount) || is_numeric($cODAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cODAmount, true), gettype($cODAmount)), __LINE__);
        }
        $this->CODAmount = $cODAmount;
        return $this;
    }
    /**
     * Get TotalCube value
     * @return float
     */
    public function getTotalCube()
    {
        return $this->TotalCube;
    }
    /**
     * Set TotalCube value
     * @param float $totalCube
     * @return \StructType\Create
     */
    public function setTotalCube($totalCube = null)
    {
        // validation for constraint: float
        if (!is_null($totalCube) && !(is_float($totalCube) || is_numeric($totalCube))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCube, true), gettype($totalCube)), __LINE__);
        }
        $this->TotalCube = $totalCube;
        return $this;
    }
    /**
     * Get DeclaredValue value
     * @return float
     */
    public function getDeclaredValue()
    {
        return $this->DeclaredValue;
    }
    /**
     * Set DeclaredValue value
     * @param float $declaredValue
     * @return \StructType\Create
     */
    public function setDeclaredValue($declaredValue = null)
    {
        // validation for constraint: float
        if (!is_null($declaredValue) && !(is_float($declaredValue) || is_numeric($declaredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($declaredValue, true), gettype($declaredValue)), __LINE__);
        }
        $this->DeclaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get request value
     * @return \StructType\Create|null
     */
    public function getRequest()
    {
        return $this->request;
    }
    /**
     * Set request value
     * @param \StructType\Create $request
     * @return \StructType\Create
     */
    public function setRequest(\StructType\Create $request = null)
    {
        $this->request = $request;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfDetailItem|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfDetailItem $details
     * @return \StructType\Create
     */
    public function setDetails(\ArrayType\ArrayOfDetailItem $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get Accessorials value
     * @return \ArrayType\ArrayOfAccessorialItem|null
     */
    public function getAccessorials()
    {
        return $this->Accessorials;
    }
    /**
     * Set Accessorials value
     * @param \ArrayType\ArrayOfAccessorialItem $accessorials
     * @return \StructType\Create
     */
    public function setAccessorials(\ArrayType\ArrayOfAccessorialItem $accessorials = null)
    {
        $this->Accessorials = $accessorials;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \ArrayType\ArrayOfDimensionItem|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \ArrayType\ArrayOfDimensionItem $dimensions
     * @return \StructType\Create
     */
    public function setDimensions(\ArrayType\ArrayOfDimensionItem $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\Create
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Create
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get TestMode value
     * @return string|null
     */
    public function getTestMode()
    {
        return $this->TestMode;
    }
    /**
     * Set TestMode value
     * @param string $testMode
     * @return \StructType\Create
     */
    public function setTestMode($testMode = null)
    {
        // validation for constraint: string
        if (!is_null($testMode) && !is_string($testMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testMode, true), gettype($testMode)), __LINE__);
        }
        $this->TestMode = $testMode;
        return $this;
    }
    /**
     * Get BillingTerms value
     * @return string|null
     */
    public function getBillingTerms()
    {
        return $this->BillingTerms;
    }
    /**
     * Set BillingTerms value
     * @param string $billingTerms
     * @return \StructType\Create
     */
    public function setBillingTerms($billingTerms = null)
    {
        // validation for constraint: string
        if (!is_null($billingTerms) && !is_string($billingTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingTerms, true), gettype($billingTerms)), __LINE__);
        }
        $this->BillingTerms = $billingTerms;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\Create
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \StructType\Create
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get OriginCity value
     * @return string|null
     */
    public function getOriginCity()
    {
        return $this->OriginCity;
    }
    /**
     * Set OriginCity value
     * @param string $originCity
     * @return \StructType\Create
     */
    public function setOriginCity($originCity = null)
    {
        // validation for constraint: string
        if (!is_null($originCity) && !is_string($originCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCity, true), gettype($originCity)), __LINE__);
        }
        $this->OriginCity = $originCity;
        return $this;
    }
    /**
     * Get OriginState value
     * @return string|null
     */
    public function getOriginState()
    {
        return $this->OriginState;
    }
    /**
     * Set OriginState value
     * @param string $originState
     * @return \StructType\Create
     */
    public function setOriginState($originState = null)
    {
        // validation for constraint: string
        if (!is_null($originState) && !is_string($originState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originState, true), gettype($originState)), __LINE__);
        }
        $this->OriginState = $originState;
        return $this;
    }
    /**
     * Get OriginZipcode value
     * @return string|null
     */
    public function getOriginZipcode()
    {
        return $this->OriginZipcode;
    }
    /**
     * Set OriginZipcode value
     * @param string $originZipcode
     * @return \StructType\Create
     */
    public function setOriginZipcode($originZipcode = null)
    {
        // validation for constraint: string
        if (!is_null($originZipcode) && !is_string($originZipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originZipcode, true), gettype($originZipcode)), __LINE__);
        }
        $this->OriginZipcode = $originZipcode;
        return $this;
    }
    /**
     * Get DestinationCity value
     * @return string|null
     */
    public function getDestinationCity()
    {
        return $this->DestinationCity;
    }
    /**
     * Set DestinationCity value
     * @param string $destinationCity
     * @return \StructType\Create
     */
    public function setDestinationCity($destinationCity = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCity) && !is_string($destinationCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCity, true), gettype($destinationCity)), __LINE__);
        }
        $this->DestinationCity = $destinationCity;
        return $this;
    }
    /**
     * Get DestinationState value
     * @return string|null
     */
    public function getDestinationState()
    {
        return $this->DestinationState;
    }
    /**
     * Set DestinationState value
     * @param string $destinationState
     * @return \StructType\Create
     */
    public function setDestinationState($destinationState = null)
    {
        // validation for constraint: string
        if (!is_null($destinationState) && !is_string($destinationState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationState, true), gettype($destinationState)), __LINE__);
        }
        $this->DestinationState = $destinationState;
        return $this;
    }
    /**
     * Get DestinationZipcode value
     * @return string|null
     */
    public function getDestinationZipcode()
    {
        return $this->DestinationZipcode;
    }
    /**
     * Set DestinationZipcode value
     * @param string $destinationZipcode
     * @return \StructType\Create
     */
    public function setDestinationZipcode($destinationZipcode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZipcode) && !is_string($destinationZipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationZipcode, true), gettype($destinationZipcode)), __LINE__);
        }
        $this->DestinationZipcode = $destinationZipcode;
        return $this;
    }
    /**
     * Get WeightUnits value
     * @return string|null
     */
    public function getWeightUnits()
    {
        return $this->WeightUnits;
    }
    /**
     * Set WeightUnits value
     * @param string $weightUnits
     * @return \StructType\Create
     */
    public function setWeightUnits($weightUnits = null)
    {
        // validation for constraint: string
        if (!is_null($weightUnits) && !is_string($weightUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightUnits, true), gettype($weightUnits)), __LINE__);
        }
        $this->WeightUnits = $weightUnits;
        return $this;
    }
    /**
     * Get TotalCubeUnits value
     * @return string|null
     */
    public function getTotalCubeUnits()
    {
        return $this->TotalCubeUnits;
    }
    /**
     * Set TotalCubeUnits value
     * @param string $totalCubeUnits
     * @return \StructType\Create
     */
    public function setTotalCubeUnits($totalCubeUnits = null)
    {
        // validation for constraint: string
        if (!is_null($totalCubeUnits) && !is_string($totalCubeUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalCubeUnits, true), gettype($totalCubeUnits)), __LINE__);
        }
        $this->TotalCubeUnits = $totalCubeUnits;
        return $this;
    }
    /**
     * Get CommodityDescription value
     * @return string|null
     */
    public function getCommodityDescription()
    {
        return $this->CommodityDescription;
    }
    /**
     * Set CommodityDescription value
     * @param string $commodityDescription
     * @return \StructType\Create
     */
    public function setCommodityDescription($commodityDescription = null)
    {
        // validation for constraint: string
        if (!is_null($commodityDescription) && !is_string($commodityDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityDescription, true), gettype($commodityDescription)), __LINE__);
        }
        $this->CommodityDescription = $commodityDescription;
        return $this;
    }
    /**
     * Get BorderLocation value
     * @return string|null
     */
    public function getBorderLocation()
    {
        return $this->BorderLocation;
    }
    /**
     * Set BorderLocation value
     * @param string $borderLocation
     * @return \StructType\Create
     */
    public function setBorderLocation($borderLocation = null)
    {
        // validation for constraint: string
        if (!is_null($borderLocation) && !is_string($borderLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($borderLocation, true), gettype($borderLocation)), __LINE__);
        }
        $this->BorderLocation = $borderLocation;
        return $this;
    }
    /**
     * Get ExcessiveLengthTotalInches value
     * @return string|null
     */
    public function getExcessiveLengthTotalInches()
    {
        return $this->ExcessiveLengthTotalInches;
    }
    /**
     * Set ExcessiveLengthTotalInches value
     * @param string $excessiveLengthTotalInches
     * @return \StructType\Create
     */
    public function setExcessiveLengthTotalInches($excessiveLengthTotalInches = null)
    {
        // validation for constraint: string
        if (!is_null($excessiveLengthTotalInches) && !is_string($excessiveLengthTotalInches)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excessiveLengthTotalInches, true), gettype($excessiveLengthTotalInches)), __LINE__);
        }
        $this->ExcessiveLengthTotalInches = $excessiveLengthTotalInches;
        return $this;
    }
}
