<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDimensionItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDimensionItem extends AbstractStructArrayBase
{
    /**
     * The DimensionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DimensionItem[]
     */
    public $DimensionItem;
    /**
     * Constructor method for ArrayOfDimensionItem
     * @uses ArrayOfDimensionItem::setDimensionItem()
     * @param \StructType\DimensionItem[] $dimensionItem
     */
    public function __construct(array $dimensionItem = array())
    {
        $this
            ->setDimensionItem($dimensionItem);
    }
    /**
     * Get DimensionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DimensionItem[]|null
     */
    public function getDimensionItem()
    {
        return isset($this->DimensionItem) ? $this->DimensionItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDimensionItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDimensionItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDimensionItemForArrayConstraintsFromSetDimensionItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDimensionItemDimensionItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDimensionItemDimensionItemItem instanceof \StructType\DimensionItem) {
                $invalidValues[] = is_object($arrayOfDimensionItemDimensionItemItem) ? get_class($arrayOfDimensionItemDimensionItemItem) : sprintf('%s(%s)', gettype($arrayOfDimensionItemDimensionItemItem), var_export($arrayOfDimensionItemDimensionItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DimensionItem property can only contain items of type \StructType\DimensionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DimensionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionItem[] $dimensionItem
     * @return \ArrayType\ArrayOfDimensionItem
     */
    public function setDimensionItem(array $dimensionItem = array())
    {
        // validation for constraint: array
        if ('' !== ($dimensionItemArrayErrorMessage = self::validateDimensionItemForArrayConstraintsFromSetDimensionItem($dimensionItem))) {
            throw new \InvalidArgumentException($dimensionItemArrayErrorMessage, __LINE__);
        }
        if (is_null($dimensionItem) || (is_array($dimensionItem) && empty($dimensionItem))) {
            unset($this->DimensionItem);
        } else {
            $this->DimensionItem = $dimensionItem;
        }
        return $this;
    }
    /**
     * Add item to DimensionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DimensionItem $item
     * @return \ArrayType\ArrayOfDimensionItem
     */
    public function addToDimensionItem(\StructType\DimensionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DimensionItem) {
            throw new \InvalidArgumentException(sprintf('The DimensionItem property can only contain items of type \StructType\DimensionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DimensionItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DimensionItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DimensionItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DimensionItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DimensionItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DimensionItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DimensionItem
     */
    public function getAttributeName()
    {
        return 'DimensionItem';
    }
}
