<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDetailItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDetailItem extends AbstractStructArrayBase
{
    /**
     * The DetailItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DetailItem[]
     */
    public $DetailItem;
    /**
     * Constructor method for ArrayOfDetailItem
     * @uses ArrayOfDetailItem::setDetailItem()
     * @param \StructType\DetailItem[] $detailItem
     */
    public function __construct(array $detailItem = array())
    {
        $this
            ->setDetailItem($detailItem);
    }
    /**
     * Get DetailItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DetailItem[]|null
     */
    public function getDetailItem()
    {
        return isset($this->DetailItem) ? $this->DetailItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDetailItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetailItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailItemForArrayConstraintsFromSetDetailItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDetailItemDetailItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDetailItemDetailItemItem instanceof \StructType\DetailItem) {
                $invalidValues[] = is_object($arrayOfDetailItemDetailItemItem) ? get_class($arrayOfDetailItemDetailItemItem) : sprintf('%s(%s)', gettype($arrayOfDetailItemDetailItemItem), var_export($arrayOfDetailItemDetailItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DetailItem property can only contain items of type \StructType\DetailItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DetailItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DetailItem[] $detailItem
     * @return \ArrayType\ArrayOfDetailItem
     */
    public function setDetailItem(array $detailItem = array())
    {
        // validation for constraint: array
        if ('' !== ($detailItemArrayErrorMessage = self::validateDetailItemForArrayConstraintsFromSetDetailItem($detailItem))) {
            throw new \InvalidArgumentException($detailItemArrayErrorMessage, __LINE__);
        }
        if (is_null($detailItem) || (is_array($detailItem) && empty($detailItem))) {
            unset($this->DetailItem);
        } else {
            $this->DetailItem = $detailItem;
        }
        return $this;
    }
    /**
     * Add item to DetailItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailItem $item
     * @return \ArrayType\ArrayOfDetailItem
     */
    public function addToDetailItem(\StructType\DetailItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DetailItem) {
            throw new \InvalidArgumentException(sprintf('The DetailItem property can only contain items of type \StructType\DetailItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DetailItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DetailItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DetailItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DetailItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DetailItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DetailItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DetailItem
     */
    public function getAttributeName()
    {
        return 'DetailItem';
    }
}
