<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccessorialItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfAccessorialItem extends AbstractStructArrayBase
{
    /**
     * The AccessorialItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccessorialItem[]
     */
    public $AccessorialItem;
    /**
     * Constructor method for ArrayOfAccessorialItem
     * @uses ArrayOfAccessorialItem::setAccessorialItem()
     * @param \StructType\AccessorialItem[] $accessorialItem
     */
    public function __construct(array $accessorialItem = array())
    {
        $this
            ->setAccessorialItem($accessorialItem);
    }
    /**
     * Get AccessorialItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccessorialItem[]|null
     */
    public function getAccessorialItem()
    {
        return isset($this->AccessorialItem) ? $this->AccessorialItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessorialItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessorialItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessorialItemForArrayConstraintsFromSetAccessorialItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccessorialItemAccessorialItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccessorialItemAccessorialItemItem instanceof \StructType\AccessorialItem) {
                $invalidValues[] = is_object($arrayOfAccessorialItemAccessorialItemItem) ? get_class($arrayOfAccessorialItemAccessorialItemItem) : sprintf('%s(%s)', gettype($arrayOfAccessorialItemAccessorialItemItem), var_export($arrayOfAccessorialItemAccessorialItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccessorialItem property can only contain items of type \StructType\AccessorialItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessorialItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccessorialItem[] $accessorialItem
     * @return \ArrayType\ArrayOfAccessorialItem
     */
    public function setAccessorialItem(array $accessorialItem = array())
    {
        // validation for constraint: array
        if ('' !== ($accessorialItemArrayErrorMessage = self::validateAccessorialItemForArrayConstraintsFromSetAccessorialItem($accessorialItem))) {
            throw new \InvalidArgumentException($accessorialItemArrayErrorMessage, __LINE__);
        }
        if (is_null($accessorialItem) || (is_array($accessorialItem) && empty($accessorialItem))) {
            unset($this->AccessorialItem);
        } else {
            $this->AccessorialItem = $accessorialItem;
        }
        return $this;
    }
    /**
     * Add item to AccessorialItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessorialItem $item
     * @return \ArrayType\ArrayOfAccessorialItem
     */
    public function addToAccessorialItem(\StructType\AccessorialItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessorialItem) {
            throw new \InvalidArgumentException(sprintf('The AccessorialItem property can only contain items of type \StructType\AccessorialItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccessorialItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccessorialItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccessorialItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccessorialItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccessorialItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccessorialItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccessorialItem
     */
    public function getAttributeName()
    {
        return 'AccessorialItem';
    }
}
