<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TVHWS.carrier StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TVHWS.carrier
 * @subpackage Structs
 */
class TVHWS_carrier extends AbstractStructBase
{
    /**
     * The accountnumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $accountnumber;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The po
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $po;
    /**
     * The shipcomplete
     * @var bool
     */
    public $shipcomplete;
    /**
     * The wh
     * @var int
     */
    public $wh;
    /**
     * Constructor method for TVHWS.carrier
     * @uses TVHWS_carrier::setAccountnumber()
     * @uses TVHWS_carrier::setCode()
     * @uses TVHWS_carrier::setPo()
     * @uses TVHWS_carrier::setShipcomplete()
     * @uses TVHWS_carrier::setWh()
     * @param string $accountnumber
     * @param string $code
     * @param string $po
     * @param bool $shipcomplete
     * @param int $wh
     */
    public function __construct($accountnumber = null, $code = null, $po = null, $shipcomplete = null, $wh = null)
    {
        $this
            ->setAccountnumber($accountnumber)
            ->setCode($code)
            ->setPo($po)
            ->setShipcomplete($shipcomplete)
            ->setWh($wh);
    }
    /**
     * Get accountnumber value
     * @return string|null
     */
    public function getAccountnumber()
    {
        return $this->accountnumber;
    }
    /**
     * Set accountnumber value
     * @param string $accountnumber
     * @return \StructType\TVHWS_carrier
     */
    public function setAccountnumber($accountnumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountnumber) && !is_string($accountnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountnumber, true), gettype($accountnumber)), __LINE__);
        }
        $this->accountnumber = $accountnumber;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\TVHWS_carrier
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get po value
     * @return string|null
     */
    public function getPo()
    {
        return $this->po;
    }
    /**
     * Set po value
     * @param string $po
     * @return \StructType\TVHWS_carrier
     */
    public function setPo($po = null)
    {
        // validation for constraint: string
        if (!is_null($po) && !is_string($po)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($po, true), gettype($po)), __LINE__);
        }
        $this->po = $po;
        return $this;
    }
    /**
     * Get shipcomplete value
     * @return bool|null
     */
    public function getShipcomplete()
    {
        return $this->shipcomplete;
    }
    /**
     * Set shipcomplete value
     * @param bool $shipcomplete
     * @return \StructType\TVHWS_carrier
     */
    public function setShipcomplete($shipcomplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipcomplete) && !is_bool($shipcomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipcomplete, true), gettype($shipcomplete)), __LINE__);
        }
        $this->shipcomplete = $shipcomplete;
        return $this;
    }
    /**
     * Get wh value
     * @return int|null
     */
    public function getWh()
    {
        return $this->wh;
    }
    /**
     * Set wh value
     * @param int $wh
     * @return \StructType\TVHWS_carrier
     */
    public function setWh($wh = null)
    {
        // validation for constraint: int
        if (!is_null($wh) && !(is_int($wh) || ctype_digit($wh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wh, true), gettype($wh)), __LINE__);
        }
        $this->wh = $wh;
        return $this;
    }
}
