<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTVHWS.warehouse ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTVHWS.warehouse
 * @subpackage Arrays
 */
class ArrayOfTVHWS_warehouse extends AbstractStructArrayBase
{
    /**
     * The TVHWS_warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TVHWS_warehouse[]
     */
    public $TVHWS_warehouse;
    /**
     * Constructor method for ArrayOfTVHWS.warehouse
     * @uses ArrayOfTVHWS_warehouse::setTVHWS_warehouse()
     * @param \StructType\TVHWS_warehouse[] $tVHWS_warehouse
     */
    public function __construct(array $tVHWS_warehouse = array())
    {
        $this
            ->setTVHWS_warehouse($tVHWS_warehouse);
    }
    /**
     * Get TVHWS_warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TVHWS_warehouse[]|null
     */
    public function getTVHWS_warehouse()
    {
        return isset($this->{'TVHWS.warehouse'}) ? $this->{'TVHWS.warehouse'} : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTVHWS_warehouse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTVHWS_warehouse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTVHWS_warehouseForArrayConstraintsFromSetTVHWS_warehouse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTVHWS_warehouseTVHWS_warehouseItem) {
            // validation for constraint: itemType
            if (!$arrayOfTVHWS_warehouseTVHWS_warehouseItem instanceof \StructType\TVHWS_warehouse) {
                $invalidValues[] = is_object($arrayOfTVHWS_warehouseTVHWS_warehouseItem) ? get_class($arrayOfTVHWS_warehouseTVHWS_warehouseItem) : sprintf('%s(%s)', gettype($arrayOfTVHWS_warehouseTVHWS_warehouseItem), var_export($arrayOfTVHWS_warehouseTVHWS_warehouseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TVHWS_warehouse property can only contain items of type \StructType\TVHWS_warehouse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TVHWS_warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TVHWS_warehouse[] $tVHWS_warehouse
     * @return \ArrayType\ArrayOfTVHWS_warehouse
     */
    public function setTVHWS_warehouse(array $tVHWS_warehouse = array())
    {
        // validation for constraint: array
        if ('' !== ($tVHWS_warehouseArrayErrorMessage = self::validateTVHWS_warehouseForArrayConstraintsFromSetTVHWS_warehouse($tVHWS_warehouse))) {
            throw new \InvalidArgumentException($tVHWS_warehouseArrayErrorMessage, __LINE__);
        }
        if (is_null($tVHWS_warehouse) || (is_array($tVHWS_warehouse) && empty($tVHWS_warehouse))) {
            unset($this->TVHWS_warehouse, $this->{'TVHWS.warehouse'});
        } else {
            $this->TVHWS_warehouse = $this->{'TVHWS.warehouse'} = $tVHWS_warehouse;
        }
        return $this;
    }
    /**
     * Add item to TVHWS_warehouse value
     * @throws \InvalidArgumentException
     * @param \StructType\TVHWS_warehouse $item
     * @return \ArrayType\ArrayOfTVHWS_warehouse
     */
    public function addToTVHWS_warehouse(\StructType\TVHWS_warehouse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TVHWS_warehouse) {
            throw new \InvalidArgumentException(sprintf('The TVHWS_warehouse property can only contain items of type \StructType\TVHWS_warehouse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TVHWS_warehouse[] = $this->{'TVHWS.warehouse'}[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TVHWS_warehouse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TVHWS_warehouse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TVHWS_warehouse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TVHWS_warehouse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TVHWS_warehouse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TVHWS.warehouse
     */
    public function getAttributeName()
    {
        return 'TVHWS.warehouse';
    }
}
