<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TVHWS.transport_request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TVHWS.transport_request
 * @subpackage Structs
 */
class TVHWS_transport_request extends AbstractStructBase
{
    /**
     * The passport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\TVHWS_passport
     */
    public $passport;
    /**
     * The shiptocode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $shiptocode;
    /**
     * The warehouse
     * @var int
     */
    public $warehouse;
    /**
     * Constructor method for TVHWS.transport_request
     * @uses TVHWS_transport_request::setPassport()
     * @uses TVHWS_transport_request::setShiptocode()
     * @uses TVHWS_transport_request::setWarehouse()
     * @param \StructType\TVHWS_passport $passport
     * @param string $shiptocode
     * @param int $warehouse
     */
    public function __construct(\StructType\TVHWS_passport $passport = null, $shiptocode = null, $warehouse = null)
    {
        $this
            ->setPassport($passport)
            ->setShiptocode($shiptocode)
            ->setWarehouse($warehouse);
    }
    /**
     * Get passport value
     * @return \StructType\TVHWS_passport|null
     */
    public function getPassport()
    {
        return $this->passport;
    }
    /**
     * Set passport value
     * @param \StructType\TVHWS_passport $passport
     * @return \StructType\TVHWS_transport_request
     */
    public function setPassport(\StructType\TVHWS_passport $passport = null)
    {
        $this->passport = $passport;
        return $this;
    }
    /**
     * Get shiptocode value
     * @return string|null
     */
    public function getShiptocode()
    {
        return $this->shiptocode;
    }
    /**
     * Set shiptocode value
     * @param string $shiptocode
     * @return \StructType\TVHWS_transport_request
     */
    public function setShiptocode($shiptocode = null)
    {
        // validation for constraint: string
        if (!is_null($shiptocode) && !is_string($shiptocode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shiptocode, true), gettype($shiptocode)), __LINE__);
        }
        $this->shiptocode = $shiptocode;
        return $this;
    }
    /**
     * Get warehouse value
     * @return int|null
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }
    /**
     * Set warehouse value
     * @param int $warehouse
     * @return \StructType\TVHWS_transport_request
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: int
        if (!is_null($warehouse) && !(is_int($warehouse) || ctype_digit($warehouse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warehouse, true), gettype($warehouse)), __LINE__);
        }
        $this->warehouse = $warehouse;
        return $this;
    }
}
