<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TVHWS.qtybreak StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TVHWS.qtybreak
 * @subpackage Structs
 */
class TVHWS_qtybreak extends AbstractStructBase
{
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The qtycount
     * @var int
     */
    public $qtycount;
    /**
     * Constructor method for TVHWS.qtybreak
     * @uses TVHWS_qtybreak::setPrice()
     * @uses TVHWS_qtybreak::setQtycount()
     * @param float $price
     * @param int $qtycount
     */
    public function __construct($price = null, $qtycount = null)
    {
        $this
            ->setPrice($price)
            ->setQtycount($qtycount);
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\TVHWS_qtybreak
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get qtycount value
     * @return int|null
     */
    public function getQtycount()
    {
        return $this->qtycount;
    }
    /**
     * Set qtycount value
     * @param int $qtycount
     * @return \StructType\TVHWS_qtybreak
     */
    public function setQtycount($qtycount = null)
    {
        // validation for constraint: int
        if (!is_null($qtycount) && !(is_int($qtycount) || ctype_digit($qtycount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qtycount, true), gettype($qtycount)), __LINE__);
        }
        $this->qtycount = $qtycount;
        return $this;
    }
}
