<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TVHWS.passport StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TVHWS.passport
 * @subpackage Structs
 */
class TVHWS_passport extends AbstractStructBase
{
    /**
     * The accesskey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $accesskey;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $account;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The requestkey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $requestkey;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * Constructor method for TVHWS.passport
     * @uses TVHWS_passport::setAccesskey()
     * @uses TVHWS_passport::setAccount()
     * @uses TVHWS_passport::setPassword()
     * @uses TVHWS_passport::setRequestkey()
     * @uses TVHWS_passport::setUsername()
     * @uses TVHWS_passport::setVersion()
     * @param string $accesskey
     * @param string $account
     * @param string $password
     * @param string $requestkey
     * @param string $username
     * @param string $version
     */
    public function __construct($accesskey = null, $account = null, $password = null, $requestkey = null, $username = null, $version = null)
    {
        $this
            ->setAccesskey($accesskey)
            ->setAccount($account)
            ->setPassword($password)
            ->setRequestkey($requestkey)
            ->setUsername($username)
            ->setVersion($version);
    }
    /**
     * Get accesskey value
     * @return string|null
     */
    public function getAccesskey()
    {
        return $this->accesskey;
    }
    /**
     * Set accesskey value
     * @param string $accesskey
     * @return \StructType\TVHWS_passport
     */
    public function setAccesskey($accesskey = null)
    {
        // validation for constraint: string
        if (!is_null($accesskey) && !is_string($accesskey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accesskey, true), gettype($accesskey)), __LINE__);
        }
        $this->accesskey = $accesskey;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \StructType\TVHWS_passport
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\TVHWS_passport
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get requestkey value
     * @return string|null
     */
    public function getRequestkey()
    {
        return $this->requestkey;
    }
    /**
     * Set requestkey value
     * @param string $requestkey
     * @return \StructType\TVHWS_passport
     */
    public function setRequestkey($requestkey = null)
    {
        // validation for constraint: string
        if (!is_null($requestkey) && !is_string($requestkey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestkey, true), gettype($requestkey)), __LINE__);
        }
        $this->requestkey = $requestkey;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\TVHWS_passport
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @uses \EnumType\TVHWS_versions::valueIsValid()
     * @uses \EnumType\TVHWS_versions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $version
     * @return \StructType\TVHWS_passport
     */
    public function setVersion($version = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TVHWS_versions::valueIsValid($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TVHWS_versions', is_array($version) ? implode(', ', $version) : var_export($version, true), implode(', ', \EnumType\TVHWS_versions::getValidValues())), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
