<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetPriceAndAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPriceAndAvailability $parameters
     * @return \StructType\GetPriceAndAvailabilityResponse|bool
     */
    public function GetPriceAndAvailability(\StructType\GetPriceAndAvailability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPriceAndAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransportList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransportList $parameters
     * @return \StructType\GetTransportListResponse|bool
     */
    public function GetTransportList(\StructType\GetTransportList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransportList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWarehouseList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWarehouseList $parameters
     * @return \StructType\GetWarehouseListResponse|bool
     */
    public function GetWarehouseList(\StructType\GetWarehouseList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWarehouseList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetPriceAndAvailabilityResponse|\StructType\GetTransportListResponse|\StructType\GetWarehouseListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
