<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTVHWS.item_request ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTVHWS.item_request
 * @subpackage Arrays
 */
class ArrayOfTVHWS_item_request extends AbstractStructArrayBase
{
    /**
     * The TVHWS_item_request
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TVHWS_item_request[]
     */
    public $TVHWS_item_request;
    /**
     * Constructor method for ArrayOfTVHWS.item_request
     * @uses ArrayOfTVHWS_item_request::setTVHWS_item_request()
     * @param \StructType\TVHWS_item_request[] $tVHWS_item_request
     */
    public function __construct(array $tVHWS_item_request = array())
    {
        $this
            ->setTVHWS_item_request($tVHWS_item_request);
    }
    /**
     * Get TVHWS_item_request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TVHWS_item_request[]|null
     */
    public function getTVHWS_item_request()
    {
        return isset($this->{'TVHWS.item_request'}) ? $this->{'TVHWS.item_request'} : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTVHWS_item_request method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTVHWS_item_request method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTVHWS_item_requestForArrayConstraintsFromSetTVHWS_item_request(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTVHWS_item_requestTVHWS_item_requestItem) {
            // validation for constraint: itemType
            if (!$arrayOfTVHWS_item_requestTVHWS_item_requestItem instanceof \StructType\TVHWS_item_request) {
                $invalidValues[] = is_object($arrayOfTVHWS_item_requestTVHWS_item_requestItem) ? get_class($arrayOfTVHWS_item_requestTVHWS_item_requestItem) : sprintf('%s(%s)', gettype($arrayOfTVHWS_item_requestTVHWS_item_requestItem), var_export($arrayOfTVHWS_item_requestTVHWS_item_requestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TVHWS_item_request property can only contain items of type \StructType\TVHWS_item_request, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TVHWS_item_request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TVHWS_item_request[] $tVHWS_item_request
     * @return \ArrayType\ArrayOfTVHWS_item_request
     */
    public function setTVHWS_item_request(array $tVHWS_item_request = array())
    {
        // validation for constraint: array
        if ('' !== ($tVHWS_item_requestArrayErrorMessage = self::validateTVHWS_item_requestForArrayConstraintsFromSetTVHWS_item_request($tVHWS_item_request))) {
            throw new \InvalidArgumentException($tVHWS_item_requestArrayErrorMessage, __LINE__);
        }
        if (is_null($tVHWS_item_request) || (is_array($tVHWS_item_request) && empty($tVHWS_item_request))) {
            unset($this->TVHWS_item_request, $this->{'TVHWS.item_request'});
        } else {
            $this->TVHWS_item_request = $this->{'TVHWS.item_request'} = $tVHWS_item_request;
        }
        return $this;
    }
    /**
     * Add item to TVHWS_item_request value
     * @throws \InvalidArgumentException
     * @param \StructType\TVHWS_item_request $item
     * @return \ArrayType\ArrayOfTVHWS_item_request
     */
    public function addToTVHWS_item_request(\StructType\TVHWS_item_request $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TVHWS_item_request) {
            throw new \InvalidArgumentException(sprintf('The TVHWS_item_request property can only contain items of type \StructType\TVHWS_item_request, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TVHWS_item_request[] = $this->{'TVHWS.item_request'}[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TVHWS_item_request|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TVHWS_item_request|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TVHWS_item_request|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TVHWS_item_request|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TVHWS_item_request|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TVHWS.item_request
     */
    public function getAttributeName()
    {
        return 'TVHWS.item_request';
    }
}
