<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TVHWS.warehouse_request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TVHWS.warehouse_request
 * @subpackage Structs
 */
class TVHWS_warehouse_request extends AbstractStructBase
{
    /**
     * The passport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\TVHWS_passport
     */
    public $passport;
    /**
     * The warehouse
     * @var int
     */
    public $warehouse;
    /**
     * Constructor method for TVHWS.warehouse_request
     * @uses TVHWS_warehouse_request::setPassport()
     * @uses TVHWS_warehouse_request::setWarehouse()
     * @param \StructType\TVHWS_passport $passport
     * @param int $warehouse
     */
    public function __construct(\StructType\TVHWS_passport $passport = null, $warehouse = null)
    {
        $this
            ->setPassport($passport)
            ->setWarehouse($warehouse);
    }
    /**
     * Get passport value
     * @return \StructType\TVHWS_passport|null
     */
    public function getPassport()
    {
        return $this->passport;
    }
    /**
     * Set passport value
     * @param \StructType\TVHWS_passport $passport
     * @return \StructType\TVHWS_warehouse_request
     */
    public function setPassport(\StructType\TVHWS_passport $passport = null)
    {
        $this->passport = $passport;
        return $this;
    }
    /**
     * Get warehouse value
     * @return int|null
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }
    /**
     * Set warehouse value
     * @param int $warehouse
     * @return \StructType\TVHWS_warehouse_request
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: int
        if (!is_null($warehouse) && !(is_int($warehouse) || ctype_digit($warehouse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warehouse, true), gettype($warehouse)), __LINE__);
        }
        $this->warehouse = $warehouse;
        return $this;
    }
}
