<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TVHWS.price StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TVHWS.price
 * @subpackage Structs
 */
class TVHWS_price extends AbstractStructBase
{
    /**
     * The coreprice
     * @var float
     */
    public $coreprice;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currency;
    /**
     * The itemprice
     * @var float
     */
    public $itemprice;
    /**
     * The listprice
     * @var float
     */
    public $listprice;
    /**
     * The qtybreaks
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfTVHWS_qtybreak
     */
    public $qtybreaks;
    /**
     * Constructor method for TVHWS.price
     * @uses TVHWS_price::setCoreprice()
     * @uses TVHWS_price::setCurrency()
     * @uses TVHWS_price::setItemprice()
     * @uses TVHWS_price::setListprice()
     * @uses TVHWS_price::setQtybreaks()
     * @param float $coreprice
     * @param string $currency
     * @param float $itemprice
     * @param float $listprice
     * @param \ArrayType\ArrayOfTVHWS_qtybreak $qtybreaks
     */
    public function __construct($coreprice = null, $currency = null, $itemprice = null, $listprice = null, \ArrayType\ArrayOfTVHWS_qtybreak $qtybreaks = null)
    {
        $this
            ->setCoreprice($coreprice)
            ->setCurrency($currency)
            ->setItemprice($itemprice)
            ->setListprice($listprice)
            ->setQtybreaks($qtybreaks);
    }
    /**
     * Get coreprice value
     * @return float|null
     */
    public function getCoreprice()
    {
        return $this->coreprice;
    }
    /**
     * Set coreprice value
     * @param float $coreprice
     * @return \StructType\TVHWS_price
     */
    public function setCoreprice($coreprice = null)
    {
        // validation for constraint: float
        if (!is_null($coreprice) && !(is_float($coreprice) || is_numeric($coreprice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coreprice, true), gettype($coreprice)), __LINE__);
        }
        $this->coreprice = $coreprice;
        return $this;
    }
    /**
     * Get currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->currency) ? $this->currency : null;
    }
    /**
     * Set currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \StructType\TVHWS_price
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->currency);
        } else {
            $this->currency = $currency;
        }
        return $this;
    }
    /**
     * Get itemprice value
     * @return float|null
     */
    public function getItemprice()
    {
        return $this->itemprice;
    }
    /**
     * Set itemprice value
     * @param float $itemprice
     * @return \StructType\TVHWS_price
     */
    public function setItemprice($itemprice = null)
    {
        // validation for constraint: float
        if (!is_null($itemprice) && !(is_float($itemprice) || is_numeric($itemprice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemprice, true), gettype($itemprice)), __LINE__);
        }
        $this->itemprice = $itemprice;
        return $this;
    }
    /**
     * Get listprice value
     * @return float|null
     */
    public function getListprice()
    {
        return $this->listprice;
    }
    /**
     * Set listprice value
     * @param float $listprice
     * @return \StructType\TVHWS_price
     */
    public function setListprice($listprice = null)
    {
        // validation for constraint: float
        if (!is_null($listprice) && !(is_float($listprice) || is_numeric($listprice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($listprice, true), gettype($listprice)), __LINE__);
        }
        $this->listprice = $listprice;
        return $this;
    }
    /**
     * Get qtybreaks value
     * @return \ArrayType\ArrayOfTVHWS_qtybreak|null
     */
    public function getQtybreaks()
    {
        return $this->qtybreaks;
    }
    /**
     * Set qtybreaks value
     * @param \ArrayType\ArrayOfTVHWS_qtybreak $qtybreaks
     * @return \StructType\TVHWS_price
     */
    public function setQtybreaks(\ArrayType\ArrayOfTVHWS_qtybreak $qtybreaks = null)
    {
        $this->qtybreaks = $qtybreaks;
        return $this;
    }
}
