<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unterkunftrequest StructType
 * @subpackage Structs
 */
class Unterkunftrequest extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $hausid;
    /**
     * The channelid
     * @var int
     */
    public $channelid;
    /**
     * The sterne
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $sterne;
    /**
     * The hauskategorien
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $hauskategorien;
    /**
     * The sprache
     * @var string
     */
    public $sprache;
    /**
     * The hauseigenschaften
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bookingtags[]
     */
    public $hauseigenschaften;
    /**
     * The kateigenschaften
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bookingtags[]
     */
    public $kateigenschaften;
    /**
     * The sortby
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sortby[]
     */
    public $sortby;
    /**
     * The einstellung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Einstellung[]
     */
    public $einstellung;
    /**
     * The restrict2hausname
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $restrict2hausname;
    /**
     * The wanttext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $wanttext;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $flags;
    /**
     * The bezirkids
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $bezirkids;
    /**
     * The baerchen
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $baerchen;
    /**
     * Constructor method for unterkunftrequest
     * @uses Unterkunftrequest::setOrtid()
     * @uses Unterkunftrequest::setHausid()
     * @uses Unterkunftrequest::setChannelid()
     * @uses Unterkunftrequest::setSterne()
     * @uses Unterkunftrequest::setHauskategorien()
     * @uses Unterkunftrequest::setSprache()
     * @uses Unterkunftrequest::setHauseigenschaften()
     * @uses Unterkunftrequest::setKateigenschaften()
     * @uses Unterkunftrequest::setSortby()
     * @uses Unterkunftrequest::setEinstellung()
     * @uses Unterkunftrequest::setRestrict2hausname()
     * @uses Unterkunftrequest::setWanttext()
     * @uses Unterkunftrequest::setFlags()
     * @uses Unterkunftrequest::setBezirkids()
     * @uses Unterkunftrequest::setBaerchen()
     * @param int $ortid
     * @param int[] $hausid
     * @param int $channelid
     * @param int[] $sterne
     * @param int[] $hauskategorien
     * @param string $sprache
     * @param \StructType\Bookingtags[] $hauseigenschaften
     * @param \StructType\Bookingtags[] $kateigenschaften
     * @param \StructType\Sortby[] $sortby
     * @param \StructType\Einstellung[] $einstellung
     * @param string[] $restrict2hausname
     * @param bool $wanttext
     * @param string[] $flags
     * @param int[] $bezirkids
     * @param int[] $baerchen
     */
    public function __construct($ortid = null, array $hausid = array(), $channelid = null, array $sterne = array(), array $hauskategorien = array(), $sprache = null, array $hauseigenschaften = array(), array $kateigenschaften = array(), array $sortby = array(), array $einstellung = array(), array $restrict2hausname = array(), $wanttext = null, array $flags = array(), array $bezirkids = array(), array $baerchen = array())
    {
        $this
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setChannelid($channelid)
            ->setSterne($sterne)
            ->setHauskategorien($hauskategorien)
            ->setSprache($sprache)
            ->setHauseigenschaften($hauseigenschaften)
            ->setKateigenschaften($kateigenschaften)
            ->setSortby($sortby)
            ->setEinstellung($einstellung)
            ->setRestrict2hausname($restrict2hausname)
            ->setWanttext($wanttext)
            ->setFlags($flags)
            ->setBezirkids($bezirkids)
            ->setBaerchen($baerchen);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Unterkunftrequest
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int[]|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * This method is responsible for validating the values passed to the setHausid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHausid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHausidForArrayConstraintsFromSetHausid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestHausidItem) {
            // validation for constraint: itemType
            if (!(is_int($unterkunftrequestHausidItem) || ctype_digit($unterkunftrequestHausidItem))) {
                $invalidValues[] = is_object($unterkunftrequestHausidItem) ? get_class($unterkunftrequestHausidItem) : sprintf('%s(%s)', gettype($unterkunftrequestHausidItem), var_export($unterkunftrequestHausidItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hausid property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hausid value
     * @throws \InvalidArgumentException
     * @param int[] $hausid
     * @return \StructType\Unterkunftrequest
     */
    public function setHausid(array $hausid = array())
    {
        // validation for constraint: array
        if ('' !== ($hausidArrayErrorMessage = self::validateHausidForArrayConstraintsFromSetHausid($hausid))) {
            throw new \InvalidArgumentException($hausidArrayErrorMessage, __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Add item to hausid value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToHausid($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The hausid property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hausid[] = $item;
        return $this;
    }
    /**
     * Get channelid value
     * @return int|null
     */
    public function getChannelid()
    {
        return $this->channelid;
    }
    /**
     * Set channelid value
     * @param int $channelid
     * @return \StructType\Unterkunftrequest
     */
    public function setChannelid($channelid = null)
    {
        // validation for constraint: int
        if (!is_null($channelid) && !(is_int($channelid) || ctype_digit($channelid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($channelid, true), gettype($channelid)), __LINE__);
        }
        $this->channelid = $channelid;
        return $this;
    }
    /**
     * Get sterne value
     * @return int[]|null
     */
    public function getSterne()
    {
        return $this->sterne;
    }
    /**
     * This method is responsible for validating the values passed to the setSterne method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSterne method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSterneForArrayConstraintsFromSetSterne(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestSterneItem) {
            // validation for constraint: itemType
            if (!(is_int($unterkunftrequestSterneItem) || ctype_digit($unterkunftrequestSterneItem))) {
                $invalidValues[] = is_object($unterkunftrequestSterneItem) ? get_class($unterkunftrequestSterneItem) : sprintf('%s(%s)', gettype($unterkunftrequestSterneItem), var_export($unterkunftrequestSterneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sterne property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sterne value
     * @throws \InvalidArgumentException
     * @param int[] $sterne
     * @return \StructType\Unterkunftrequest
     */
    public function setSterne(array $sterne = array())
    {
        // validation for constraint: array
        if ('' !== ($sterneArrayErrorMessage = self::validateSterneForArrayConstraintsFromSetSterne($sterne))) {
            throw new \InvalidArgumentException($sterneArrayErrorMessage, __LINE__);
        }
        $this->sterne = $sterne;
        return $this;
    }
    /**
     * Add item to sterne value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToSterne($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The sterne property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sterne[] = $item;
        return $this;
    }
    /**
     * Get hauskategorien value
     * @return int[]|null
     */
    public function getHauskategorien()
    {
        return $this->hauskategorien;
    }
    /**
     * This method is responsible for validating the values passed to the setHauskategorien method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHauskategorien method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHauskategorienForArrayConstraintsFromSetHauskategorien(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestHauskategorienItem) {
            // validation for constraint: itemType
            if (!(is_int($unterkunftrequestHauskategorienItem) || ctype_digit($unterkunftrequestHauskategorienItem))) {
                $invalidValues[] = is_object($unterkunftrequestHauskategorienItem) ? get_class($unterkunftrequestHauskategorienItem) : sprintf('%s(%s)', gettype($unterkunftrequestHauskategorienItem), var_export($unterkunftrequestHauskategorienItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hauskategorien property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hauskategorien value
     * @throws \InvalidArgumentException
     * @param int[] $hauskategorien
     * @return \StructType\Unterkunftrequest
     */
    public function setHauskategorien(array $hauskategorien = array())
    {
        // validation for constraint: array
        if ('' !== ($hauskategorienArrayErrorMessage = self::validateHauskategorienForArrayConstraintsFromSetHauskategorien($hauskategorien))) {
            throw new \InvalidArgumentException($hauskategorienArrayErrorMessage, __LINE__);
        }
        $this->hauskategorien = $hauskategorien;
        return $this;
    }
    /**
     * Add item to hauskategorien value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToHauskategorien($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The hauskategorien property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hauskategorien[] = $item;
        return $this;
    }
    /**
     * Get sprache value
     * @return string|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * Set sprache value
     * @param string $sprache
     * @return \StructType\Unterkunftrequest
     */
    public function setSprache($sprache = null)
    {
        // validation for constraint: string
        if (!is_null($sprache) && !is_string($sprache)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprache, true), gettype($sprache)), __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Get hauseigenschaften value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bookingtags[]|null
     */
    public function getHauseigenschaften()
    {
        return isset($this->hauseigenschaften) ? $this->hauseigenschaften : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHauseigenschaften method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHauseigenschaften method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHauseigenschaftenForArrayConstraintsFromSetHauseigenschaften(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestHauseigenschaftenItem) {
            // validation for constraint: itemType
            if (!$unterkunftrequestHauseigenschaftenItem instanceof \StructType\Bookingtags) {
                $invalidValues[] = is_object($unterkunftrequestHauseigenschaftenItem) ? get_class($unterkunftrequestHauseigenschaftenItem) : sprintf('%s(%s)', gettype($unterkunftrequestHauseigenschaftenItem), var_export($unterkunftrequestHauseigenschaftenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hauseigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hauseigenschaften value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags[] $hauseigenschaften
     * @return \StructType\Unterkunftrequest
     */
    public function setHauseigenschaften(array $hauseigenschaften = array())
    {
        // validation for constraint: array
        if ('' !== ($hauseigenschaftenArrayErrorMessage = self::validateHauseigenschaftenForArrayConstraintsFromSetHauseigenschaften($hauseigenschaften))) {
            throw new \InvalidArgumentException($hauseigenschaftenArrayErrorMessage, __LINE__);
        }
        if (is_null($hauseigenschaften) || (is_array($hauseigenschaften) && empty($hauseigenschaften))) {
            unset($this->hauseigenschaften);
        } else {
            $this->hauseigenschaften = $hauseigenschaften;
        }
        return $this;
    }
    /**
     * Add item to hauseigenschaften value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToHauseigenschaften(\StructType\Bookingtags $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bookingtags) {
            throw new \InvalidArgumentException(sprintf('The hauseigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hauseigenschaften[] = $item;
        return $this;
    }
    /**
     * Get kateigenschaften value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bookingtags[]|null
     */
    public function getKateigenschaften()
    {
        return isset($this->kateigenschaften) ? $this->kateigenschaften : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKateigenschaften method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKateigenschaften method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKateigenschaftenForArrayConstraintsFromSetKateigenschaften(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestKateigenschaftenItem) {
            // validation for constraint: itemType
            if (!$unterkunftrequestKateigenschaftenItem instanceof \StructType\Bookingtags) {
                $invalidValues[] = is_object($unterkunftrequestKateigenschaftenItem) ? get_class($unterkunftrequestKateigenschaftenItem) : sprintf('%s(%s)', gettype($unterkunftrequestKateigenschaftenItem), var_export($unterkunftrequestKateigenschaftenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kateigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kateigenschaften value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags[] $kateigenschaften
     * @return \StructType\Unterkunftrequest
     */
    public function setKateigenschaften(array $kateigenschaften = array())
    {
        // validation for constraint: array
        if ('' !== ($kateigenschaftenArrayErrorMessage = self::validateKateigenschaftenForArrayConstraintsFromSetKateigenschaften($kateigenschaften))) {
            throw new \InvalidArgumentException($kateigenschaftenArrayErrorMessage, __LINE__);
        }
        if (is_null($kateigenschaften) || (is_array($kateigenschaften) && empty($kateigenschaften))) {
            unset($this->kateigenschaften);
        } else {
            $this->kateigenschaften = $kateigenschaften;
        }
        return $this;
    }
    /**
     * Add item to kateigenschaften value
     * @throws \InvalidArgumentException
     * @param \StructType\Bookingtags $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToKateigenschaften(\StructType\Bookingtags $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bookingtags) {
            throw new \InvalidArgumentException(sprintf('The kateigenschaften property can only contain items of type \StructType\Bookingtags, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kateigenschaften[] = $item;
        return $this;
    }
    /**
     * Get sortby value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sortby[]|null
     */
    public function getSortby()
    {
        return isset($this->sortby) ? $this->sortby : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSortby method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSortby method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSortbyForArrayConstraintsFromSetSortby(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestSortbyItem) {
            // validation for constraint: itemType
            if (!$unterkunftrequestSortbyItem instanceof \StructType\Sortby) {
                $invalidValues[] = is_object($unterkunftrequestSortbyItem) ? get_class($unterkunftrequestSortbyItem) : sprintf('%s(%s)', gettype($unterkunftrequestSortbyItem), var_export($unterkunftrequestSortbyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sortby property can only contain items of type \StructType\Sortby, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sortby value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sortby[] $sortby
     * @return \StructType\Unterkunftrequest
     */
    public function setSortby(array $sortby = array())
    {
        // validation for constraint: array
        if ('' !== ($sortbyArrayErrorMessage = self::validateSortbyForArrayConstraintsFromSetSortby($sortby))) {
            throw new \InvalidArgumentException($sortbyArrayErrorMessage, __LINE__);
        }
        if (is_null($sortby) || (is_array($sortby) && empty($sortby))) {
            unset($this->sortby);
        } else {
            $this->sortby = $sortby;
        }
        return $this;
    }
    /**
     * Add item to sortby value
     * @throws \InvalidArgumentException
     * @param \StructType\Sortby $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToSortby(\StructType\Sortby $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sortby) {
            throw new \InvalidArgumentException(sprintf('The sortby property can only contain items of type \StructType\Sortby, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sortby[] = $item;
        return $this;
    }
    /**
     * Get einstellung value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Einstellung[]|null
     */
    public function getEinstellung()
    {
        return isset($this->einstellung) ? $this->einstellung : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEinstellung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEinstellung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEinstellungForArrayConstraintsFromSetEinstellung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestEinstellungItem) {
            // validation for constraint: itemType
            if (!$unterkunftrequestEinstellungItem instanceof \StructType\Einstellung) {
                $invalidValues[] = is_object($unterkunftrequestEinstellungItem) ? get_class($unterkunftrequestEinstellungItem) : sprintf('%s(%s)', gettype($unterkunftrequestEinstellungItem), var_export($unterkunftrequestEinstellungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The einstellung property can only contain items of type \StructType\Einstellung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set einstellung value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Einstellung[] $einstellung
     * @return \StructType\Unterkunftrequest
     */
    public function setEinstellung(array $einstellung = array())
    {
        // validation for constraint: array
        if ('' !== ($einstellungArrayErrorMessage = self::validateEinstellungForArrayConstraintsFromSetEinstellung($einstellung))) {
            throw new \InvalidArgumentException($einstellungArrayErrorMessage, __LINE__);
        }
        if (is_null($einstellung) || (is_array($einstellung) && empty($einstellung))) {
            unset($this->einstellung);
        } else {
            $this->einstellung = $einstellung;
        }
        return $this;
    }
    /**
     * Add item to einstellung value
     * @throws \InvalidArgumentException
     * @param \StructType\Einstellung $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToEinstellung(\StructType\Einstellung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Einstellung) {
            throw new \InvalidArgumentException(sprintf('The einstellung property can only contain items of type \StructType\Einstellung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->einstellung[] = $item;
        return $this;
    }
    /**
     * Get restrict2hausname value
     * @return string[]|null
     */
    public function getRestrict2hausname()
    {
        return $this->restrict2hausname;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrict2hausname method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrict2hausname method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrict2hausnameForArrayConstraintsFromSetRestrict2hausname(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestRestrict2hausnameItem) {
            // validation for constraint: itemType
            if (!is_string($unterkunftrequestRestrict2hausnameItem)) {
                $invalidValues[] = is_object($unterkunftrequestRestrict2hausnameItem) ? get_class($unterkunftrequestRestrict2hausnameItem) : sprintf('%s(%s)', gettype($unterkunftrequestRestrict2hausnameItem), var_export($unterkunftrequestRestrict2hausnameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The restrict2hausname property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set restrict2hausname value
     * @throws \InvalidArgumentException
     * @param string[] $restrict2hausname
     * @return \StructType\Unterkunftrequest
     */
    public function setRestrict2hausname(array $restrict2hausname = array())
    {
        // validation for constraint: array
        if ('' !== ($restrict2hausnameArrayErrorMessage = self::validateRestrict2hausnameForArrayConstraintsFromSetRestrict2hausname($restrict2hausname))) {
            throw new \InvalidArgumentException($restrict2hausnameArrayErrorMessage, __LINE__);
        }
        $this->restrict2hausname = $restrict2hausname;
        return $this;
    }
    /**
     * Add item to restrict2hausname value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToRestrict2hausname($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The restrict2hausname property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->restrict2hausname[] = $item;
        return $this;
    }
    /**
     * Get wanttext value
     * @return bool|null
     */
    public function getWanttext()
    {
        return $this->wanttext;
    }
    /**
     * Set wanttext value
     * @param bool $wanttext
     * @return \StructType\Unterkunftrequest
     */
    public function setWanttext($wanttext = null)
    {
        // validation for constraint: boolean
        if (!is_null($wanttext) && !is_bool($wanttext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wanttext, true), gettype($wanttext)), __LINE__);
        }
        $this->wanttext = $wanttext;
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFlags method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlags method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlagsForArrayConstraintsFromSetFlags(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestFlagsItem) {
            // validation for constraint: itemType
            if (!is_string($unterkunftrequestFlagsItem)) {
                $invalidValues[] = is_object($unterkunftrequestFlagsItem) ? get_class($unterkunftrequestFlagsItem) : sprintf('%s(%s)', gettype($unterkunftrequestFlagsItem), var_export($unterkunftrequestFlagsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The flags property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $flags
     * @return \StructType\Unterkunftrequest
     */
    public function setFlags(array $flags = array())
    {
        // validation for constraint: array
        if ('' !== ($flagsArrayErrorMessage = self::validateFlagsForArrayConstraintsFromSetFlags($flags))) {
            throw new \InvalidArgumentException($flagsArrayErrorMessage, __LINE__);
        }
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
    /**
     * Add item to flags value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToFlags($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The flags property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->flags[] = $item;
        return $this;
    }
    /**
     * Get bezirkids value
     * @return int[]|null
     */
    public function getBezirkids()
    {
        return $this->bezirkids;
    }
    /**
     * This method is responsible for validating the values passed to the setBezirkids method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezirkids method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezirkidsForArrayConstraintsFromSetBezirkids(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestBezirkidsItem) {
            // validation for constraint: itemType
            if (!(is_int($unterkunftrequestBezirkidsItem) || ctype_digit($unterkunftrequestBezirkidsItem))) {
                $invalidValues[] = is_object($unterkunftrequestBezirkidsItem) ? get_class($unterkunftrequestBezirkidsItem) : sprintf('%s(%s)', gettype($unterkunftrequestBezirkidsItem), var_export($unterkunftrequestBezirkidsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezirkids property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezirkids value
     * @throws \InvalidArgumentException
     * @param int[] $bezirkids
     * @return \StructType\Unterkunftrequest
     */
    public function setBezirkids(array $bezirkids = array())
    {
        // validation for constraint: array
        if ('' !== ($bezirkidsArrayErrorMessage = self::validateBezirkidsForArrayConstraintsFromSetBezirkids($bezirkids))) {
            throw new \InvalidArgumentException($bezirkidsArrayErrorMessage, __LINE__);
        }
        $this->bezirkids = $bezirkids;
        return $this;
    }
    /**
     * Add item to bezirkids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToBezirkids($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The bezirkids property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezirkids[] = $item;
        return $this;
    }
    /**
     * Get baerchen value
     * @return int[]|null
     */
    public function getBaerchen()
    {
        return $this->baerchen;
    }
    /**
     * This method is responsible for validating the values passed to the setBaerchen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaerchen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaerchenForArrayConstraintsFromSetBaerchen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unterkunftrequestBaerchenItem) {
            // validation for constraint: itemType
            if (!(is_int($unterkunftrequestBaerchenItem) || ctype_digit($unterkunftrequestBaerchenItem))) {
                $invalidValues[] = is_object($unterkunftrequestBaerchenItem) ? get_class($unterkunftrequestBaerchenItem) : sprintf('%s(%s)', gettype($unterkunftrequestBaerchenItem), var_export($unterkunftrequestBaerchenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The baerchen property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set baerchen value
     * @throws \InvalidArgumentException
     * @param int[] $baerchen
     * @return \StructType\Unterkunftrequest
     */
    public function setBaerchen(array $baerchen = array())
    {
        // validation for constraint: array
        if ('' !== ($baerchenArrayErrorMessage = self::validateBaerchenForArrayConstraintsFromSetBaerchen($baerchen))) {
            throw new \InvalidArgumentException($baerchenArrayErrorMessage, __LINE__);
        }
        $this->baerchen = $baerchen;
        return $this;
    }
    /**
     * Add item to baerchen value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Unterkunftrequest
     */
    public function addToBaerchen($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The baerchen property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->baerchen[] = $item;
        return $this;
    }
}
